pro r_hydra_other

   common time,xut1,xut2
   common get_error, get_err_no, get_err_msg
   common hydra_other_data, other_header, other_data, hydra_values

     my_name='r_hydra_other'
     module_name='HYDRA-other'

     forward_function convert_date_to_t90
     
     get_err_no=1
     get_err_msg= my_name +': unidentified error'

; read data files for time period
   num_files_read=0
   time=xut1
   while time-1 lt xut2 do begin
      day_start= time / 86400 * 86400
      start_time= time - day_start
;          end_time is xut2 or midnight, whichever is sooner...
      end_time= min( [ ( (time+1)/86400 +1) * 86400, xut2 ] ) 
      end_time= end_time - day_start 
      convert_t90_to_date,time, year,doy,h,m,s,month,cm,day_om ; y2k
      if year lt 100 then year= year+1900
      date_str=string(year,month,day_om,format="(i4.4,i2.2,i2.2)")       
      
      if start_time ne end_time then begin
          r_hydra_other_oneday, date_str, start_time, end_time, $
            other_header, data_values, hydra_values1
         
         if get_err_no eq 0 then BEGIN
            num_files_read =  num_files_read + 1
            data_values(*).time = $
              data_values(*).time  + ( day_start - other_header.start_time )
            hydra_values1(*).time = $
              hydra_values1(*).time  + ( day_start - other_header.start_time )
            if (num_files_read eq 1) then begin
                data_buf= [ data_values ]
                data_buf2= [ hydra_values1 ]
            endif else begin
                data_buf = [ data_buf, data_values ]
                data_buf2= [ data_buf2, hydra_values1 ]
            endelse
         endif       
      ENDIF

      time=day_start+86400           ; prepare to read next day

   endwhile
   
   if (n_elements(data_buf) gt 0) then begin
       other_data= data_buf
       hydra_values= data_buf2
       get_err_no=0             ; all's well
   endif else begin
       get_err_no=2
       print,get_err_msg
       return
   endelse
   
   print,'Read '+module_name+': done'

   return
end


pro r_hydra_other_oneday, date_str, start_time, end_time, $
                          data_header, data_values, hydra_values

  common  get_error, get_err_no, get_err_msg

  myname= 'r_hydra_other_oneday'

  get_err_no=0

  f= hydra_findfile( date_str, /survey, vers=vers )
  if (f ne '') then begin
      print, myname+': opening '+f+'...'
      CDF= cdf_open(f)
      n= strlen(f)
      data_header.data_version= vers
      survey=1
  endif else begin
      f= hydra_findfile( date_str, /ddcal, vers=vers )
      if vers ge 1.80 then begin
          message, 'opening '+f+'...', /cont
          CDF= cdf_open(f)
          data_header.data_version= vers
          survey=0
      endif else begin
          get_err_no=1
          get_err_msg='Couldn''t find survey or v1.8 level1 file.'
          return
      endelse
  endelse
  
  if survey then suffix='' else suffix='_OR'
  cdf_control, cdf, variable='ORBIT_TIME'+suffix, get_var_info=r
  cdf_varget, cdf, 'ORBIT_TIME'+suffix, orbit_time, rec_count=r.maxrec-1

  rec_start_orbit = ( where( orbit_time+60 ge start_time ) )(0)
  if rec_start_orbit(0) eq -1 then begin
      get_err_msg= myname+': No data found after start_time '
      print, get_err_msg
      get_err_num = 1
      return
  endif
  rec_count_orbit= n_elements( where( orbit_time(rec_start_orbit:*) le $
                                      end_time and $
                                      orbit_time(rec_start_orbit:*) $
                                      ge start_time, $
                                      count )) + 2

  if ( count le 2 ) then begin
      get_err_msg= myname+': No data found between start and end times '
      get_err_no= 1
      print, get_err_msg           
      return
  endif      

; Read in the 'ephem' data
  cdf_varget, cdf, 'GSM_POS'+suffix, gsm_pos, $
    rec_start=rec_start_orbit, rec_count=rec_count_orbit
  radius =  sqrt(gsm_pos(0,*)^2 + gsm_pos(1,*)^2 + gsm_pos(2,*)^2)
  cdf_varget, cdf, 'L_SHELL'+suffix, lshell, $
    rec_start=rec_start_orbit, rec_count=rec_count_orbit
  cdf_varget, cdf, 'MLT'+suffix, mlt, $
    rec_start=rec_start_orbit, rec_count=rec_count_orbit
  cdf_varget, cdf, 'MAG_LATITUDE'+suffix, mag_latitude, $
    rec_start=rec_start_orbit, rec_count=rec_count_orbit
  
  ilt = acos(sqrt(1./lshell))*180./!pi ; the magnetic latitude of the footprint of the field line you're on...i.e. the magnetic latitude of the spot where the field line would touch the surface of the earth
  
; Apply the sign of mag_latitude to ilt
  mag_latitude = reform(mag_latitude)
  ilt = reform(ilt)
  sign_mask = mag_latitude/abs(mag_latitude)
  ilt = ilt*sign_mask

  data_values2 = {hydra_other_data2, $
                  time:float(0), $
                  ilt:float(0), $
                  mlt:float(0), $
                  radius:float(0), $
                  lshell:float(0), $
                  maglat:float(0), $
                  xgsm:float(0),$
                  ygsm:float(0),$
                  zgsm:float(0) $
                  }
  
  data_values = replicate( data_values2, rec_count_orbit )

  rr = lindgen(rec_count_orbit)
  data_values(rr).time = orbit_time(rec_start_orbit +rr )  
  data_values(rr).lshell = reform(lshell)
  data_values(rr).radius = reform(radius)
  data_values(rr).mlt =  reform(mlt)
  data_values(rr).ilt =  reform(ilt)
  data_values(rr).maglat = reform(mag_latitude)
  data_values(rr).xgsm = reform(gsm_pos(0,*))
  data_values(rr).ygsm = reform(gsm_pos(1,*))
  data_values(rr).zgsm = reform(gsm_pos(2,*))

  

  if survey then name='TIME' else name='BLOCK_TIME'
  cdf_control, cdf, variable=name, get_var_info=r
  cdf_varget, cdf, name, time, rec_count=r.maxrec
  if not survey then time= (time mod 86400000) / 1000
  
  rec_start = ( where( time+13.8 ge start_time ) )(0)
  if rec_start(0) eq -1 then begin
      get_err_msg= myname+': No data found after start_time '
      print, get_err_msg
      get_err_num = 1
      return
  endif
  rec_count= n_elements( where( time(rec_start:*) le $
                                end_time and $
                                time(rec_start:*) $
                                ge start_time, $
                                count )) + 2 < ( 6272 - rec_start )
  hydra_values1= { hydra_other_data3, $
                   time:double(0), $
                   sc_pot:fltarr(4), $ ; 0=best, 1=berk, 2=hydra, 3=goddard
                   back_ele:1e31, $
                   back_ion:1e31, $
                   back_ppa:1e31, $
                   psi_status:0, $
                   mode:0 $
                 }
  hydra_values= replicate( hydra_values1, rec_count )

  if survey then name='TIME' else name='BLOCK_TIME'
  cdf_varget, cdf, name, time, rec_start=rec_start, rec_count=rec_count
  if not survey then time= (time mod 86400000) / 1000
  hydra_values(*).time=time(*)
                 
  if survey then begin
      cdf_varget, cdf, 'BACK_ION', values, $
        rec_start=rec_start, rec_count=rec_count
      hydra_values(*).back_ion= 10^ (values(*)/1000.)
      cdf_varget, cdf, 'BACK_ELE', values, $
        rec_start=rec_start, rec_count=rec_count
      hydra_values(*).back_ele= 10^ (values(*)/1000.)
  endif

  if survey then begin
      cdf_varget, cdf, 'MODE', mode, rec_start=rec_start, rec_count=rec_count
      hydra_values(*).mode=mode(*)
      cdf_varget, cdf, 'STATUS', psi_stat, $
        rec_start=rec_start, rec_count=rec_count
      hydra_values(*).psi_status= psi_stat(*)
  endif else begin
      cdf_varget, cdf, 'BLOCK_MODE', mode, $
        rec_start=rec_start, rec_count=rec_count
      hydra_values(*).mode=mode(*)    
      cdf_varget, cdf, 'PSI_STATUS', psi_stat, $
        rec_start=rec_start, rec_count=rec_count
      hydra_values(*).psi_status= psi_stat(*)
  endelse

  name= 'SC_POT_PHYS' 
  new_scpot= cdf_varexist( cdf, name )
  if new_scpot then begin
      cdf_varget, cdf, name, values, rec_start=rec_start, rec_count=rec_count
      hydra_values(*).sc_pot(0)=values(*)
      r= where( values eq 1e-31 )
      if r(0) ne -1 then hydra_values(r).sc_pot(0)=1e31
      message, 'Using "physical potential."', /cont      
  endif else begin
      if survey then name='SC_POT' else name='SC_POT'
      cdf_varget, cdf, name, values, rec_start=rec_start, rec_count=rec_count
      message, 'Added 2V to what is probably the engineering potential', /cont
      r= where( values eq 1e-31 )
      if r(0) ne -1 then hydra_values(r).sc_pot(0)=1e31
  endelse

  if survey then name='SC_POT_BERKELEY' else name='SC_POT_BERK'
  cdf_varget, cdf, name, values, rec_start=rec_start, rec_count=rec_count
  hydra_values(*).sc_pot(1)=values(*)
  r= where( values eq 1e-31 )
  if r(0) ne -1 then hydra_values(r).sc_pot(1)=1e31
  
  if (survey and vers lt 1.34) or (not survey and vers lt 1.80 ) then begin
      hydra_values(*).sc_pot(2)=1e31
      hydra_values(*).sc_pot(3)=1e31
      cdf_close, cdf
      return
  endif
                 
  if survey then name='SC_POT_HYDRA' else name='SC_POT_HYDRA'
  cdf_varget, cdf, name, values, rec_start=rec_start, rec_count=rec_count
  hydra_values(*).sc_pot(2)=values(*)
  r= where( values eq 1e-31 )
  if r(0) ne -1 then hydra_values(r).sc_pot(2)=1e31
                 
  if survey then name='SC_POT_GSFC' else name='SC_POT_GSFC'
  cdf_varget, cdf, name, values, rec_start=rec_start, rec_count=rec_count
  hydra_values(*).sc_pot(3)=values(*)
  r= where( values eq 1e-31 )
  if r(0) ne -1 then hydra_values(r).sc_pot(3)=1e31

  cdf_close, cdf

  return
end
