PRO r_hydra_ppa

common time,xut1,xut2
common get_error, get_err_no, get_err_msg
common hydra_ppa_data, $
  ppa_header, $
  ppa_l1_data, $
  ppa_l1_support, $
  ppa_spec_data, $
  ppa_aligned_data, $
  ppa_opposed_data, $
  ppa_perp_data, $
  ppa_skew_data

my_name='r_hydra_ppa'
module_name='HYDRA-ppa'

IF n_elements( ppa_header ) EQ 0 THEN BEGIN 
    ppah1={ hydra_ppa_dum_header, $
            start_time:long(0), $
            end_time:long(0), $
            data_version:float(0), $
            reload_flag:fix(0), $
            ncalc:0, $
            recalc_flag:intarr(5) $ ; All,Aligned,Perp,Opposed,Skew
          }
    ppa_header = ppah1
ENDIF
ppa_header.start_time=xut1
ppa_header.end_time=xut2
ppa_header.reload_flag=1
ppa_header.ncalc = 5
ppa_header.recalc_flag = 1

forward_function convert_date_to_t90

get_err_no=0
get_err_msg= my_name +': data-file read succesfully'

; read data files for time period

; First figure out how many different energy sequences are encountered
; throughout the specified time period
convert_t90_to_date,xut1,year1,doy1,h1,m1,s1,mo1,cmo1,dom1
convert_t90_to_date,xut2-1,year2,doy2,h2,m2,s2,mo2,cmo2,dom2 ; Take 1 off of xut2 so that if your end time is YYYYMMDD/24:00:00, we're only investigating the energy sequences up to and including YYYYMMDD and not YYYYMMDD+1
j1 = long(julday(mo1,dom1,year1)) ; Julian day
j2 = long(julday(mo2,dom2,year2)) ; Julian day
for jday = j1,j2 do begin
    caldat, jday, mo, dom, year
    datestr = string(year,'(i4.4)')+string(mo,'(i2.2)')+string(dom,'(i2.2)')
    init_ppa_l1, datestr, ppa_info, status=status
    if (status ne 0) then begin
        if (n_elements(all_modes) eq 0) then all_modes = ppa_info.mode else $
          all_modes = [all_modes,ppa_info.mode]
        eseq_thisday = ppa_info.energy_sequence_rectime(uniq(ppa_info.energy_sequence_rectime(0:ppa_info.n_rectime-1),sort(ppa_info.energy_sequence_rectime(0:ppa_info.n_rectime-1))))
        if (n_elements(eseq) eq 0) then eseq = eseq_thisday else $
          eseq = [eseq, eseq_thisday]
    endif
endfor
if (n_elements(eseq) ne 0) then eseq_uniq = eseq(uniq(eseq,sort(eseq))) else eseq_uniq = -1 ; Energy sequences encountered
if (n_elements(all_modes) ne 0) then begin
    ppa_mode = min(all_modes)
    if (min(all_modes) ne max(all_modes)) then begin
        get_err_no = 2
        get_err_msg = my_name +': Cannot cross Mode 1/40 boundaries at this time; this only affects one day'
        return
    endif
endif else begin
    ppa_mode = -1
endelse

num_files_read = 0
time=xut1                       ; t90 is seconds since 19900101:00:00:00
while time-1 lt xut2 do begin
    day_start= time / 86400 * 86400 ; t90 at 00:00:00 of ith day in series
    start_time= time - day_start ; start_time in seconds since midnight on ith day
;          end_time is xut2 or midnight, whichever is sooner...
    end_time= min( [ ( (time+1)/86400 +1) * 86400, xut2 ] ) 
    end_time= end_time - day_start ; end_time in seconds since midnight on ith day
    convert_t90_to_date,time, year,doy,h,m,s,month,cm,day_om ; y2k    
    if year lt 100 then year=year+1900
    date_str=string(year,month,day_om,format="(i4.4,i2.2,i2.2)")       
    
    if start_time ne end_time then begin
        r_hydra_ppa_oneday, date_str, start_time, end_time, data_values, data_support, eseq_uniq=eseq_uniq, ppa_mode=ppa_mode
        
        if get_err_no eq 0 then BEGIN
            num_files_read = num_files_read + 1
            data_values(*).time= $
              data_values(*).time + ( day_start - xut1 ) ; time in seconds since ppa_header.start_time
            IF (num_files_read EQ 1) THEN BEGIN
                data_buf = [data_values]
            ENDIF ELSE BEGIN
                data_buf = [data_buf,data_values]
            ENDELSE
            
        endif       
    ENDIF
    
    time=day_start+86400        ; prepare to read next day
endwhile

if (n_elements(data_buf) gt 0) then BEGIN
    ppa_l1_data = data_buf
    ppa_l1_support = data_support
    get_err_no=0                ; all's well
endif else begin
    get_err_no=2
    print,get_err_msg
    return
endelse

print,'Read '+module_name+': done'

return
end


pro r_hydra_ppa_oneday, date_str, start_time, end_time, data_values, data_support, eseq_uniq=eseq_uniq, ppa_mode=ppa_mode

common  get_error, get_err_no, get_err_msg
common hydra_ppa_data, $
  ppa_header, $
  ppa_l1_data, $
  ppa_l1_support, $
  ppa_spec_data, $
  ppa_aligned_data, $
  ppa_opposed_data, $
  ppa_perp_data, $
  ppa_skew_data

common data_structures, ppa_mode_init, eseq_uniq_init, $
  data_support_init, data_values_init

myname= 'r_hydra_ppa_oneday'

; READ THE PPA DATA FROM THE PPA LEVEL1 FILE =================
init_ppa_l1, date_str, ppa_info, status=status, error_msg=error_msg
IF (status EQ 0) THEN BEGIN 
    get_err_no = 1
    get_err_msg = error_msg
    return
ENDIF
print, date_str, start_time/3600., end_time/3600.
recnum = find_ppa_recnum([start_time/3600.,end_time/3600.],ppa_info,$ 
                         status=status, error_msg=error_msg)
IF (status EQ 0) THEN BEGIN 
    get_err_no = 1
    get_err_msg = error_msg
    return
ENDIF   
read_ppa_l1, recnum, ppa_data, ppa_info, /close_cdf

; Initialize the data structures depending on the mode and number of
; energy sequences encountered
if (n_elements(ppa_mode_init) eq 0) then begin ; First time through
    ppa_mode_init = ppa_mode
    eseq_uniq_init = eseq_uniq
    nen = n_elements(eseq_uniq)*ppa_info.nen
    pfill = 1.e+31
    
    data_values_init = {time:0.0, $
                        dt:0.0, $
                        counts_tot:fltarr(nen), $ ; Raw counts summed over p.a.
                        counts_tot_mbg:fltarr(nen), $ ; 'mbg' = minus background
                        cps_tot:fltarr(nen), $ ; Raw counts/v.t. summed over p.a.
                        cps_tot_mbg:fltarr(nen), $ ; 'mbg' = minus background
                        background_cps:0.0, $
                        background_raw:0.0}
    data_support_init = {nbin:ppa_info.nbin,nen:nen,nen_nominal:ppa_info.nen, $
                         t_meas:ppa_info.t_meas, $
                         overflow_divisor:ppa_info.overflow_divisor,$
                         energy:fltarr(nen), $
                         alpha:ppa_info.alpha,time_offset:fltarr(nen), $
                         width:ppa_info.width,pfill:pfill}
endif else if ( (ppa_mode_init ne ppa_mode) or $
                (n_elements(eseq_uniq_init) ne n_elements(eseq_uniq)) or $
                (sqrt(total(eseq_uniq_init^2)) ne sqrt(total(eseq_uniq^2))) ) $
  then begin
    ppa_mode_init = ppa_mode
    eseq_uniq_init = eseq_uniq
    nen = n_elements(eseq_uniq)*ppa_info.nen
    pfill = 1.e+31
    
    data_values_init = {time:0.0, $
                        dt:0.0, $
                        counts_tot:fltarr(nen), $
                        counts_tot_mbg:fltarr(nen), $
                        cps_tot:fltarr(nen), $
                        cps_tot_mbg:fltarr(nen), $
                        background_cps:0.0, $
                        background_raw:0.0}    
    data_support_init = {nbin:ppa_info.nbin,nen:nen,nen_nominal:ppa_info.nen, $
                         t_meas:ppa_info.t_meas, $
                         overflow_divisor:ppa_info.overflow_divisor,$
                         energy:fltarr(nen), $
                         alpha:ppa_info.alpha,time_offset:fltarr(nen), $
                         width:ppa_info.width,pfill:pfill}
endif

pfill = data_support_init.pfill
ppa_header.data_version= float( ppa_info.product_version )
ntime = n_elements(ppa_data.time)
nen = data_support_init.nen
nbin = data_support_init.nbin
nen_nominal = data_support_init.nen_nominal

counts = make_array(nbin,nen,ntime,/float,value=pfill)
vt = make_array(nbin,nen,ntime,/float,value=pfill)
validb_flag = make_array(nen,ntime,/float,value=pfill)

eseq_string = strtrim(eseq_uniq,2)
zero = where(eseq_uniq eq 0)
if (zero(0) ne -1) then eseq_string(zero) = ''
istart = 0L
for ieseq = 0,n_elements(eseq_uniq)-1 do begin
    
    istat = execute('en = ppa_info.energy'+eseq_string(ieseq))
    if (n_elements(en) ne nen_nominal) then message, 'Something wrong...'
    
    if (n_elements(energy) eq 0) then energy = en else energy = [energy,en]
    if (n_elements(time_offset) eq 0) then time_offset = ppa_info.time_offset $
    else time_offset = [time_offset,ppa_info.time_offset]
    
    tt = where(ppa_data(*).energy_sequence eq eseq_uniq(ieseq))
    if (tt(0) ne -1) then begin
        counts(*,istart:istart+nen_nominal-1,tt) = ppa_data(tt).counts(*,*)
        vt(*,istart:istart+nen_nominal-1,tt) = ppa_data(tt).viewtime(*,*)
        validb_flag(istart:istart+nen_nominal-1,tt) = ppa_data(tt).validb_flag(*)
    endif
    istart = istart+nen_nominal

endfor
    
; Create counts/sec, total over all pitch-angles, apply validb_flag

counts_tot = make_array(nen,ntime,/float,value=pfill)
counts_tot_mbg = make_array(nen,ntime,/float,value=pfill)
cps_tot = make_array(nen,ntime,/float,value=pfill)
cps_tot_mbg = make_array(nen,ntime,/float,value=pfill)
background_cps = make_array(ntime,/float,value=pfill)
background_raw = make_array(ntime,/float,value=pfill)

;print, systime()
FOR ienergy=0,nen-1 DO BEGIN
    gdtime = where(validb_flag(ienergy,*) ne 0 and $
                   validb_flag(ienergy,*) ne pfill)
    if (gdtime(0) ne -1) then begin
        
        counts_tot(ienergy,gdtime) = total(counts(*,ienergy,gdtime),1,/double)
        
        cps_tot(ienergy,gdtime) = $
          total(counts(*,ienergy,gdtime) $
                /vt(*,ienergy,gdtime),1,/double)
    ENDIF 
ENDFOR
for itime = 0, ntime-1 do begin ; Decided there's no way around this time loop...
    valid = where(cps_tot(*,itime) NE pfill)
    IF (valid(0) NE -1) THEN BEGIN
        background_cps(itime) = min(cps_tot(valid,itime))
        cps_tot_mbg(valid,itime) = cps_tot(valid,itime) - $
          background_cps(itime)
    ENDIF
    valid = where(counts_tot(*,itime) NE pfill)
    IF (valid(0) NE -1) THEN BEGIN
        background_raw(itime) = min(counts_tot(valid,itime))
        counts_tot_mbg(valid,itime) = counts_tot(valid,itime) - $
          background_raw(itime)
    ENDIF
endfor
;print, systime()

; Define the support data
data_support = data_support_init
data_support.energy = energy
data_support.time_offset = time_offset

; Define the data
data_values = replicate( data_values_init, ntime )
r = lindgen(ntime)
data_values(r).time = reform(ppa_data.time)
data_values(r).dt = reform(ppa_data.dt)
data_values(r).counts_tot = counts_tot
data_values(r).counts_tot_mbg = counts_tot_mbg
data_values(r).cps_tot_mbg = cps_tot_mbg
data_values(r).cps_tot = cps_tot
data_values(r).background_cps = reform(background_cps)
data_values(r).background_raw = reform(background_raw)

;expand this out to the 256 buckets using the widths? Not needed since we're 
;ulitmately going to average/sum over pitch-angle

; Deallocate potentially huge arrays
ppa_info = 0.
ppa_data = 0.
vt =  0.
counts = 0.
valib_flag = 0.
cps = 0.
zero = 0.
nzero = 0.
invalid = 0.
cps_tot_mbg = 0.
cps_tot = 0.
counts_tot = 0.
counts_tot_mbg = 0.
background_cps = 0.
background_raw = 0.
return
END

