pro r_hydra_spec_new, context, panel=panel, options=options, $
                      papco=papco, tres=tres, file=file, $
                      include_detectors= include_detectors

   if n_elements( context ) eq 0 then return

   if n_elements( tres ) eq 0 then tres=1.15
   
   common time,xut1,xut2
   common get_error, get_err_no, get_err_msg
   common hydra_spec_data, $
     data_context, $            ; selects current data set
     spec_header, $
     spec_data, $
     spec_aligned_data, $
     spec_perp_data, $
     spec_opposed_data, $
     hr_spec_data, $
     hr_spec_aligned_data, $
     hr_spec_perp_data, $
     hr_spec_opposed_data
   
   module_name='HYDRA spec'

   forward_function convert_date_to_t90

   get_err_no=1
   get_err_msg= module_name +' Unidentified error occurred.'
   
   survey= context le 4
   
;  aop is a special mode that indicates that the aligned, opposed and perp
   aop= ( where( [ 1,2,3,4 ] eq (data_context mod 5) ) )(0) ne -1
   
   if keyword_set(papco) then begin 
       common papco_color_names
       panelset, panel
       gprogress= fltarr(6)
       gprogress(0:3)=!p.position
       gprogress(4)=1           ; foreground color
       gprogress(5)=red
   endif else begin
       gprogress=-1
   endelse

; read data files for time period
   num_files_read=0
   time=xut1
   while time-1 lt xut2 do begin
       day_start= time / 86400 * 86400
       start_time= time - day_start
;          end_time is xut2 or midnight, whichever is sooner...
       end_time= min( [ ( (time+1)/86400 +1) * 86400, xut2 ] )
       end_time= end_time - day_start
       convert_t90_to_date,time, year,doy,h,m,s,month,cm,day_om ;y2k
       if year lt 100 then year=year+1900
       date_str=string(year,month,day_om,format="(i4.4,i2.2,i2.2)")
       if end_time gt start_time then begin
           if survey then begin
               read_hydra_spec_sv, date_str, start_time, end_time, $
                 read_all= aop, options=options, $
                 all=all, data_all=data_all, $
                 up=up, data_up=data_up, $
                 dn=dn, data_dn=data_dn, $
                 perp=perp, data_perp=data_perp, file=file
           endif else begin     ; level1 read
               read_hydra_spec_l1, date_str, start_time, end_time, $
                 gprogress=gprogress, calc_all=aop, options=options, $
                 all=all, data_all=data_all, $
                 up=up, data_up=data_up, $
                 dn=dn, data_dn=data_dn, $
                 perp=perp, data_perp=data_perp, tres=tres, $
                 include_detectors=include_detectors
           endelse
           
           if get_err_no eq 0 then begin
               delta= day_start - xut1 
               data_all(*).time= data_all(*).time + delta
               if aop then begin
                   data_up(*).time= data_up(*).time + delta
                   data_perp(*).time= data_perp(*).time + delta
                   data_dn(*).time= data_dn(*).time + delta
               endif
               
               if (num_files_read eq 0) then begin
                   buf_all= [ data_all ]
                   if aop then begin
                       buf_up= [ data_up ]
                       buf_dn= [ data_dn ]
                       buf_perp= [ data_perp ]
                   endif
               endif else begin
                   buf_all= [ buf_all, data_all ]
                   if aop then begin
                       buf_up= [ buf_up, data_up ]
                       buf_perp= [ buf_perp, data_perp ]
                       buf_dn= [ buf_dn, data_dn ]
                   endif
               endelse
               num_files_read= num_files_read+1
           endif
       endif
       time=day_start+86400     ; prepare to read next day
   endwhile

   if num_files_read eq 0 then begin
       get_err_no=2
       print,get_err_msg
       return
   endif

;  message flag says that any messages regarding this data set have
;  not been seen. (Messages are only shown once.)
   all.message_flag= 1
   if aop then begin
       up.message_flag=1
       perp.message_flag=1
       dn.message_flag=1
   endif

  if (options and 1L) eq 1L then begin ; shift by S/C Potential
      hydra_shift, buf_all, all
      if aop then begin
          hydra_shift, buf_up, up
          hydra_shift, buf_perp, perp
          hydra_shift, buf_dn, dn
      endif
  endif

; At high-time resolutions, electron and ion sweeps are interleaved.
; We attempt to flag species of each data block (for the slicer).
;  look for spectra that are not all fill data (1e-20).
   n=n_elements( buf_all(0).spectrum )
   rspec= indgen(n/2)           ; electrons
   tot= total( buf_all(*).spectrum(rspec),1 )
   r= where( tot eq 0 or tot ge 1e-10 )
   if r(0) ne -1 then buf_all(r).species= buf_all(r).species or 1
   rspec= n-indgen(n/2)         ; ions
   tot= total( buf_all(*).spectrum(rspec),1 )
   r= where( tot eq 0 or tot ge 1e-10 )
   if r(0) ne -1 then buf_all(r).species= buf_all(r).species or 2
   
   if aop then begin
       buf_perp(*).species= buf_all(*).species
       buf_up(*).species= buf_all(*).species
       buf_dn(*).species= buf_all(*).species
   endif

; Copy our buffers back into the common blocks.
   data_all= buf_all & all.start_time=xut1 & all.end_time=xut2
   data_all.header_checksum= all.header_checksum
   if aop then begin
       data_up= buf_up & up.start_time=xut1 & up.end_time=xut2
       data_up.header_checksum= up.header_checksum
       data_perp= buf_perp & perp.start_time=xut1 & perp.end_time=xut2
       data_all.header_checksum= perp.header_checksum
       data_dn= buf_dn & dn.start_time=xut1 & dn.end_time=xut2
       data_dn.header_checksum= dn.header_checksum
   endif
   
; Copy the headers into papco storage.
   if n_elements( spec_header ) eq 0 then begin
       header1= all
       header1.start_time=0
       header1.end_time=0       
       spec_header= replicate( header1, 10 )
   endif
   if survey then begin
       spec_header(0)= all
       spec_header(0).data='spec_data'
       spec_data= data_all
       if aop then begin
           spec_header(1)= up
           spec_header(1).data='spec_aligned_data'
           spec_aligned_data= data_up          
           spec_header(2)= perp
           spec_header(2).data='spec_perp_data'
           spec_perp_data= data_perp
           spec_header(3)= dn
           spec_header(3).data='spec_opposed_data'
           spec_opposed_data= data_dn
       endif       
   endif else begin
       spec_header(5)= all
       spec_header(5).data='hr_spec_data'
       hr_spec_data= data_all
       if aop then begin
           spec_header(6)= up
           spec_header(6).data='hr_spec_aligned_data'
           hr_spec_aligned_data= data_up          
           spec_header(7)= perp
           spec_header(7).data='hr_spec_perp_data'
           hr_spec_perp_data= data_perp
           spec_header(8)= dn
           spec_header(8).data='hr_spec_opposed_data'
           hr_spec_opposed_data= data_dn
       endif
   endelse

   get_err_msg=' '
   get_err_no=0
   
   print,'Read '+module_name+': done'
   
   return
end


