pro r_hydra_tpp

common get_error, get_err_no, get_err_msg
common hydra_tpp_data, tpp_header, tpp_data
common hydra_label_maker_block
if (n_elements(tpp_spec_lab) eq 0) then hydra_label_maker, /tpp

my_name='r_hydra_tpp'
module_name='HYDRA-tpp'

get_err_no=1
get_err_msg= my_name +': unidentified error occurred.'

; Species Info
case tpp_header.data_species of
    0:begin
        specstr = 'ele'
        tstr = 'e!u-!n'
        n_factor = 1.
        kT_factor = 1.
        u_factor = 1.
        p_factor = 1.
    end
    1:begin
        specstr = 'ion'
        tstr = 'H!u+!n'
        n_factor = 1.
        kT_factor = 1.
        u_factor = 1.
        p_factor = 1.
    end
    2:begin
        specstr = 'ion'
        tstr = 'He!u+!n'
        n_factor = sqrt(4./1.)
        kT_factor = 1.
        u_factor = sqrt(1./4.)
        p_factor = sqrt(4.*1.)
    end
    3:begin
        specstr = 'ion'
        tstr = 'He!u++!n'
        n_factor = sqrt(4./2.)
        kT_factor = 2.
        u_factor = sqrt(2./4.)
        p_factor = sqrt(4.*2.)
    end
    4:begin
        specstr = 'ion'
        tstr = 'O!u+!n'
        n_factor = sqrt(16./1.)
        kT_factor = 1.
        u_factor = sqrt(1./16.)
        p_factor = sqrt(16.*1.)
    end
    else:begin
        get_err_no = 2
        get_err_msg = my_name +': species not defined'
        return
    end
endcase

; Resolution
rstr = tpp_res_rstr(tpp_header.data_res)

; Get timetags for time period
idstr = '_tpphr_'
hyd_access, tt, get_timetags=[gen_time(tpp_header.start_time,/t90), $
                              gen_time(tpp_header.end_time,/t90)], $
  specstr+idstr+'density'+'_'+rstr, dum, version=vers

if (n_elements(tt) eq 0 or n_elements(dum) le 1) then begin
    get_err_no = 2
    get_err_msg = my_name +': no data found'
    return
endif

tpp_data = {xdat:dblarr(n_elements(dum)), $
            ydat:dblarr(n_elements(dum)), $
            ylog:1, $
            tstr:tstr}

hyd_access, tt, 'time_bin_start_t90', xdat
tpp_data.xdat = xdat - tpp_header.start_time ; time in ssst

; The following cases correspond with the tpp labels defined by 
; 'hydra_label_maker.pro'
var = tpp_header.data_var
case 1 of
    var eq 0:begin
        hyd_access, tt, specstr+idstr+'density'+'_'+rstr, ydat
        ydat = hd_svmult(n_factor,ydat)
    end
    var eq 1:begin
        hyd_access, tt, specstr+idstr+'meane'+'_'+rstr, ydat
        ydat = hd_svmult(kt_factor,ydat)
    end
    var eq 2:begin
        hyd_access, tt, specstr+idstr+'ktparl'+'_'+rstr, ydat
        ydat = hd_svmult(kt_factor,ydat)
    end
    var eq 3:begin
        hyd_access, tt, specstr+idstr+'ktperp'+'_'+rstr, ydat
        ydat = hd_svmult(kt_factor,ydat)
    end
    var ge 4 and var le 7:begin
        hyd_access, tt, specstr+idstr+'u'+'_'+rstr, u
        if (var eq 7) then begin
            ydat = hd_svmult(u_factor,hd_magnitude(u))
            goto, case_out
        endif
        if (tpp_header.data_frame eq 1) then u = hd_pay_to_gse(tt,u)
        if (tpp_header.data_frame eq 2) then u = hd_pay_to_gsm(tt,u)
        tpp_data.ylog = 0
        case var of
            4:ydat = hd_svmult(u_factor,u(*,0))
            5:ydat = hd_svmult(u_factor,u(*,1))
            6:ydat = hd_svmult(u_factor,u(*,2))
        endcase
    end
    var eq 8:begin
        hyd_access, tt, specstr+idstr+'uparl'+'_'+rstr, ydat
        ydat = hd_svmult(u_factor,ydat)
        tpp_data.ylog = 0
    end
    var ge 9 and var le 12:begin
        hyd_access, tt, specstr+idstr+'uperp'+'_'+rstr, uperp
        if (var eq 12) then begin
            ydat = hd_svmult(u_factor,hd_magnitude(uperp))
            goto, case_out
        endif
        if (tpp_header.data_frame eq 1) then uperp = hd_pay_to_gse(tt,uperp)
        if (tpp_header.data_frame eq 2) then uperp = hd_pay_to_gsm(tt,uperp)
        tpp_data.ylog = 0
        case var of
            9:ydat = hd_svmult(u_factor,uperp(*,0))
            10:ydat = hd_svmult(u_factor,uperp(*,1))
            11:ydat = hd_svmult(u_factor,uperp(*,2))
        endcase        
    end
    var eq 13:hyd_access,tt,specstr+idstr+'anisotropy'+'_'+rstr, ydat
    var eq 14:hyd_access,tt,specstr+idstr+'gyrotropy'+'_'+rstr, ydat
    var eq 15:hyd_access,tt,specstr+idstr+'beta'+'_'+rstr, ydat
    var eq 16:begin
        hyd_access,tt,specstr+idstr+'patch_status'+'_'+rstr,ydat
        tpp_data.ylog = 0
    end
    var eq 17:hyd_access,tt,specstr+idstr+'min_energy'+'_'+rstr, ydat
    var eq 18:hyd_access,tt,specstr+idstr+'max_energy'+'_'+rstr, ydat
    var eq 19:hyd_access,tt,specstr+idstr+'rchi2'+'_'+rstr, ydat
    var eq 20:hyd_access,tt,specstr+idstr+'rchi2_all'+'_'+rstr, ydat
    var eq 21:hyd_access,tt,specstr+idstr+'npatch'+'_'+rstr, ydat
    var eq 22:hyd_access,tt,specstr+idstr+'angle_b'+'_'+rstr, ydat
    var ge 23 and var le 26:begin
        hyd_access, tt, specstr+idstr+'bmag'+'_'+rstr, bmag
        if (var eq 26) then begin
            ydat = bmag
            goto, case_out
        endif
        hyd_access, tt, specstr+idstr+'bhat'+'_'+rstr, bhat
        b = hd_svmult(bmag,bhat)
        bhat = 0                ; de-allocate
        bmag = 0                ; de-allocate
        if (tpp_header.data_frame eq 1) then b = hd_pay_to_gse(tt,b)
        if (tpp_header.data_frame eq 2) then b = hd_pay_to_gsm(tt,b)
        tpp_data.ylog = 0
        case var of
            23:ydat = b(*,0)
            24:ydat = b(*,1)
            25:ydat = b(*,2)
        endcase
    end
    var eq 27:begin
        hyd_access, tt, specstr+idstr+'b_status'+'_'+rstr, ydat
        tpp_data.ylog = 0
    end
    var eq 28:hyd_access, tt, specstr+idstr+'bhat_errorcone_angle'+'_'+rstr, ydat
endcase
case_out:

tpp_data.ydat = ydat
tpp_header.data_version = vers 
get_err_no = 0
get_err_msg= my_name +': successful.'

message, 'DONE', /cont

return
end
