pro r_hydra_tpphr

   common time,xut1,xut2
   common get_error, get_err_no, get_err_msg
   common hydra_tpphr_data, $
    tpphr_nsweep_index, tpphr_nsweep, $
    tpphr_header, $
    tpphr_data1, $
    tpphr_data2, $
    tpphr_data3, $
    tpphr_data6
   
   my_name='r_hydra_tpphr'
   module_name='HYDRA-tpphr'

   IF n_elements( tpphr_header ) EQ 0 THEN BEGIN 
      tpphr_h1={ hydra_tpphr_dum_header, $
                 start_time:long(0), $
                 end_time:long(0), $
                 data_version:float(0), $
                 reload_flag:fix(0) $
               }
      tpphr_header = replicate(tpphr_h1,4)
   ENDIF
   tpphr_header(tpphr_nsweep_index).start_time=xut1
   tpphr_header(tpphr_nsweep_index).end_time=xut2
   tpphr_header(tpphr_nsweep_index).reload_flag=1
   
   forward_function convert_date_to_t90
   
   get_err_no=0
   get_err_msg= my_name +': data-file read succesfully'
   
; read data files for time period
   num_files_read=0
   time=xut1
   while time-1 lt xut2 do begin
      day_start= time / 86400 * 86400
      start_time= time - day_start
;          end_time is xut2 or midnight, whichever is sooner...
      end_time= min( [ ( (time+1)/86400 +1) * 86400, xut2 ] ) 
      end_time= end_time - day_start 
      convert_t90_to_date,time, year,doy,h,m,s,month,cm,day_om ; y2k
      if year lt 100 then year=year+1900
      date_str=string(year,month,day_om,format="(i4.4,i2.2,i2.2)")       
      
      if start_time ne end_time then begin
         r_hydra_tpphr_oneday, date_str, start_time, end_time, $
          tpphr_nsweep, tpphr_header, data_values
         
         if get_err_no eq 0 then BEGIN
            num_files_read =  num_files_read + 1
            data_values(*).time_ion= $
             data_values(*).time_ion + ( day_start - xut1 )
            if (num_files_read eq 1) then begin
               data_buf= [ data_values ]
            endif else begin
               data_buf= [ data_buf, data_values ]
            endelse
         endif       
      ENDIF
      
      time=day_start+86400      ; prepare to read next day
      
   endwhile
   
   if (n_elements(data_buf) gt 0) then BEGIN
      IF (tpphr_nsweep EQ 1) THEN BEGIN 
         tpphr_data1 = data_buf
      ENDIF ELSE IF (tpphr_nsweep EQ 2) THEN BEGIN
         tpphr_data2 = data_buf
      ENDIF ELSE IF (tpphr_nsweep EQ 3) THEN BEGIN 
         tpphr_data3 = data_buf
      ENDIF ELSE IF (tpphr_nsweep EQ 6) THEN BEGIN 
         tpphr_data6 = data_buf
      ENDIF ELSE BEGIN
         message, 'Something wrong with nsweep index'
      ENDELSE 
      get_err_no=0              ; all's well
   endif else begin
      get_err_no=2
      print,get_err_msg
      return
   endelse
   
   print,'Read '+module_name+': done'
   
   return
end


pro r_hydra_tpphr_oneday, date_str, start_time, end_time, $
                          data_nsweep, data_header, data_values
   
   common  get_error, get_err_no, get_err_msg
   
   myname= 'r_hydra_tpphr_oneday'
   
   f= hydra_findfile( date_str, tpphr=data_nsweep)
   if (f ne '') then begin
      print, myname+': opening '+f+'...'
      CDF= cdf_open(f)
      n= strlen(f)
      data_header.data_version= float( strmid( f, n-8, 4 ))
   endif else begin
      return
   endelse
   
   cdf_control, cdf, variable='time', get_var_info=r
   cdf_varget, cdf, 'time', alltimes, rec_count=r.maxrec+1
   rng = where(alltimes GE start_time AND alltimes LE end_time)
   IF ((rng(0) EQ -1) OR (n_elements(rng) LE 1)) THEN BEGIN 
      get_err_msg= myname+': No data found in this time range '
      get_err_no = 1
      print, get_err_msg
      return
   ENDIF ELSE BEGIN
      rec_start_ion = rng(0)
      rec_count_ion = n_elements(rng)
   ENDELSE
   
   data_values1_7= { hydra_tpphr_data_7, $
                     time_ion:float(0), $
                     dt:float(0), $
                     mean_energy_ion:0.0, $
                     density_ion:0.0, $
                     fit_stat_ion:0,$
                     b_avg:fltarr(3),$
                     b_avg_angle_cone:0.0,$
                     min_energy:0.0,$
                     max_energy:0.0,$
                     angle_b:0.0,$
                     u_pay:fltarr(4),$
                     u_gsm:fltarr(4),$
                     ktparl:0.0,$
                     ktperp:0.0,$
                     gyrotropy:0.0,$
                     rchi2_patch:0.0,$
                     npatch:0,$
                     nrealizations:0,$
                     rstudy_den_stats:fltarr(7),$
                     rstudy_u_stats:fltarr(3,7),$
                     rstudy_tparl_stats:fltarr(7),$
                     rstudy_tperp_stats:fltarr(7),$
                     rstudy_gyrotropy_stats:fltarr(7), $
                     pres_parl:0.0,$
                     pres_perp:0.0,$
                     u_parl:0.0,$
                     u_perp:fltarr(4),$
                     v_alf:0.0 $
                  }   
  
   data_values = replicate( data_values1_7, rec_count_ion )
   
   cdf_attget, cdf, 'scan_interval', 0, scan_interval
   dt = fltarr(rec_count_ion) + scan_interval

   cdf_varget, cdf, 'time', time_ion, $
    rec_start=rec_start_ion, rec_count=rec_count_ion
   
   cdf_varget, cdf, 'h_tparl', ktparl, $
    rec_start=rec_start_ion, rec_count=rec_count_ion
   
   cdf_varget, cdf, 'h_tperp', ktperp, $
    rec_start=rec_start_ion, rec_count=rec_count_ion
   
   mean_energy_ion =  1./3.*(ktparl + 2.*ktperp)
   
   cdf_varget, cdf, 'h_den', h_den, $
    rec_start=rec_start_ion, rec_count=rec_count_ion
   
   h_pres_parl = fltarr(n_elements(h_den))
   h_pres_perp = fltarr(n_elements(h_den))
   gd = where(h_den NE -1.e+31)
   
   h_pres_parl(gd) = h_den(gd)*ktparl*1.6e-12 ;cgs
   h_pres_perp(gd) = h_den(gd)*ktperp*1.6e-12 ;cgs
   
   cdf_varget, cdf, 'h_iretu', h_iretu, $
    rec_start=rec_start_ion, rec_count=rec_count_ion
   
   cdf_varget, cdf, 'b_avg', b_avg, $
    rec_start=rec_start_ion, rec_count=rec_count_ion
   bmag = sqrt(total(b_avg^2,1))
   bhat = b_avg
   FOR icomp=0,2 DO BEGIN
      bhat(icomp,*) = reform(b_avg(icomp,*))/bmag
   ENDFOR 
   
   cdf_varget, cdf, 'b_avg_sigma', b_avg_sigma, $
    rec_start=rec_start_ion, rec_count=rec_count_ion
   b_avg_angle_cone = atan( sqrt(total(b_avg_sigma^2,1)) / $
                            sqrt(total(b_avg^2,1)) )*180/!pi
   
   cdf_varget, cdf, 'min_energy', min_energy, $
    rec_start=rec_start_ion, rec_count=rec_count_ion
   
   cdf_varget, cdf, 'max_energy', max_energy, $
    rec_start=rec_start_ion, rec_count=rec_count_ion
   
   cdf_varget, cdf, 'angle_b', angle_b, $
    rec_start=rec_start_ion, rec_count=rec_count_ion
   
   cdf_varget, cdf, 'h_u', h_u, $
    rec_start=rec_start_ion, rec_count=rec_count_ion ;h_u is in km/s
   
; Convert the flow speed from fixed payload to gsm----------
   time =  reform(time_ion)
   hydra_payload_to_gsm,date_str,time,h_u,h_u_gsm,istat,rate=1
  IF (istat EQ 0) THEN BEGIN
     print, myname+': GSM ROTATION NOT SUCCESSFUL!'
     h_u_gsm = fltarr(4,n_elements(time))
  ENDIF
  
  u_parl = h_u(0,*)*bhat(0,*) + h_u(1,*)*bhat(1,*) + h_u(2,*)*bhat(2,*) ;km/s
  
  u_perp =  fltarr(4,n_elements(time))
  u_perp(0,*) =  h_u(0,*) - u_parl*bhat(0,*) ;km/s
  u_perp(1,*) =  h_u(1,*) - u_parl*bhat(1,*) ;km/s
  u_perp(2,*) =  h_u(2,*) - u_parl*bhat(2,*) ;km/s
  u_perp(3,*) =  sqrt(u_perp(0,*)^2 + u_perp(1,*)^2 + u_perp(2,*)^2)
  
  cdf_varget, cdf, 'h_gyrotropy', h_gyrotropy, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'h_rchi2', h_rchi2, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'npatch', npatch, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'nrealizations', nrealizations, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'rstudy_den_stats', rstudy_den_stats, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'rstudy_u_stats', rstudy_u_stats, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'rstudy_tparl_stats', rstudy_tparl_stats, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'rstudy_tperp_stats', rstudy_tperp_stats, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'rstudy_gyrotropy_stats', rstudy_gyrotropy_stats, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_close, cdf

; Alfven speed
  v_alf = fltarr(n_elements(time_ion))
  pos = where(h_den GT 0)
  mass = 1.67e-24               ; cgs, hydrogen
  bgauss = bmag(pos)*1.e-9*1.e+4     ; cgs
  rho = h_den(pos)*mass              ; cgs
  v_alf(pos) = bgauss/sqrt(4.*(!pi)*rho) ; cgs
  v_alf(pos) = v_alf(pos)*1.e-5           ; km/s

  rion= lindgen(rec_count_ion)
  data_values(rion).v_alf = reform(v_alf)
  data_values(rion).time_ion= reform(time_ion)  
  data_values(rion).dt= reform(dt)
  data_values(rion).mean_energy_ion= reform(mean_energy_ion)
  data_values(rion).density_ion= reform(h_den)
  data_values(rion).pres_parl = reform(h_pres_parl)
  data_values(rion).pres_perp = reform(h_pres_perp)
  data_values(rion).u_parl = reform(u_parl)
  data_values(rion).fit_stat_ion= reform(h_iretu)
  data_values(rion).b_avg_angle_cone= reform(b_avg_angle_cone)
  data_values(rion).min_energy= reform(min_energy)
  data_values(rion).max_energy= reform(max_energy)
  data_values(rion).angle_b= reform(angle_b)
  data_values(rion).ktparl= reform(ktparl)
  data_values(rion).ktperp= reform(ktperp)
  data_values(rion).gyrotropy= reform(h_gyrotropy)
  data_values(rion).rchi2_patch= reform(h_rchi2)
  data_values(rion).npatch= reform(npatch)
  data_values(rion).nrealizations= reform(nrealizations)

; Arrays of more than one dimension
  data_values(rion).u_perp = u_perp
  data_values(rion).rstudy_den_stats = rstudy_den_stats
  data_values(rion).rstudy_u_stats= rstudy_u_stats
  data_values(rion).rstudy_tparl_stats= rstudy_tparl_stats
  data_values(rion).rstudy_tperp_stats= rstudy_tperp_stats
  data_values(rion).rstudy_gyrotropy_stats= rstudy_gyrotropy_stats
  data_values(rion).b_avg= b_avg
  data_values(rion).u_pay(0)= reform(h_u(0,*))
  data_values(rion).u_pay(1)= reform(h_u(1,*))
  data_values(rion).u_pay(2)= reform(h_u(2,*))
  data_values(rion).u_pay(3) = reform(sqrt(h_u(0,*)^2+h_u(1,*)^2+h_u(2,*)^2))
  
  data_values(rion).u_gsm(0)= reform(h_u_gsm(0,*))
  data_values(rion).u_gsm(1)= reform(h_u_gsm(1,*))
  data_values(rion).u_gsm(2)= reform(h_u_gsm(2,*))
  data_values(rion).u_gsm(3) = reform(h_u_gsm(3,*))
  
  return
END





