pro r_hydra_walen, test=test

common walen_data, datestr, starttime, stoptime, $
  diff_method, zoom, wdata, inds, ref_index, wfit

common get_error, get_err_no, get_err_msg

if keyword_set(test) then begin
    datestr='19960529'
    starttime = 4.0*3600. + 12.*60.
    stoptime = 4.0*3600. + 15.*60.
endif

myname = 'r_hydra_walen: '

@hd_include                     ; hd_fill is in here

cm2km = 1.d-5
kb = 1.38d-16                   ; ergs/K
nT2G = 1.d-9*1.d+4

; Get the time tags for the moment quantities
hyd_data_get_timetags, timetags, 'ele_n', gen_time(date=datestr, time=starttime, /seconds), gen_time(date=datestr, time=stoptime, /seconds)

hd_time, 'time_bin_start_ssm', timetags, time
hyd_data, timetags, 'ion_n', density_ion
hyd_data, timetags, 'ele_n', density_ele
hyd_data, timetags, 'ion_v', u_ion
hyd_data, timetags, 'u_ion_sigma_tpp', u_sigma_ion
hyd_data, timetags, 'ele_t', te
hyd_data, timetags, 'ele_v', u_ele
hyd_data, timetags, 'mfe_b_avg', b_pay
hyd_data, timetags, 'mfe_b_avg_sigma', b_pay_sigma
hyd_data, timetags, 'ele_tparl', etparl
hyd_data, timetags, 'ele_tperp', etperp
hyd_data, timetags, 'ion_tparl', itparl
hyd_data, timetags, 'ion_tperp', itperp
hyd_data, timetags, 'ele_mom_b', b_mom

; Get the hrkp density sigma data
hyd_access, ttaghrkp, 'hrkp_density', get_timetags=[gen_time(date=datestr, time=starttime, /seconds), gen_time(date=datestr, time=stoptime, /seconds)], hrkp_n
hrkp_n_avg = hd_synchronize_bin_avg(timetags, ttaghrkp, hrkp_n, var=density_sigma_ele)

; Default values for the non-moment quantities which may or may not be
; available
if ( (where(density_sigma_ele eq hd_fill))(0) ne -1 ) then $
  density_sigma_ele(where(density_sigma_ele eq hd_fill)) = 0.d0

if ( (where(u_sigma_ion eq hd_fill))(0) ne -1 ) then $
  u_sigma_ion(where(u_sigma_ion eq hd_fill)) = 5.d0/cm2km ; cm/s

;u_sigma_ion = fltarr(n_elements(u_ion(*,0)),3) + 5.d0/cm2km ; cm/s

; Use only those measurements which are SIMULTANEOUSLY non-fill

gd = where(timetags.valid_register eq 1)

;gd = where( density_ion ne hd_fill and $
;            density_ele ne hd_fill and $
;            u_ion(*,0) ne hd_fill and $
;            u_ion(*,1) ne hd_fill and $
;            u_ion(*,2) ne hd_fill and $
;            te ne hd_fill and $
;            u_ele(*,0) ne hd_fill and $
;            u_ele(*,1) ne hd_fill and $
;            u_ele(*,2) ne hd_fill and $
;            b_pay(*,0) ne hd_fill and $
;            b_pay(*,1) ne hd_fill and $
;            b_pay(*,2) ne hd_fill and $
;            b_pay_sigma(*,0) ne hd_fill and $
;            b_pay_sigma(*,1) ne hd_fill and $
;            b_pay_sigma(*,2) ne hd_fill and $
;            etparl ne hd_fill and $
;            etperp ne hd_fill and $
;            itparl ne hd_fill and $
;            itperp ne hd_fill )

if (gd(0) ne -1) then begin
    time = time(gd)
    density_ion = density_ion(gd)
    density_ele = density_ele(gd)
    density_sigma_ele = density_sigma_ele(gd)
    u_ion = u_ion(gd,*)
    u_sigma_ion = u_sigma_ion(gd,*)
    te = te(gd)
    u_ele = u_ele(gd,*)
    b_pay = b_pay(gd,*)
    b_pay_sigma = b_pay_sigma(gd,*)
    etparl = etparl(gd)
    etperp = etperp(gd)
    itparl = itparl(gd)
    etparl = etparl(gd)
    b_mom = b_mom(gd,*)
endif

density_sigma_ion = fltarr(n_elements(density_ion))
u_sigma_ele = fltarr(3,n_elements(te))
u_sigma_ele(0,*) = 25.d0/cm2km*sqrt(te/2.d+5) ; cm/s
u_sigma_ele(1,*) = u_sigma_ele(0,*)
u_sigma_ele(2,*) = u_sigma_ele(0,*)
pres_parl = density_ion*kb*itparl + density_ele*kb*etparl ; cgs
pres_perp = density_ion*kb*itperp + density_ele*kb*etperp ; cgs

; Want dimension order (icomp,itime)
u_ion = transpose(u_ion)*cm2km  ; km/s
u_sigma_ion = transpose(u_sigma_ion)*cm2km ; km/s
u_ele = transpose(u_ele)*cm2km  ; km/s
u_sigma_ele = u_sigma_ele*cm2km ; km/s
b_pay = transpose(b_pay)*nT2G   ; Gauss
b_pay_sigma = transpose(b_pay_sigma)*nT2G ; Gauss
b_mom = transpose(b_mom)*nT2G   ; Gauss

wdata_one = {time:0.0, $
             density_ion:0.0, $
             density_sigma_ion:0.0, $
             density_ele:0.0, $
             density_sigma_ele:0.0, $
             u_ion:fltarr(3), $
             u_sigma_ion:fltarr(3), $
             u_ele:fltarr(3), $
             u_sigma_ele:fltarr(3), $
             b_pay:fltarr(3), $
             b_pay_sigma:fltarr(3), $
             pres_parl:0.0, $
             pres_perp:0.0 $
             }

wdata = replicate( wdata_one, n_elements(time) )
wdata.time = time               ; ssm
wdata.density_ion = density_ion ; cgs
wdata.density_sigma_ion = density_sigma_ion ; cgs
wdata.density_ele = density_ele ; cgs
wdata.density_sigma_ele = density_sigma_ele ; cgs
wdata.u_ion = u_ion             ; km/s
wdata.u_sigma_ion = u_sigma_ion ; km/s
wdata.u_ele = u_ele             ; km/s
wdata.u_sigma_ele = u_sigma_ele ; km/s
wdata.b_pay = b_pay             ; G
wdata.b_pay_sigma = b_pay_sigma ; G
wdata.pres_parl = pres_parl     ; cgs
wdata.pres_perp = pres_perp     ; cgs

;test test_r_hydra_walen, b_mom

return
end

