PRO read_level1_highres_bfield_pay, CDF, timein, timeout, bx, by, bz, t, gsmid=gsmid

; returns Bx, By, Bz in fixed payload coordinates, unless a 'pay2gsm'
; matrix already exists in a gsm CDF file

   rec_start= ((timein/13.8)-1)>0
   rec_count= ((timeout-timein)/13.8)+2

   rec_count= rec_count<100

   i4fill = long(-2147483648)
   i2fill = -32768
   rfill = -1.0e-31

   hydtim=1

   npb=384                      ;   number of meas. per block


   cdf_varget, CDF, 'PHASE_START', phase_start, $
     rec_start=rec_start, rec_count=rec_count
   cdf_varget, CDF, 'BLOCK_MODE', block_mode, $
     rec_start=rec_start, rec_count=rec_count
   if block_mode(0) ne block_mode(n_elements(block_mode)-1) then stop
   block_mode=block_mode(0)
   cdf_varget, CDF, 'PHI_OFFSET', phi_offset, $
     rec_start=block_mode-1

   if n_elements(gsmid) gt 0 then begin
       cdf_varget, gsmid, 'pay2gsm', pay2gsm, $
         rec_start=rec_start, rec_count=rec_count
   endif

   bvalid = make_array( npb,rec_count, /byte, value=1 )
   
   cdf_varget, CDF, 'BLOCK_TIME', rectimes, $
     rec_start=rec_start, rec_count=rec_count
   rectimes= rectimes mod 86400000. / 1000.

   cdf_varget, CDF, 'B_AVG_RAW', b_avg_raw, $
     rec_start=rec_start, rec_count= rec_count

; MFE_STATUS bits: 1=OFF/ON, 2=Inb/Out Sensor, 4=Low/High Range,
;                  8=Left/Right Flipper
;         15 = 1+2+4+8 = On, Out, High, Right

   cdf_varget, CDF, 'MFE_STATUS', mfe_status, $
     rec_start=rec_start, rec_count= rec_count

   rstat = where( ((mfe_status and 1) eq 0) or (b_avg_raw(0,*) EQ i2fill) )
   if (rstat(0) ne -1) then begin
       print, "Fill data found for B, no correction possible."
       bvalid(*,rstat) = 0
   endif
   rokay = where( ((mfe_status and 1) eq 1) and (b_avg_raw(0,*) NE i2fill) )
   if (rokay(0) eq -1) then return

   flipper_index = (mfe_status AND 8) eq 8
   range_index = (mfe_status AND 4) eq 4 
   sensor_index = (mfe_status AND 2) eq 2

;  mfe_offset_flag = 1 -> offsets in nT
;  mfe_offset_flag = 2 -> offsets in Counts
;
   cdf_varget, CDF, 'MFE_OFFSET_FLAG', mfe_offset_flag

;  mfe_gains: indexed by (x/y/z, Inb/Out, Low/High, Left/Right) in nT/Count
;
;
   cdf_varget, CDF, 'MFE_GAINS', mfe_gains
       
;  mfe_offset: indexed by (x/y/z, Inb/Out, Low/High, itime) in nT
;
;
   cdf_varget, CDF, 'MFE_OFFSET', mfe_offset
   cdf_varget, CDF, 'MFE_OFFSET_RAW', mfe_offset_raw
   
   cdf_varget, CDF, 'MFE_OFFSET_START', mfe_offset_start
   cdf_varget, CDF, 'MFE_OFFSET_END', mfe_offset_end
   
;  mfe_matrix: indexed by (x/y/z, x/y/z, Inb/Out, Low/High) in nT/Count
;
;
   cdf_varget, CDF, 'MFE_MATRIX', mfe_matrix

   print, 'Using high-res 3D bfield data...'

   read_raw_mfe, CDF, rec_start, rec_count, bx, by, bz, t, hydtim=hydtim


   bx= float(bx)
   by= float(by)
   bz= float(bz)

   if not keyword_set(hydtim) then begin
       r= where( t ge rectimes(0) and t le rectimes(rec_count-1)+13.8 )
       t= t(r)
       bx=bx(r)
       by=by(r)
       bz=bz(r)
   endif
       
; now loop over block.
   for n=0, n_elements(rokay)-1 do begin
       i= rokay(n)
       
       gains = mfe_gains(*,sensor_index(i),range_index(i),flipper_index(i))
       
       matrix = mfe_matrix(*,*,sensor_index(i),range_index(i))

       mfe_time_start = mfe_offset_start(sensor_index(i),range_index(i),*)
       mfe_time_end = mfe_offset_end(sensor_index(i),range_index(i),*)

       time= long( rectimes(i) / 3600 ) * 10000 + $
         fix( rectimes(i) mod 3600 / 60 ) * 100 + $
         fix( rectimes(i) mod 60 )

       r = where(time LE mfe_time_end AND time GE mfe_time_start)
       IF (r(0) EQ -1) THEN BEGIN
           print, 'MFE B Correction failed to get offset.'
           bvalid(*,i) = 0
           goto, loopend
       ENDIF 
       itime = r(0)
       
       offset = mfe_offset(*,sensor_index,range_index,itime)
       offset_raw = mfe_offset_raw(*,sensor_index,range_index,itime)
       
       if keyword_set(hydtim) then $
         rblk= npb*i+indgen(npb) else $
         rblk= where( t ge rectimes(i) and t le rectimes(i)+13.8 )
       
       bx0 = bx(rblk)
       by0 = by(rblk)
       bz0 = bz(rblk)           
       
       IF (mfe_offset_flag EQ 1) THEN BEGIN 
           
           bx1 = bx0*gains(0) - offset(0)
           by1 = by0*gains(1) - offset(1)
           bz1 = bz0*gains(2) - offset(2)
           
       ENDIF ELSE BEGIN 
           
           bx1 = (bx0-offset_raw(0))*gains(0) - offset(0)
           by1 = (by0-offset_raw(1))*gains(1) - offset(1)
           bz1 = (bz0-offset_raw(2))*gains(2) - offset(2)
           
       ENDELSE 

       bx2 = bx1*matrix(0,0) + by1*matrix(0,1) + bz1*matrix(0,2)
       by2 = bx1*matrix(1,0) + by1*matrix(1,1) + bz1*matrix(1,2)
       bz2 = bx1*matrix(2,0) + by1*matrix(2,1) + bz1*matrix(2,2)

       sc_phase= phase_start(i)+phi_offset-5.9*!dtor
       bx3= bx2*cos(sc_phase)-by2*sin(sc_phase)
       by3= bx2*sin(sc_phase)+by2*cos(sc_phase)
       bz3= bz2
       
       if n_elements( gsmid ) then begin
           pay2gsm1= transpose(pay2gsm(*,*,i))
           bx(rblk) = bx3*pay2gsm1(0,0) + by3*pay2gsm1(1,0) + bz3*pay2gsm1(2,0)
           by(rblk) = bx3*pay2gsm1(0,1) + by3*pay2gsm1(1,1) + bz3*pay2gsm1(2,1)
           bz(rblk) = bx3*pay2gsm1(0,2) + by3*pay2gsm1(1,2) + bz3*pay2gsm1(2,2)
       endif else begin
           bx(rblk) = bx3
           by(rblk) = by3
           bz(rblk) = bz3
       endelse
           
       loopend:
   endfor

END
   



