PRO read_level1_highres_bfield, CDF, gsmid, timein, timeout, bx, by, bz, t, $
                                bx_pay,by_pay,bz_pay, $
                                eight_hertz=eight_hertz

; returns Bx, By, Bz in gsm coordinates and payload coordinates

   myname = 'read_level1_highres_bfield: '

; First get the gsm spin-vector info
   gsm_res = 600.               ; Resolution in seconds

   rec_start = 0
   rec_count_att = 144

   cdf_varget, gsmid, 'GSM_EPHEM_TIME_AT', gsm_time, rec_start=rec_start, $
    rec_count=rec_count_att
   cdf_varget, gsmid, 'GSM_R_ASCENSION_AT', gsm_ra, rec_start=rec_start, $
    rec_count=rec_count_att
   cdf_varget, gsmid, 'GSM_DECLINATION_AT', gsm_dec, rec_start=rec_start, $
    rec_count=rec_count_att

   gsm_time = reform(gsm_time)
   gsm_ra = reform(gsm_ra)
   gsm_dec = reform(gsm_dec)

; Create the matrices needed on this crude time-scale (minimize the
; number of trig functions)

;   pay2gsm = dblarr(3,3,n_elements(gsm_time))
   pay2gsm=[[1,0,0],[0,1,0],[0,0,1]]

   FOR itime=0,n_elements(gsm_time)-1 DO BEGIN 

      RAC = double(gsm_ra(itime))
      DEC = double(gsm_dec(itime))
;
      EPX = COS(DEC) * COS(RAC)
      EPY = COS(DEC) * SIN(RAC)
      EPZ = SIN(DEC)
;
;-- COMPUTE SINE VALUES AND COSINE VALUES OF ANGLES A AND D
;
;      COSA = SQRT(EPY*EPY + EPZ*EPZ)
;      SINA = EPX
;      COSD = EPZ/COSA
;      SIND = EPY/COSA
;
;-- CONSTRUCT THE TRANSFORMATION MATRIX
;
;      pay2gsm(0,0,itime) = COSA
;      pay2gsm(0,1,itime) = 0.
;      pay2gsm(0,2,itime) = SINA
;      pay2gsm(1,0,itime) = -SINA * SIND
;      pay2gsm(1,1,itime) = COSD
;      pay2gsm(1,2,itime) = COSA * SIND
;      pay2gsm(2,0,itime) = -SINA * COSD
;      pay2gsm(2,1,itime) = -SIND
;      pay2gsm(2,2,itime) =  COSA * COSD

   ENDFOR


; Now reconstruct the highres magnetic field...

   cdf_varget, CDF, 'MAX_BLOCK_NUMBER', maxrec
   cdf_varget, CDF, 'BLOCK_TIME', dumtime, rec_start=0, rec_count=maxrec
   dumtime = dumtime MOD 86400000. / 1000.

   istart = where(dumtime GE timein)
   istop = where(dumtime LE timeout)
   
   IF istart(0) NE -1 THEN rec_start = istart(0) ELSE rec_start = 0
   IF istop(0) NE -1 THEN rec_stop = istop(n_elements(istop)-1) ELSE $
    rec_stop = maxrec-1

   rec_count = rec_stop-rec_start+1


;   print, rec_start, rec_count
 
   i4fill = long(-2147483648)
   i2fill = -32768
   rfill = -1.0e-31

   IF (NOT keyword_set(eight_hertz)) THEN hydtim=1 ELSE hydtim = 0

   npb=384                      ;   number of meas. per block


   cdf_varget, CDF, 'PHASE_START', phase_start, $
     rec_start=rec_start, rec_count=rec_count
   print, myname+'read PHASE_START'

   cdf_varget, CDF, 'BLOCK_MODE', block_mode, $
     rec_start=rec_start, rec_count=rec_count
   print, myname+'read BLOCK_MODE'

   if block_mode(0) ne block_mode(n_elements(block_mode)-1) then stop
   block_mode=block_mode(0)
   cdf_varget, CDF, 'PHI_OFFSET', phi_offset, $
     rec_start=block_mode-1
   print, myname+'read PHI_OFFSET'

   bvalid = make_array( npb,rec_count, /byte, value=1 )
   
   cdf_varget, CDF, 'BLOCK_TIME', rectimes, $
     rec_start=rec_start, rec_count=rec_count
   print, myname+'read BLOCK_TIME'
   rectimes= rectimes mod 86400000. / 1000.

   cdf_varget, CDF, 'B_AVG_RAW', b_avg_raw, $
     rec_start=rec_start, rec_count= rec_count
   print, myname+'read B_AVG_RAW'

; MFE_STATUS bits: 1=OFF/ON, 2=Inb/Out Sensor, 4=Low/High Range,
;                  8=Left/Right Flipper
;         15 = 1+2+4+8 = On, Out, High, Right

   cdf_varget, CDF, 'MFE_STATUS', mfe_status, $
     rec_start=rec_start, rec_count= rec_count
   print, myname+'read MFE_STATUS'

   rstat = where( ((mfe_status and 1) eq 0) or (b_avg_raw(0,*) EQ i2fill) )
   if (rstat(0) ne -1) then begin
       print, "Fill data found for B, no correction possible."
       bvalid(*,rstat) = 0
   endif
   rokay = where( ((mfe_status and 1) eq 1) and (b_avg_raw(0,*) NE i2fill) )
   if (rokay(0) eq -1) then return

   flipper_index = (mfe_status AND 8) eq 8
   range_index = (mfe_status AND 4) eq 4 
   sensor_index = (mfe_status AND 2) eq 2

;  mfe_offset_flag = 1 -> offsets in nT
;  mfe_offset_flag = 2 -> offsets in Counts
;
   cdf_varget, CDF, 'MFE_OFFSET_FLAG', mfe_offset_flag
   print, myname+'read MFE_OFFSET_FLAG'

;  mfe_gains: indexed by (x/y/z, Inb/Out, Low/High, Left/Right) in nT/Count
;
;
   cdf_varget, CDF, 'MFE_GAINS', mfe_gains
   print, myname+'read MFE_GAINS'
       
;  mfe_offset: indexed by (x/y/z, Inb/Out, Low/High, itime) in nT
;
;
   cdf_varget, CDF, 'MFE_OFFSET', mfe_offset
   print, myname+'read MFE_OFFSET'
   cdf_varget, CDF, 'MFE_OFFSET_RAW', mfe_offset_raw
   print, myname+'read MFE_OFFSET_RAW'
   
   cdf_varget, CDF, 'MFE_OFFSET_START', mfe_offset_start
   print, myname+'read MFE_OFFSET_START'
   cdf_varget, CDF, 'MFE_OFFSET_END', mfe_offset_end
   print, myname+'read MFE_OFFSET_END'
   
;  mfe_matrix: indexed by (x/y/z, x/y/z, Inb/Out, Low/High) in nT/Count
;
;
   cdf_varget, CDF, 'MFE_MATRIX', mfe_matrix
   print, myname+'read MFE_MATRIX'

   print, 'Using high-res 3D bfield data...'

   read_raw_mfe, CDF, rec_start, rec_count, bx, by, bz, t, hydtim=hydtim

   bx= float(bx)
   by= float(by)
   bz= float(bz)

   if not keyword_set(hydtim) then begin
       r= where( t ge rectimes(0) and t le rectimes(rec_count-1)+13.8 )
       t= t(r)
       bx=bx(r)
       by=by(r)
       bz=bz(r)
   ENDIF

   bx_pay = dblarr(n_elements(bx))
   by_pay = dblarr(n_elements(by))
   bz_pay = dblarr(n_elements(bz))

   rnv= where( bx eq 1e-31 or by eq 1e-31 or bz eq 1e-31 )
       
; now loop over block.
   for n=0, n_elements(rokay)-1 do BEGIN

      print, n, n_elements(rokay)

       i= rokay(n)
       
       gains = mfe_gains(*,sensor_index(i),range_index(i),flipper_index(i))
       
       matrix = mfe_matrix(*,*,sensor_index(i),range_index(i))

       mfe_time_start = mfe_offset_start(sensor_index(i),range_index(i),*)
       mfe_time_end = mfe_offset_end(sensor_index(i),range_index(i),*)

       time= long( rectimes(i) / 3600 ) * 10000 + $
         fix( rectimes(i) mod 3600 / 60 ) * 100 + $
         fix( rectimes(i) mod 60 )

       r = where(time LE mfe_time_end AND time GE mfe_time_start)
       IF (r(0) EQ -1) THEN BEGIN
           print, 'MFE B Correction failed to get offset.'
           bvalid(*,i) = 0
           goto, loopend
       ENDIF 
       itime = r(0)
       
       offset = mfe_offset(*,sensor_index,range_index,itime)
       offset_raw = mfe_offset_raw(*,sensor_index,range_index,itime)
       
       if keyword_set(hydtim) then $
         rblk= npb*i+indgen(npb) else $
         rblk= where( t ge rectimes(i) and t le rectimes(i)+13.8 )
       
       bx0 = bx(rblk)
       by0 = by(rblk)
       bz0 = bz(rblk)           
       
       IF (mfe_offset_flag EQ 1) THEN BEGIN 
           
           bx1 = bx0*gains(0) - offset(0)
           by1 = by0*gains(1) - offset(1)
           bz1 = bz0*gains(2) - offset(2)
           
       ENDIF ELSE BEGIN 
           
           bx1 = (bx0-offset_raw(0))*gains(0) - offset(0)
           by1 = (by0-offset_raw(1))*gains(1) - offset(1)
           bz1 = (bz0-offset_raw(2))*gains(2) - offset(2)
           
       ENDELSE 

       bx2 = bx1*matrix(0,0) + by1*matrix(0,1) + bz1*matrix(0,2)
       by2 = bx1*matrix(1,0) + by1*matrix(1,1) + bz1*matrix(1,2)
       bz2 = bx1*matrix(2,0) + by1*matrix(2,1) + bz1*matrix(2,2)

       sc_phase= phase_start(i)+phi_offset-5.9*!dtor
       bx3= bx2*cos(sc_phase)-by2*sin(sc_phase)
       by3= bx2*sin(sc_phase)+by2*cos(sc_phase)
       bz3= bz2
       

; Which transformation matrix should I use??

       near = where(gsm_time GE rectimes(i)-gsm_res/2.)
       IF (near(0) NE -1) THEN BEGIN
          jj = near(0)
       ENDIF ELSE BEGIN
          jj = rec_count_att -1
       ENDELSE

;       print, 'gsm_time: ',gsm_time(jj),' block_time: ',rectimes(i)

       bx(rblk) = bx3*pay2gsm(0,0)+by3*pay2gsm(0,1)+bz3*pay2gsm(0,2)
       by(rblk) = bx3*pay2gsm(1,0)+by3*pay2gsm(1,1)+bz3*pay2gsm(1,2)
       bz(rblk) = bx3*pay2gsm(2,0)+by3*pay2gsm(2,1)+bz3*pay2gsm(2,2)

       bx_pay(rblk) = bx3
       by_pay(rblk) = by3
       bz_pay(rblk) = bz3
           
       loopend:
   ENDFOR

   if rnv(0) ne -1 then begin
       bx(rnv)= 1e31
       by(rnv)= 1e31
       bz(rnv)= 1e31

       bx_pay(rnv) = 1e31
       by_pay(rnv) = 1e31
       bz_pay(rnv) = 1e31

   endif
END
   



