pro thumb_plot, x_in, plotCall=plotCall, callFormat=callFormat, $
                aspect_ratio=aspect, deltax=dx_in, traceUp=traceUp, $
                _extra=e, rows=rows_in, trace_style=trace_style

;  aspect ratio is defined to be height/width.  (I'm not sure this is right...)
   if n_elements( aspect ) eq 0 then aspect=1.0

   if n_elements( x_in ) eq 0 then begin
       print, 'pro thumb_plot, x_in, plotCall=plotCall, callFormat=callFormat, $'
       print, '    aspect_ratio=aspect, height=height, $'
       print, '    _extra=e'
       return
   endif

   traceUp=keyword_set(traceUp)

   if n_elements( dx_in ) eq 0 then dx= fltarr( n_elements( x_in ) ) else $
     dx= dx_in

   if n_elements( dx ) eq 1 then dx= dx+fltarr( n_elements( x_in ) )

   if n_elements( e ) gt 0 then begin
       extra=e
       if (where( tag_names(extra) eq 'XSTYLE' ))(0) ne -1 then $
         extra.xstyle= extra.xstyle or 4
   endif else begin
       extra= { xstyle:4 }
   endelse

   if n_elements( x_in ) gt 1 then begin
       plot, x_in,x_in,/nodata, ystyle=5, yrange=[0,1], _extra=extra
   endif else if n_elements( x_in ) eq 0 then begin
       plot, x_in*[1,1], [1,1], /nodata, ystyle=5, yrange=[0,1], _extra=extra
   endif else begin
       plot, [1,1], [1,1], /nodata, ystyle=5, yrange=[0,1], _extra=extra
   endelse

   if not traceUp then axis, xaxis=0, xticklen=-0.05, _extra=e

   xcrange= !x.crange
   ycrange= !y.crange
   t0= convert_coord( xcrange(0), ycrange(0), /data, /to_normal )
   t1= convert_coord( xcrange(1), ycrange(1), /data, /to_normal )
   xnorm= [ t0(0), t1(0) ]
   ynorm= [ t0(1), t1(1) ]

   aspect_norm = ( ynorm(1)-ynorm(0) ) / ( xnorm(1)-xnorm(0) ) * $
     ( float(!d.y_size) / !d.x_size )

   rdraw= where( x_in ge xcrange(0) and x_in+dx le xcrange(1) )
   if rdraw(0) eq -1 then return
   x= x_in(rdraw)
   dx= dx(rdraw)

   xsort= sort(x)
   x= x(xsort)
   dx= dx(xsort)

   nplots= n_elements( x )      
   A= aspect_norm / aspect * 1.0 ; for interrow connections.
   nv= fix( sqrt( nplots*A ) ) >1 ; number of rows.
   if keyword_set( rows_in ) then nv=rows_in
   s=  getenv('hydra_thumbplot_numrows')
   if s ne '' then if fix(s) gt 0 then nv= fix(s)

   nh= ceil( float(nplots) / nv ) ; number of plots per row

;  decide which row each plot goes in
   row= fix( findgen(nplots) mod (nv-0.2) )
   row( nplots-1 ) = 0          ; require this
   nabove=intarr( nplots )      ; only calculated for first row
   r1= where( row eq 0 )
   if n_elements( r1 ) gt 1 then $
     ab= ( [r1(1:*),nplots]-r1(0:*) ) - 1  $
   else $
     ab= [ nplots ] -1
   nabove(r1)= ab
   r= where( nabove gt 0 )
   if r(0) ne -1 then nabove(r)=nabove(r)+1 
                                ;misnomer: really it is the number of white
                                ;spaces between lines.

;  width and height are the w&h of each panel in normal coord  
   rw_width=0.006                ; width of right-of-way
   ir_width=0.012               ; width between rows.
   rrow0= where( row eq 0, nrow1 )   
   width= ( 1.0 - total( nabove(rrow0)*rw_width ) ) / nrow1
   height= width * aspect / aspect_norm 

;  height may set the width instead.
   if ( height*nv + ir_width*(nv-1) ) gt 1.0 then begin
       height = ( 1.0 - ir_width*(nv-1) ) / nv
       width = height * aspect_norm / aspect
   endif

;  locx,locy are position of bottom center in plot normal coords above
;    traces
   locx= fltarr(nplots)
   xp= width/2.
   
   for i=0,nrow1-1 do begin       
       locx(rrow0(i))= xp
       xp= xp + width + nabove(rrow0(i))*rw_width
   endfor
   for j=1,nv-1 do begin
       rrow= where( row eq j, nrow )       
       for i=0,nrow-1 do begin  ;assumes row(rrow(i)) = row(rrow(i)-1) + 1
           locx(rrow(i))= locx(rrow(i)-1) + width/2 + rw_width
       endfor
   endfor

   locy= row*height + row*ir_width

   if ( traceUp ) then begin
       dir=-1.0
       base= 0.8
       deltatop= 1-0.05
       deltabot= 1.
   endif else begin
       dir=1.0
       base= 0.2
       deltatop= 0.05
       deltabot= 0.
   endelse

   exe=''
   for i=0, nplots-1 do begin       
       pposx= ( locx(i) + 0.5 * width * [ -.95, .95 ] ) * $
         ( xnorm(1)-xnorm(0) ) + xnorm(0)       
       pposy= ( base + dir * ( locy(i)+( height*[0,1] ) ) * 0.8 ) * $
         ( ynorm(1)-ynorm(0) ) + ynorm(0) 
       pOld= !p
       xOld= !x
       yOld= !y
       if dir eq -1 then $
         !p.position=[pposx(0),pposy(1),pposx(1),pposy(0)] $
       else $
         !p.position=[pposx(0),pposy(0),pposx(1),pposy(1)]
       !p.noerase=1
       catch, error_status
       if error_status eq 0 then begin
           if keyword_set( callFormat ) then $
             exe= call_function( callFormat, rdraw(xsort(i)), x(i) ) $
           else if keyword_set( plotCall ) then $
             exe= plotCall+', '+strtrim(x(i),2)
           if exe ne '' then r= execute( exe ) 
       endif else begin
           err= !err_string
           message, 'Error encountered while executing plot:', /cont
           message, err, /cont
           goto, notrace
       endelse
       catch, /cancel
       
       !p=pOld
       !x=xOld
       !y=yOld
       
       dheight= height*0.8
       nheight= dheight * ( ynorm(1)-ynorm(0) )

       if n_elements( trace_style ) eq 0 then trace_style=0
       
       for j=row(i),1,-1 do begin 
;          pposx, pposy are in normal coords           
           boxroot= [ total( pposx )/2, pposy(0) ] ; plot normal coords
           boxroot= convert_coord( boxroot, /normal, /to_data )
           dn= row(i)-j+1
           dest= [ locx(i-dn)+dn*rw_width+width/2., $
                   locy(i-dn)+height ]
           dest(0)= dest(0) * ( xnorm(1)-xnorm(0) ) + xnorm(0)       
           dest(1)= ( base + dir*dest(1)*0.8 ) * $
             ( ynorm(1)-ynorm(0) ) + ynorm(0) 
           destd= convert_coord( dest, /normal, /to_data )
           oplot,  [ boxroot(0), destd(0) ], [ boxroot(1), destd(1) ]
           oplot,  [ destd(0), destd(0) ], [ destd(1), destd(1)-dir*dheight ]
           pposx(*)=dest(0)
           pposy(*)=dest(1)-dir*nheight
       endfor
               
       case trace_style of 
           0: begin
               boxroot= [ total( pposx )/2, pposy(0) ] ; plot normal coords
               boxroot= convert_coord( boxroot, /normal, /to_data )
               oplot, [ boxroot(0), x(i)+dx(i)/2 ], [ boxroot(1), deltatop ]
               oplot, [1,1]*(x(i)+dx(i)/2),  [ deltabot,deltatop ]
               if dx(i) gt 0. then begin
                   polyfill, x(i)+[0,dx(i),dx(i)/2,0], $
                     [ deltabot,deltabot,deltatop,deltabot ]
               endif 
           end
           1: begin
               boxroot_left= [ pposx(0), pposy(0) ] ; plot normal coords
               boxroot_left= convert_coord( boxroot_left, /normal, /to_data )
               boxroot_rt= [ pposx(1), pposy(0) ] ; plot normal coords
               boxroot_rt= convert_coord( boxroot_rt, /normal, /to_data )
               oplot, $
                 [ boxroot_left(0),  boxroot_rt(0),  x(i)+dx(i),  x(i),$
                   boxroot_left(0) ],$
                 [ boxroot_left(1),  boxroot_rt(1),  deltabot,    deltabot,$
                   boxroot_left(1) ]
           end
       endcase 
       notrace:
   endfor
   return
end

