pro walen_tool_wrapper

common get_error, get_err_no, get_err_msg

common walen_data, datestr, starttime, stoptime, $
  diff_method, zoom, wdata, inds, ref_index, wfit

for izoom = 0, 7 do begin

    zoom = izoom
    diff_method = 0
    
    if (izoom eq 0) then begin
        r_hydra_walen, /test
        if (get_err_no eq 2) then begin
            print, get_err_msg
            stop
        endif
    endif
    
    
;================================================================
    
; How many moments measurments do we have to deal with?
    nmom = n_elements(wdata.time)
    if (nmom lt 2) then begin
        get_err_msg = myname+'Need at least two points!'
        get_err_no = 2
        stop
    endif else if (nmom eq 2) then begin
        diff_method = 1         ; Asymptotic only, Mid-ref not possible
        inds = lindgen(nmom)
    endif
    
; Select which indicies to use based on the value of zoom
    ninds = nmom - long(2.*zoom)
    if (ninds lt 2) then begin
        get_err_msg = myname+'Need at least two points!'
        get_err_no = 2
        stop
    endif else if (ninds eq 2) then begin
        diff_method = 1         ; Asymptotic only, Mid-ref not possible
        inds = lindgen(ninds) + zoom
    endif else begin
        ref_index = long(nmom/2.)
        inds = lindgen(ninds) + zoom
    endelse


    !p.multi = [0,2,2,0,1]
    
    perform_hydra_walen
    if (get_err_no eq 2) then begin
        print, get_err_msg
        stop
    endif
    p_hydra_walen, hc=0
    
    perform_hydra_walen, /ion
    if (get_err_no eq 2) then begin
        print, get_err_msg
        stop
    endif
    p_hydra_walen, hc=0
    
    stop

endfor

stop
return
end
