pro write_walen_events_file, date_str
  
  hyd_access_get_timetags, timetags, 'wln_walen_slope', $
    gen_time( date=date_str, time='00:00' ), $
    gen_time( date=date_str, time='24:00' )
    
  if (n_elements(timetags) eq 0) then begin
      message, 'No Walen Events File For This Day', /cont
      return
  endif
  
  hyd_access, timetags, 'time_bin_start_ssm', start_time
  hyd_access, timetags, 'time_bin_width_seconds', dt
  hyd_access, timetags, 'wln_walen_slope', alpha
  hyd_access, timetags, 'wln_bavg', b_avg
  hyd_access, timetags, 'wln_bnorm', bnorm
  hyd_access, timetags, 'wln_ele_fit_status', rdflag

; Filter out the NON-Rotational Discontinuities
  gd = where(rdflag eq 1)
  start_time = start_time(gd)
  dt = dt(gd)
  alpha = alpha(gd)
  b_avg = b_avg(gd)
  bnorm = bnorm(gd)
  rdflag = rdflag(gd)
  
;======================================================

  ntime = n_elements(start_time)
  end_time = start_time + dt
  
  title = 'Walen'
  annotation = strarr(4)
  annotation(0) = 'blue indicates alpha negative and Bn/B large.'
  annotation(1) = 'cyan indicates alpha negative and Bn/B small.'
  annotation(2) = 'magenta indicates alpha positive and Bn/B large.'
  annotation(3) = 'red indicates alpha positive and Bn/B small.'
  
; Define the color string array
  colorstr = strarr(ntime)
  b = where(alpha le 0. and abs(bnorm/b_avg) gt .5)
  c = where(alpha le 0. and abs(bnorm/b_avg) le .5)
  m = where(alpha gt 0. and abs(bnorm/b_avg) gt .5)
  r = where(alpha gt 0. and abs(bnorm/b_avg) le .5)
  if (b(0) ne -1) then colorstr(b) = 'blue'
  if (c(0) ne -1) then colorstr(c) = 'cyan'
  if (m(0) ne -1) then colorstr(m) = 'magenta'
  if (r(0) ne -1) then colorstr(r) = 'red'
  
; Create a string array that duplicates the original
; events file that was read, so that the machinery below
; will work with minimal changes

  efile_string = strarr(1 + n_elements(annotation) + ntime)
  efile_string(0) = 'title '+title
  for ii=0,n_elements(annotation)-1 do begin
      efile_string(ii+1) = '; annotation: '+annotation(ii)
  endfor
  for ii=0,ntime-1 do begin
      efile_string(ii+1+n_elements(annotation)) = $
        '. '+colorstr(ii)+' fill '+date_str+' '+ $
        string(start_time(ii),'(f10.3)')+' '+ $
        string(end_time(ii),'(f10.3)')
  endfor

  openw, 10, date_str+'_walen_events.txt'
  for i=0,n_elements(efile_string)-1 do begin
      printf, 10, efile_string(i)
  endfor
  close, 10

end
