pro read_one, data, filename
  f= getenv('HYD_MVC_DATA_PATH')
  if f eq '' then f='/home/jds/aaaaaa-PAPER98/U_perp_e_vs_ExB/mvc_papco_data_sets/'
  
  datadir= f
  i=0
  message, 'Reading ' + datadir + filename, /cont

  openr, unit, /get_lun, datadir + filename
  s=''
  d1=double(0) & fff1=fltarr(3) & f1=0. & f2=0.
  while not eof( unit ) do begin
      readf, unit, s
      if strpos( s, 'NaN' ) eq -1 then begin
          reads, s, d1, fff1, f1, f2
          data(i).time= d1*3600
          data(i).comp= fff1
          data(i).theta= f1
          data(i).phi= f2
      endif else begin
          reads, s, d1
          data(i).time= d1*3600.
      endelse          
      i=i+1
  endwhile
  data= data(0:(i-1))
  close, unit
  free_lun, unit
end

pro read_papco_mvc, Bdata, J_perp_data, Pressdata, Qdata, $
                    U_perp_ele_data, U_perp_ion_data, edata, $
                    u_ele_data, u_ion_data, J_data
                    
                    

  datadir= '/home/jbf/scratch_pad/data/'

  data1= { time:double(1e31), $
           comp: [1e31,1e31,1e31], $
           theta: 1e31, $
           phi: 1e31 }
  
  Bdata= replicate( data1, 6272 )
  J_data= replicate( data1, 6272 )
  J_perp_data= replicate( data1, 6272 )
  Pressdata= replicate( data1, 6272 )
  Qdata= replicate( data1, 6272 )
  U_perp_ele_data= replicate( data1, 6272 )
  U_perp_ion_data= replicate( data1, 6272 )
  edata= replicate( data1, 6272 )
  u_ele_data= replicate( data1, 6272 )
  u_ion_data= replicate( data1, 6272 )

  read_one, Qdata, 'papco_mvc_Q'
  read_one, U_perp_ele_data, 'papco_mvc_U_perp_ele'
  read_one, U_perp_ion_data, 'papco_mvc_U_perp_ion'
  read_one, edata, 'papco_mvc_e'
  read_one, u_ele_data, 'papco_mvc_u_ele'
  read_one, u_ion_data, 'papco_mvc_u_ion'
  read_one, J_data, 'papco_mvc_J'
  read_one, Bdata, 'papco_mvc_B'
  read_one, J_perp_data, 'papco_mvc_perp_J'
  read_one, Pressdata, 'papco_mvc_minus_div_p_e'

  return
end


