pro read_one, data, filename
   f= getenv('HYD_EFI_SPECIAL_DATA')
   if f eq '' then f='/net/supras/export/data9/ftp/pub/polar/other/efi/'

  datadir= f
  i=0
  message, 'Reading ' + datadir + filename, /cont

  openr, unit, /get_lun, datadir + filename
  s=''
  while not eof( unit ) do begin
      readf, unit, s
      if strpos( s, 'NaN' ) eq -1 then begin
          d1=double(0) & fff1=fltarr(3) & f1=0. & f2=0.
          reads, s, d1, fff1, f1, f2
          data(i).time= d1*3600
          data(i).comp= fff1
          data(i).theta= f1
          data(i).phi= f2
      endif
      i=i+1
  endwhile
  close, unit
  free_lun, unit
end

pro read_papco_mvc, Bdata, J_perp_data, Pressdata, Qdata, $
                    U_perp_ele_data, U_perp_ion_data, edata, $
                    u_ele_data, u_ion_data, J_data
                    
                    

  datadir= '/home/jbf/scratch_pad/data/'

  data1= { time:double(1e31), $
           comp: [1e31,1e31,1e31], $
           theta: 1e31, $
           phi: 1e31 }
  
  Bdata= replicate( data1, 1556 )
  J_data= replicate( data1, 1556 )
  J_perp_data= replicate( data1, 1556 )
  Pressdata= replicate( data1, 1234 )
  Qdata= replicate( data1, 1556 )
  U_perp_ele_data= replicate( data1, 1556 )
  U_perp_ion_data= replicate( data1, 1556 )
  edata= replicate( data1, 1556 )
  u_ele_data= replicate( data1, 1556 )
  u_ion_data= replicate( data1, 1556 )

  read_one, Qdata, 'papco_mvc_Q'
  read_one, U_perp_ele_data, 'papco_mvc_U_perp_ele'
  read_one, U_perp_ion_data, 'papco_mvc_U_perp_ion'
  read_one, edata, 'papco_mvc_e'
  read_one, u_ele_data, 'papco_mvc_u_ele'
  read_one, u_ion_data, 'papco_mvc_u_ion'
  read_one, J_data, 'papco_mvc_J'
  read_one, Bdata, 'papco_mvc_B'
  read_one, J_perp_data, 'papco_mvc_perp_J'
  read_one, Pressdata, 'papco_mvc_minus_div_p_e'

  return
end


