pro read_one_nif2, data, filename
  f= getenv('HYD_NIF_DATA_PATH')
  if f eq '' then f='/home/jds/aaaaaa-PAPER98/U_perp_e_vs_ExB/P_I_New_1_13_2000/nif_papco_data_sets/'

  datadir= f
  i=0
  message, 'Reading ' + datadir + filename, /cont

  openr, unit, /get_lun, datadir + filename
  s=''
  while not eof( unit ) do begin
      readf, unit, s
      if strpos( s, 'NaN' ) eq -1 then begin
          d1=double(0) & fff1=fltarr(3) & f1=0. & f2=0. & f3=0.
          reads, s, d1, fff1, f1, f2
          readf, unit, f3
          data(i).time= d1*3600
          data(i).comp= fff1
          data(i).angle1= f1
          data(i).angle2= f2
          data(i).angle3= f3
      endif
      i=i+1
  endwhile
  if (i eq 0) then begin
      message, 'No records found in '+filename+'.  Check file.', /cont
      stop
  end
  data= data(0:(i-1))
  close, unit
  free_lun, unit
end

pro read_papco_nif2, vel_km_s=vel_km_s, traj_Re=traj_Re

  data1= { time:double(1e31), $
           comp: [1e31,1e31,1e31], $
           angle1: 1e31, $
           angle2: 1e31, $
           angle3: 1e31  }
  
  vel_km_s= replicate( data1, 6272 )
  traj_Re= replicate( data1, 6272 )
  
  read_one_nif2, vel_km_s, 'papco_nif_vel_km_s'
  read_one_nif2, traj_Re, 'papco_nif_traj_Re'

  return
end


