pro read_v34_scpot_may29_asc, time, extra=extra

; returns a structure with the fields:
;    v32raw
;    v32raw_time
;    scpot34
;    scpot34_time

   f= getenv('HYD_EFI_SPECIAL_DATA')
   if f eq '' then f='/net/supras/export/data9/ftp/pub/polar/other/efi/'

   message, 'opening '+f+'v34l_scpot_may29.asc', /cont
   openr, unit, /get_lun, f+'v34l_scpot_may29.asc'
   
   s='*'
   while strmid(s,0,1) eq '*' do begin
       readf, unit, s           ; skip comments at beginning
       if strmid(s,2,10) eq 'Date/Time:' then begin
           extra={production_date:strmid(s,13,30), $
                  file:f+'v34l_scpot_may29.asc'}
       endif
   endwhile

   for i=1,2 do begin
       s=''
       while strmid(s,0,5) ne 'Start' do readf, unit, s
       type= strmid(s,6,22)
       print, 'Reading '+type+'...'
       
       done_with_header=0
       while not done_with_header do begin
           readf, unit, s
           case 1 of
               strmid(s,0,6) eq 'Points': begin
                   ipoints= long( strmid( s, 7, 9 ) )
                   ipoints= ipoints-1 ; kludge -- data file number is +1
                   time= dblarr( ipoints )
                   data= fltarr( ipoints )
               end
               strmid(s,0,16) eq 'Component Depths': begin
                   done_with_header=1
               end
               else:
           endcase
       endwhile
       
       i1=0L & d1=0. & r2=0.
       s=''
       done=0
       while not done do begin
           readf, unit, s
           if strmid( s, 0, 3 ) eq 'End' then done=1 else begin             
               reads, s, i1, d1, r2
               time(i1)= d1
               data(i1)= r2
           endelse
       endwhile

       case type of
           'POLAR_V34L_NoC_Raw': begin
           extra1= { v34raw:data, $
                     v34raw_time:time }
           end
           'POLAR_SCPot34_NoC': begin
               extra1= { scpot34:data, $
                         scpot34_time:time }
           end
           else: begin
               print, "Unidentified data set skipped: ", type
               r= temporary( extra1 )
           end               
       endcase
       
       if n_elements( extra1 ) gt 0 then begin
           if n_elements( extra ) eq 0 then begin
               extra= extra1
           endif else begin
               extra= create_struct( extra, extra1 )
           endelse
       endif
   endfor

   if n_params() eq 1 then begin
       time=extra
   endif

   return
end

