pro read_v_gsm_may29_asc, time, Vx, Vy, Vz, extra=extra

; vx, vy, vz, time  original file format.
; other quantities are returned in extra structure.

   f= getenv('HYD_EFI_SPECIAL_DATA')
   if f eq '' then f='/net/supras/export/data9/ftp/pub/polar/other/efi/'

   file= f+'final_jack_may_29.asc'
   message, 'opening '+file, /cont
   openr, unit, /get_lun, file
   
   s='*'
   while strmid(s,0,1) eq '*' do begin
       readf, unit, s           ; skip comments at beginning
       if strmid(s,2,10) eq 'Date/Time:' then begin
           extra={production_date:strmid(s,13,30), $
                  file:file}
       endif
   endwhile

   for i=1,9 do begin           ; read three components
       s=''
       while strmid(s,0,5) ne 'Start' do readf, unit, s
       type= strmid(s,6,22)
       print, 'Reading '+type+'...'
       
       done_with_header=0
       while not done_with_header do begin
           readf, unit, s
           case 1 of
               strmid(s,0,6) eq 'Points': begin
                   ipoints= long( strmid( s, 7, 9 ) )
                   ipoints= ipoints-1 ; kludge -- data file number is +1
                   if n_elements(common_time) eq 0 then begin
                       common_time= dblarr( ipoints )
                   endif 
                   time= dblarr( ipoints )
                   data= dblarr( ipoints )
                   newtime=0
               end
               strmid(s,0,16) eq 'Component Depths': begin
                   done_with_header=1
               end
               else:
           endcase
       endwhile
       
       i1=0 & r1=0. & r2=0.
       for j=0L,ipoints-1 do begin
           readf, unit, i1, r1, r2
           time(i1)= r1
           data(i1)= r2
           if i1 gt n_elements(common_time)-1 then newtime=1 else $
             if common_time(i1) ne 0. then $
             if common_time(i1) ne time(i1) then  newtime=1
       endfor

       if newtime then begin
           message, 'Interpolating data to common time tags.', /cont
           data= interpol( data, time, common_time )
       endif

       case type of
           'POLAR_v_X_GSM_34_A_NoC': begin
               Vx= data       
               extra1= { vx:data }
           end
           'POLAR_v_Y_GSM_34_A_NoC': begin
               Vy= data
               extra1= { vy:data }
           end
           'POLAR_v_Z_GSM_34_A_NoC': begin
               Vz= data
               extra1= { vz:data }
           end
           'POLAR_EX_GSM_34_A_NoC': begin
               extra1= { ex_gsm:data }
           end
           'POLAR_EY_GSM_34_A_NoC': begin
               extra1= { ey_gsm:data }
           end
           'POLAR_EZ_GSM_34_A_NoC': begin
               extra1= { ez_gsm:data }
           end
           'POLAR_EX_FAC_34_A_NoC': begin
               extra1= { ex_fac:data }
           end
           'POLAR_EY_FAC_34_A_NoC': begin
               extra1= { ey_fac:data }
           end
           'POLAR_EZ_FAC_34_A_NoC': begin
               extra1= { ez_fac:data }
           end
           else: begin
               print, "Data set skipped: ", type
               r= temporary( extra1 )
           end               
       endcase
       
       if common_time(0) eq 0. then begin
           common_time= time
       endif
           
       if n_elements( extra1 ) gt 0 then begin
           if n_elements( extra ) eq 0 then begin
               extra= extra1
           endif else begin
               extra= create_struct( extra, extra1 )
           endelse
       endif
   endfor

   close, unit
   free_lun, unit

   extra1= { time:common_time }
   extra= create_struct( extra1, extra )
   
   if n_params() eq 1 then begin
       time=extra
   endif

   return
end
