pro read_xy_z_56_may29_asc, time, Vx, Vy, Vz, extra=extra

   f= getenv('HYD_EFI_SPECIAL_DATA')
   if f eq '' then f='/net/supras/export/data9/ftp/pub/polar/other/efi/'

   file= f+'Badded_final_xy_z_56_jack_may29.asc'
   message, 'opening '+file, /cont
   openr, unit, /get_lun, file
   
   s='*'
   while strmid(s,0,1) eq '*' do begin
       readf, unit, s           ; skip comments at beginning
       if strmid(s,2,10) eq 'Date/Time:' then begin
           extra={production_date:strmid(s,13,30), $
                  file:file }
       endif
   endwhile
   
   ipoints0= -1
   idataset= 1
   while not eof(unit) do begin
       s='' & err=0
       while strmid(s,0,5) ne 'Start' and not eof(unit) do $
         readf, unit, s
       if not eof(unit) then begin
           type= strmid(s,6,22)
           print, 'Reading '+type+'...'
           
           done_with_header=0
           while not done_with_header do begin
               readf, unit, s
               case 1 of
                   strmid(s,0,6) eq 'Points': begin
                       ipoints= long( strmid( s, 7, 9 ) )
                       ipoints= ipoints-1 ; kludge -- data file number is +1
                       if ipoints0 ne ipoints then begin
                           time= dblarr( ipoints )
                       endif
                       data= dblarr( ipoints )
                       newtime=0
                   end
                   strmid(s,0,16) eq 'Component Depths': begin
                       done_with_header=1
                   end
                   else:
               endcase
           endwhile
           
           i1=0 & D1=double(0.) & d2=double(0.)
           done=0
           s=''
           while not done do begin
               readf, unit, s
               if strmid( s, 0, 3 ) eq 'End' then done=1 else begin
                   reads, s, i1, d1, d2
                   time(i1)= d1
                   if ipoints0 eq ipoints then begin
                       if time0(i1) ne time(i1) then message, $
                         'time tags change!', /cont
                   endif
                   data(i1)= d2
               endelse
           endwhile
           
           case type of
               'POLAR_EX-Y_34_A_NoC': begin
                   extra1= { exy:data }
                   timetag= 'etime'
               end
               'POLAR_EZ_34_A_NoC': begin
                   extra1= { ez:data }
                   timetag= 'etime'                   
               end
               'POLAR_E56_34_A_NoC': begin
                   extra1= { e56:data }
                   timetag= 'etime'
               end
               'POLAR_BX-Y_34_A': begin
                   extra1= { bxy:data }
                   timetag= 'btime'
               end
               'POLAR_BZ_34_A': begin
                   extra1= { bz:data }
                   timetag= 'btime'
               end
               'POLAR_B56_34_A': begin
                   extra1= { b56:data }
                   timetag= 'btime'
               end
               else: begin
                   print, "Data set skipped: ", type
                   r= temporary( extra1 )
               end               
           endcase
           
           if ipoints0 ne ipoints then begin
               extra0= create_struct( timetag, $
                                      time )
               time0= time
               if n_elements( extra ) eq 0 then begin
                   extra= extra0
               endif else begin
                   extra= create_struct( extra, extra0 )
               endelse
               r= temporary( extra0 )               
               idataset= idataset + 1
               ipoints0= ipoints
           endif
           
           if n_elements( extra1 ) gt 0 then begin
               if n_elements( extra ) eq 0 then begin
                   extra= extra1
               endif else begin
                   extra= create_struct( extra, extra1 )
               endelse
           endif

       endif
   endwhile
       
   close, unit
   free_lun, unit
       
   if n_params() eq 1 then begin
       time=extra
   endif

   return
end
