pro write_sdt, file, header_in, data_in

  tab= string(9B)

  openw, unit, /get_lun, file
   
  
  printf, unit, '*'
  printf, unit, '* SDT Version:  Hydra''s write_sdt.pro'
  printf, unit, '* Date/Time: '+header_in.production_date
  printf, unit, '*'
  
  tags= tag_names( data_in )
  ipoints= n_elements( data_in.time )
  time= data_in.time

  for i=1,n_elements(tags)-1 do begin
      printf, unit, ' '

      type= tags(i)
      printf, unit, 'Start'+tab+type

      print, 'Writing '+type+'...'
       
      printf, unit, tab+'-'
      printf, unit, 'Name'+tab+'-'
      printf, unit, 'Time'+tab+ $
        string(header_in.start_time,format='(i8)') + tab + $
        '00000.000000'+ tab + $
        string(header_in.end_time,format='(i8)')
      printf, unit, 'Points'+tab+string(ipoints+1,format='(i7)')
      printf, unit, 'Component Depths'
      
      r= execute( 'data= data_in.'+tags(i) )
      for j=0L,ipoints-1 do begin
          printf, unit, j, time(j), data(j)
      endfor
      
      printf, unit, 'End'
      
  endfor
   
  close, unit
  free_lun, unit

  return
end

