pro draw_hyd_access, panelVector, currPlotInfo, orbitNo, $
                     get_data_call, slice_type, IsRead

  COMMON extra, extra_PlotInfo  ; passes in papco-set keywords structure
    
  get_data_call=""              ; data read call used by slices

; set parameter for plot routine. In this example, channel 1 -10 chooses the 
; channel number for a line plot, channel=0 chooses a spectrum color plot.
  channel=currPlotInfo.typeVector(0)
  
; as papco dynamically allocates slice values for the user defined
; slices, one needs to be able to find out this assignment! Use the
; following function to find out the slice values for any slices you
; might have added for your module, so that you know which values to enable!
  
; set up which mouse functions to allow
  slice_type=1+2+4+8+16

  panelset,panelVector          ;sets the panel position viewport

; process typeVector options.
  if ( currPlotInfo.typeVector(1) and 1 ) eq 1 then begin ; color enhancements
      forward_function hydra_plot_widget_codei4
      value= hydra_plot_widget_codei4(currPlotInfo.typeVector(1),/decode)
      common papco_color_names       
      hp_kw={ reference:value.reference }
      if value.poly_above_ref gt 0 then $
        hp_kw= create_struct( hp_kw, { poly_above_ref:red} )
      if value.poly_below_ref gt 0 then $
        hp_kw= create_struct( hp_kw, { poly_below_ref:blue } )
  endif   

  ident= currPlotInfo.filename
  component= currPlotInfo.typeVector(0)
  phi_center= currPlotInfo.typeVector(2)
  coordinate_frame= (['payload','gsm'])(currPlotInfo.typeVector(3))

  common time, xut1, xut2
  xrange=[ xut1, xut2 ]
  
  p_hyd_access, panelVector, ident, $
    xrange=xrange, component=component, phi_center=phi_center, $
    coordinate_frame=coordinate_frame, $
    _EXTRA=extra_PlotInfo, hydra_plot_kw=hp_kw

  common coordinateSystems, plotted_x, plotted_y
  plotted_x= !x
  plotted_y= !y
                                ;info on coords used by mouse
END
 
 
