pro draw_event_marks, panelVector, currPlotInfo, orbitNo, $
                      get_data_call, slice_type, IsRead
  

  COMMON extra, extra_PlotInfo  ; passes in papco-set keywords structure
    
  get_data_call=""              ; data read call used by slices

; as papco dynamically allocates slice values for the user defined
; slices, one needs to be able to find out this assignment! Use the
; following function to find out the slice values for any slices you
; might have added for your module, so that you know which values to enable!
  
; set up which mouse functions to allow
  slice_type=1+2

  panelset,panelVector          ;sets the panel position viewport

  common time, xut1, xut2
  xrange=[ xut1, xut2 ]

  if panelVector(0) eq 0 then begin
      xtickformat= 'hydra_timeticks'
  endif else begin
      xtickformat= 'noticks'
  endelse

  goodticks, xtickv, xminor
  xticks=n_elements(xtickv)-1

  if extra_PlotInfo.overplot eq 0 then begin
      plot, [1,2], /nodata, $
        xrange=[0,xut2-xut1], $
        yrange=[0,1], $
        xtickformat=xtickformat, $
        xtickv= xtickv, $
        xminor= xminor, $
        xticks= xticks, color=1, $
        xstyle=1, ystyle=1
  endif else begin
      plot, [1,2], /nodata, $
        xrange=[0,xut2-xut1], $
        yrange=[0,1], $
        xtickformat=xtickformat, $
        xtickv= xtickv, $
        xminor= xminor, $
        xticks= xticks, color=1, $
        xstyle=5, ystyle=5      
  endelse
  
  r= where( currPlotInfo.options(0:9) ne 0. )
  if r(0) ne -1 then begin
      marks= gen_time_to( /t90, currPlotInfo.options(r) ) - xut1
      type= 'x_bar'
      delta= currPlotInfo.options(r+10)
      color= extra_PlotInfo.color
      linestyle= extra_PlotInfo.linestyle
      thick= extra_PlotInfo.thick
      p_event_marks, marks, type, color, delta, $
        linestyle=linestyle, thick=thick
  end

  common coordinateSystems, plotted_x, plotted_y
  plotted_x= !x
  plotted_y= !y
                                ;info on coords used by mouse
END
 
 
