pro draw_file_ascii, panelVector, currPlotInfo, orbitNo, $
                    get_data_call, slice_type, IsRead

  COMMON extra, extra_PlotInfo  ; passes in papco-set keywords structure
    
  get_data_call="r_file_ascii"   ; data read call used by slices

; set parameter for plot routine. In this example, channel 1 -10 chooses the 
; channel number for a line plot, channel=0 chooses a spectrum color plot.
  channel=currPlotInfo.typeVector(0)
  
; as papco dynamically allocates slice values for the user defined
; slices, one needs to be able to find out this assignment! Use the
; following function to find out the slice values for any slices you
; might have added for your module, so that you know which values to enable!
  
; set up which mouse functions to allow
  slice_type=1+2+4+8+16

  r_file_ascii, currPlotInfo, header, timetags, data ; read data
                                ; check the read for success.
  if papco_Draw_CheckResult(currPlotInfo.panelKind, $
                            panelVector, orbitNr, $
                            currPlotInfo.typeVector, $
                            currPlotInfo.channel) then IsRead=1 else IsRead=0
  
  IF IsRead THEN BEGIN
      panelset,panelVector      ;sets the panel position viewport
      p_file_ascii, panelVector, header, timetags, data, $
        _EXTRA=extra_PlotInfo 
      common coordinateSystems, plotted_x, plotted_y
      plotted_x= !x
      plotted_y= !y
                                ;info on coords used by mouse
  endif
  
END
 
 
