pro draw_hd_scratch_pad, panelVector, currPlotInfo, orbitNo, $
                     get_data_call, slice_type, IsRead

  COMMON extra, extra_PlotInfo  ; passes in papco-set keywords structure
    
  get_data_call=""              ; data read call used by slices

; set parameter for plot routine. In this example, channel 1 -10 chooses the 
; channel number for a line plot, channel=0 chooses a spectrum color plot.
  channel=currPlotInfo.typeVector(0)
  
; as papco dynamically allocates slice values for the user defined
; slices, one needs to be able to find out this assignment! Use the
; following function to find out the slice values for any slices you
; might have added for your module, so that you know which values to enable!
  
; set up which mouse functions to allow
  slice_type=1+2+4+8+16

  panelset,panelVector          ;sets the panel position viewport

; process typeVector options.
  common papco_color_names       
  if ( currPlotInfo.typeVector(1) and 1 ) eq 1 then begin ; color enhancements
      forward_function hydra_plot_widget_codei4
      value= hydra_plot_widget_codei4(currPlotInfo.typeVector(1),/decode)
      hp_kw={ reference:value.reference }
      if value.poly_above_ref gt 0 then $
        hp_kw= create_struct( hp_kw, { poly_above_ref:red} )
      if value.poly_below_ref gt 0 then $
        hp_kw= create_struct( hp_kw, { poly_below_ref:blue } )
  endif   

  if ( currPlotInfo.ioptions(15) and 1 ) eq 1 then begin ; color enhancements
      value= hydra_plot_widget_codei4(currPlotInfo.typeVector(1),/decode)
      hp_kw= { reference:currPlotInfo.options(15) }
      if (currPlotInfo.ioptions(15) and 4)/4 then $
        hp_kw= create_struct( hp_kw, { poly_above_ref:red} )
      if (currPlotInfo.ioptions(15) and 2)/2 then $
        hp_kw= create_struct( hp_kw, { poly_below_ref:blue} )
  endif

  filename= currPlotInfo.soptions(5)
  if filename ne '' then begin
      message, 'Reading scratch pad file '+filename+'.', /cont
      restore, filename
      vars= value.vars
      idents= value.idents
      idl_program= value.idl_program
      label= value.label
      units= value.units
  endif else begin      
      message, 'Using scratch pad definition from .papco file.', /cont
      vars= str_sep(currPlotInfo.soptions(0),'&')
      idents= str_sep(currPlotInfo.soptions(1),'&')
      idl_program= str_sep(currPlotInfo.soptions(2),'&')
      label= currPlotInfo.soptions(3)
      units= currPlotInfo.soptions(4)
  endelse

  component= currPlotInfo.typeVector(0)

  common time, xut1, xut2
  xrange=[ xut1, xut2 ]
  
  p_hd_scratch_pad, panelVector, $
    vars=vars, idents=idents, idl_program=idl_program, $
    label=label, $
    units=units, $
    xrange=xrange, $
    component=component, $
    _EXTRA=extra_PlotInfo, hydra_plot_kw=hp_kw

  common plot_composer, widgetData
  t= tag_names( widgetData )
  if (where( t eq 'SEQUENCEPLOTSDRAWN' ))[0] ne -1 then begin
      if widgetData.sequencePlotsDrawn+1 eq widgetData.numberOfPlots then begin
          f= hd_get_footprints()      
          id= hydra_id( f, draft= !d.name eq 'X' or !d.name eq 'WIN' )
          xyouts, /norm, 1, 0, align=1, strtrim(id,2), $
            charsize=1.0, color=1
          print, 'hydra_id= '+strtrim(id,2)
      endif
  endif
  
  common coordinateSystems, plotted_x, plotted_y
  plotted_x= !x
  plotted_y= !y
                                ;info on coords used by mouse
END
 
 
