pro file_ascii_set_header, header
  COMMON file_ascii_panel_DATA, widgetData
  widget_control, widgetData.label_id, set_value= header.label
  widget_control, widgetData.units_id, set_value= header.units
end

;***************************************************************************
;* 
;* PROCEDURE:     
;*      PRO file_ascii_panel_event, event
;* 
;* DESCRIPTION:  
;*	This processes events from the XMANAGER.
;*	As this example does not extend the basic functionality of plot-
;*	editors, it directly calls the default-handler, PAPCO_PANEL_Event
;*
;* INPUTS:       
;*	event		an XManager event
;*			
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:       
;*     written august 1995, Andreas Keese
;*
;***************************************************************************
PRO file_ascii_panel_event, event, uvalue=uval
   COMMON file_ascii_panel_DATA, widgetData
   common rp_file_ascii_common, fv_out_header, fv_ele, fv_ion

   if n_elements( uval ) eq 0 then begin
       WIDGET_CONTROL,GET_UVALUE=uval, event.id
   endif

   if n_elements( uval ) eq 0 then begin
   endif else begin
       if uval eq 'hfw_load' then begin
           r_file_ascii, widgetData, header, /just_header ; note widgetData is similar to 
           openr, unit, /get_lun, widgetData.filename ; plotInfo
           s=strarr(30) & s1=''
           more=' --- file truncated ---'
           for i=0,n_elements(s)-1 do begin
               if not eof(unit) then begin
                   readf, unit, s1
                   s(i)=s1
               endif
               if eof(unit) then begin
                   more=''
                   goto, break
               endif
           endfor
           break:
           s=[s,more]
           close, unit
           file_ascii_set_header, header
           widget_control, widgetData.file_display_id, set_value=s
       endif else if uval eq 'hfw_edit' then begin
                                ; not implemented
       endif else if uval eq 'pb_reload' then begin
       endif else if strleft(uval,3) eq 'hfw' then begin
           widgetData= hydra_file_widget_event( event, widgetData )
       endif else begin
           widgetData=PAPCO_panel_Event(event, widgetData)
       ENDELSE
   endelse
END


;***************************************************************************
;***************************************************************************
;* 
;* FILE:
;*    $PAPCO_PATH/file_ascii_panel.pro
;* 
;*    This file belongs to the PAPCO-project. See $PAPCO_PATH/papco.pro for
;*    further information.
;*
;* DESCRIPTION: 
;*    This file contains a demonstration on how to implement a PAPCO-
;*    panel-editor. It makes use of all the features provided by 
;*    $PAPCO_PATH/papco_panel.pro
;*    It constructs an editor for a very simple PAPCO-plot, that has only
;*    default-functionality.
;*
;* FILES YOU MAY WANT TO READ
;*       $PAPCO_PATH/papco_conventions.text     which conventions were used
;*						when developing ?
;*	 $PAPCO_PATH/papco_variables.text	what structures and global
;*						variables are used by 
;*						which file ?
;*
;* USED MODULES:
;*    For a list of files, that are needed for PAPCO to run, read the 
;*    file addpapco_init.PRO in $PAPCO_MODULES
;*
;* COMMON-BLOCKS:
;*    file_ascii_panel_DATA	contains the window-information
;*
;* STRUCTURES:
;*    This module creates one concrete structure, that inherits from the 
;*    PAPCO_PANEL_EDITOR-structure (see $PAPCO_PATH/papco_panel.pro for a
;*    description). 
;*       {file_ascii_panel_DATA, 
;*	     ; imagine the PAPCO_PANEL_EDITOR-structure was inserted...
;*	      
;*    For a more complete description see $PAPCO_PATH/papco_variables.text
;*
;* OVERVIEW:
;*    This function creates the editor-window:
;*       FUNCTION  file_ascii_panel, aPlotInfo, GROUP=group, ACTION=ACTION
;*    You might try this:
;*	 print, file_ascii_panel(PAPCO_getPlotInfoStruct())
;*       which calls up the window.
;*
;* MODIFICATION HISTORY:       
;*     august 1995, written by A.Keese
;*     December 1995, modified by R.Friedel at Goddard
;*     
;***************************************************************************



;***************************************************************************

;***************************************************************************
;* 
;* FUNCTION:     
;*      FUNCTION  file_ascii_panel, aPlotInfo, GROUP=group, ACTION=ACTION
;* 
;* DESCRIPTION:  
;*	Open an editor for a panelplot.
;*	Its window is constructed using the methods defined in the file
;*	$PAPCO_PATH/papco_panel.pro
;*	When the user presses the 'Done'- or the 'Cancel'-Button, the values 
;*	changed by the event-methods of papco_panel.pro are returned.
;*	The returned value is a structure containing those values and a flag,	
;*	'canceled', which the caller may read out to check, whether the 
;*	window was closed using the 'Cancel' or the 'Done'-Button.
;*
;* INPUTS:       
;*	aPlotInfo	a structure of the PAPCO_PLOTINFO-type
;*			this structure is edited in the window.
;*     
;* KEYWORDS:
;* 	GROUP		a WIDGET_BASE
;*			when specified, this is used as GROUP_LEADER
;*	ACTION		a string
;*			when specified, the 'Done'-Button is labeled with it
;*		        if not specified, the 'Done'-Button is labeled 'Done'
;*
;* OUTPUT:	 
;*      a default-structure of type PAPCO_PANEL_EDITOR_RETURN. Though this
;*	type is nowhere defined, I like to think of it as virtually existing
;*	data-type. 
;*	All the functions in $PAPCO_PATH/papco.pro that edit plots or add new
;*	ones, expect the opened editor-windows to return a structure containing
;*	at last some fields. Those fields might make up a structure, but as no
;*	program defines the structure-type PAPCO_PANEL_EDITOR_RETURN, this 
;*	poor structure is not alive but only virtual.
;*	The return-values of plot-editors have to expand this structure - I 
;*	like to think, that they inherit from that structure - and contain at
;*	least those fields:
;*   		{$
;*			canceled:1, $
;*	    		panelHeight:1, $
;*	    		channel:0, $
;*	    		typeVector:[0,0,0,0], $ 
;*	    		manualYScaling:0 $
;*	    		yScaleMin:LONG(1), $
;*	    		yScaleMax:LONG(1), $
;*	    		panelKind:'some string'}
;*
;*      Additionally, some Panel-editors may return these fields in
;*      structure:
;*               {$
;*		        color:1, $
;*			plotStyle:1}
;*			
;*      For an enhanced description read $PAPCO_PATH/papco_variables.text
;*
;* CALLING SEQUENCE:
;*	aPlotInfoStruct=PAPCO_getPlotInfoStruct()
;*
;* MODIFICATION HISTORY:       
;*     written august 1995, Andreas Keese
;*
;***************************************************************************

FUNCTION  file_ascii_panel, aPlotInfo, GROUP=group, ACTION=ACTION
   COMMON file_ascii_panel_DATA, widgetData

; if GROUP is not specified, the group-leader will be the desktop
   IF NOT KEYWORD_SET(GROUP) THEN GROUP=0

; set the label for the action-button
   IF NOT KEYWORD_SET(ACTION) THEN ACTION='Done'

; the routines used by papco_panel.pro define tags for a structure. Those
; tags will be stored in the structure 'additionalWData'. When you realize the
; window, you have to add your own window-specific data to that structure 
; and afterwards assign it to widgetData.
   additionalWData={canceled:1}

;--- create the base-window ----------------------------------------------------
   panel_base=WIDGET_BASE(title=aPlotInfo.panelKind,$
	 column=1, $
	 GROUP_LEADER=group)

;--- the first part of the window will consist in the widgets ------------------
;    that control the height of that plot
   widgets=PAPCO_panel_AddHeightWidgets(panel_base, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

;  list filename
   widgets= hydra_File_Widget(panel_base, aPlotInfo, /load )
   additionalWData=create_struct(widgets, additionalWData)

;  file display here
   w= widget_text( panel_base, xsize=80, ysize=8, /scroll, $
                   value=['','','','             File Not Loaded'] )
   additionalWData= create_struct( { file_display_id:w }, additionalWData )
   
   pparm_base= widget_base( panel_base, /column, /frame )

   b1= widget_base( pparm_base, /row )
   x= widget_label( b1, value='Label: ' )
   w1= widget_label( b1, value='                              ' )

   b1= widget_base( pparm_base, /row )
   x= widget_label( b1, value='Units: ' )
   w2= widget_label( b1, value='                              ' )   
   additionalWData= create_struct( { label_id:w1, units_id:w2 }, $
                                   additionalWData )

;--- add the widgets for choosing the plot-style -------------------------------
   widgets=PAPCO_panel_add_PlotStyleButtons(panel_base, aPlotInfo, 0)
   additionalWData=create_struct(widgets, additionalWData)
   
;    yrange widget
   widgets=PAPCO_PANEL_AddYScale_Widgets(panel_base, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

;--- finally, the Actionbuttons (help, cancel, done) are added to the ---------
;    editor window.
   widgets=PAPCO_panel_AddActionButtons(panel_base, Action, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

;--- now, create the structure that keeps the panel-window data. You
;    always need to specify the help-file, and your structure must
;    always contain the 'additionalWData'.
   if hydra_new_papco(vers=vers) and vers ge 9.0 then begin       
       thisWidgetsData={ helpfile:'file_ascii_panel.help', $
                         typevector:aPlotInfo.typeVector, $
                         swwitch:aPlotInfo.swwitch }
   endif else begin
       thisWidgetsData={ helpfile:'file_ascii_panel.help', $
                         typevector:aPlotInfo.typeVector }
   endelse       
   
   widgetData=PAPCO_PANEL_CreateWidgetData(thisWidgetsData, additionalWData)

;   if the filename has been specified, go ahead and hit "load"
   if widgetData.filename ne '' then begin
       file_ascii_panel_event, uval='hfw_load'
   endif
   
;--- realize the window
   PAPCO_Panel_Realize, panel_base, widgetData
   
; As this is a function that will return all changes made by the
; user, the xmanager has to be called with the keyword MODAL. If we
; wouldn't specify /MODAL, no changes would be reportet but the 
; data contained in aPlotInfo would be returned.
   xmanager, 'file_ascii_panel', panel_base, /MODAL

; the returned data consists of the standard-data inherited from
; PAPCO_PANEL.PRO and your new data - e.g. the typeVector-tag.
   returnData={ typeVector:widgetData.typeVector, $
                swwitch:widgetData.swwitch }

   additionalRData=PAPCO_panel_ReturnData(widgetData)

   return, create_struct(ReturnData, additionalRData)
END





