;**************************************************************************
;* 
;* PROCEDURE:     
;*      PRO hd_scratch_pad_panel_event, event
;* 
;* DESCRIPTION:  
;*	This processes events from the XMANAGER.
;*	As this example does not extend the basic functionality of plot-
;*	editors, it directly calls the default-handler, PAPCO_PANEL_Event
;*
;* INPUTS:       
;*	event		an XManager event
;*			
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:       
;*     written august 1995, Andreas Keese
;*
;***************************************************************************
PRO hd_scratch_pad_panel_event, event, uvalue=uval
   COMMON hd_scratch_pad_panel_DATA, widgetData
   common rp_hd_scratch_pad_common, fv_out_header, fv_ele, fv_ion

   if n_elements( uval ) eq 0 then begin
       WIDGET_CONTROL,GET_UVALUE=uval, event.id
   endif

   if n_elements( uval ) eq 0 then begin
   endif else begin
       s_uval= str_sep( uval, ':' )
       if s_uval(0) eq 'hp_kw' then begin
           v= event.value
           widgetData.typeVector(1)= v.codei4           
           widgetData.options(15)= v.reference
           widgetData.ioptions(15)= $
             v.poly_above_ref*4 + $
             v.poly_below_ref*2 + $
             v.draw_reference*1
       endif else if uval eq 'component' then begin
           widgetData.typevector(0)= event.value
       endif else if uval eq 'pb_cancel' then begin
           cw_hd_scratch_pad_cancel, widgetData.id_hd_scratch_pad
           widgetData=PAPCO_panel_Event(event, widgetData)
       endif else if  uval eq 'pb_done' or $
         uval eq 'pb_done_and_cont' then begin
           widget_control, widgetData.id_hd_scratch_pad, get_value=x
           widgetData.soptions[3]= x.label
           widgetData.soptions[4]= x.units
           widgetData.soptions[0]= hyd_str_join(x.vars,'&')
           widgetData.soptions[1]= hyd_str_join(x.idents,'&')
           widgetData.soptions[2]= hyd_str_join(x.idl_program,'&')
           widgetData.ioptions[1]= widgetData.ioptions[1]+1 ; trigger papco redraw
           widgetData.soptions[5]= x.filename
           widgetData=PAPCO_panel_Event(event, widgetData)
       endif else begin
           widgetData=PAPCO_panel_Event(event, widgetData)
       ENDELSE
   endelse
END

;-------------------------------------------------------------
; hd_scratch_pad_panel.pro
; 
; Uses papco state vectors from aPlotInfo:
;   typeVector[0]  component selector
;   typeVector(1)  hydra_plot widget state
;   soptions[0]    variable names delimited by & (copy)
;   soptions[1]    hyd_access id's delimited by & (copy)
;   soptions[2]    idl program delimited by & (copy)
;   soptions[3]    panel label (copy)
;   soptions[4]    panel units label (copy)
;   soptions[5]    filename ; this is the state!!!
;   ioptions[1]    used to trigger papco redraw
;   options(15)    hydra_plot_widget state
;   ioptions(15)   hydra_plot_widget state
;-------------------------------------------------------------

FUNCTION  hd_scratch_pad_panel, aPlotInfo, GROUP=group, ACTION=ACTION
   COMMON hd_scratch_pad_panel_DATA, widgetData

; if GROUP is not specified, the group-leader will be the desktop
   IF NOT KEYWORD_SET(GROUP) THEN GROUP=0

; set the label for the action-button
   IF NOT KEYWORD_SET(ACTION) THEN ACTION='Done'

; the routines used by papco_panel.pro define tags for a structure. Those
; tags will be stored in the structure 'additionalWData'. When you realize the
; window, you have to add your own window-specific data to that structure 
; and afterwards assign it to widgetData.

   additionalWData={canceled:1}

;--- create the base-window ----------------------------------------------------
   panel_base=WIDGET_BASE(title=aPlotInfo.panelKind,$
	 column=1, $
	 GROUP_LEADER=group)

;--- the first part of the window will consist in the widgets ------------------
;    that control the height of that plot
   widgets=PAPCO_panel_AddHeightWidgets(panel_base, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)


;### hd scratch pad compound widget ###
   id_hd_scratch_pad= cw_hd_scratch_pad( panel_base )

   additionalWData= create_struct( { id_hd_scratch_pad:id_hd_scratch_pad, $
                                     filename:aPlotInfo.filename, $
                                     soptions:aPlotInfo.soptions, $
                                     ioptions:aPlotInfo.ioptions, $
                                     options:aPlotInfo.options }, $
                                   additionalWData )
   component_base= widget_base( panel_base, /frame, /column )
   additionalWData= create_struct( { component_base:component_base }, $
                                   additionalWData )
   x= cw_bgroup( component_base, [ 'x', 'y', 'z', $
                                   'magnitude', 'theta', 'phi' ], $
                 /exclusive, row=1, ids=ids, uvalue='component' )
   widget_control, ids(aPlotInfo.typevector(0)), set_button=1

;### end hd scratch pad compound widget ###
   
;   color highlighting widget (hydra plot keywords)
   w= hydra_plot_widget( panel_base, /frame, uvalue='hp_kw' )
   v= { $
        codei4:aPlotInfo.typeVector(1), $
        reference:aPlotInfo.options(15), $
        poly_above_ref: aPlotInfo.ioptions(15) and 4 / 4, $
        poly_below_ref: aPlotInfo.ioptions(15) and 2 / 2, $
        draw_reference: aPlotInfo.ioptions(15) and 1 / 1 $
      }
   widget_control, w, set_value=v
   
;--- add the widgets for choosing the plot-style -------------------------------
   widgets=PAPCO_panel_add_PlotStyleButtons(panel_base, aPlotInfo, 0)
   additionalWData=create_struct(widgets, additionalWData)
   
;    yrange widget
   widgets=PAPCO_PANEL_AddYScale_Widgets(panel_base, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

;--- finally, the Actionbuttons (help, cancel, done) are added to the ---------
;    editor window.
   widgets=PAPCO_panel_AddActionButtons(panel_base, Action, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

;--- now, create the structure that keeps the panel-window data. You
;    always need to specify the help-file, and your structure must
;    always contain the 'additionalWData'.
   if hydra_new_papco(vers=vers) and vers ge 9.0 then begin
       thisWidgetsData={ helpfile:'hd_scratch_pad_panel.help', $
                         typevector:aPlotInfo.typeVector }
   endif else begin
       thisWidgetsData={ helpfile:'hd_scratch_pad_panel.help', $
                         typevector:aPlotInfo.typeVector }
   endelse
   
   widgetData=PAPCO_PANEL_CreateWidgetData(thisWidgetsData, additionalWData)

;--- realize the window
   PAPCO_Panel_Realize, panel_base, widgetData, $
     xoffset=300, yoffset=0
   
   widget_control, widgetData.id_hd_scratch_pad, get_value=x
   x.label= widgetData.soptions[3]
   x.units= widgetData.soptions[4]
   s= str_sep( widgetData.soptions[0],'&' )
   x.vars[0:(n_elements(s)-1)]= s
   s= str_sep( widgetData.soptions[1],'&' )
   x.idents[0:(n_elements(s)-1)]= s
   s= str_sep( widgetData.soptions[2],'&' )
   x.idl_program[0:(n_elements(s)-1)]= s
   x.filename= widgetData.soptions[5]
   widget_control, widgetData.id_hd_scratch_pad, set_value=x  
   
; As this is a function that will return all changes made by the
; user, the xmanager has to be called with the keyword MODAL. If we
; wouldn't specify /MODAL, no changes would be reportet but the 
; data contained in aPlotInfo would be returned.
   xmanager, 'hd_scratch_pad_panel', panel_base, /MODAL

; the returned data consists of the standard-data inherited from
; PAPCO_PANEL.PRO and your new data - e.g. the typeVector-tag.
   returnData={ typeVector:widgetData.typeVector, $
                soptions:widgetData.soptions, $
                ioptions:widgetData.ioptions, $
                options:widgetData.options }
   
   additionalRData=PAPCO_panel_ReturnData(widgetData)

   return, create_struct(ReturnData, additionalRData)
END





