pro hyd_access_set_header, header
  COMMON hyd_access_panel_DATA, widgetData
  widget_control, widgetData.label_id, set_value= header.label
  widget_control, widgetData.units_id, set_value= header.units
end

;***************************************************************************
;* 
;* PROCEDURE:     
;*      PRO hyd_access_panel_event, event
;* 
;* DESCRIPTION:  
;*	This processes events from the XMANAGER.
;*	As this example does not extend the basic functionality of plot-
;*	editors, it directly calls the default-handler, PAPCO_PANEL_Event
;*
;* INPUTS:       
;*	event		an XManager event
;*			
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:       
;*     written august 1995, Andreas Keese
;*
;***************************************************************************
PRO hyd_access_panel_event, event, uvalue=uval
   COMMON hyd_access_panel_DATA, widgetData
   common rp_hyd_access_common, fv_out_header, fv_ele, fv_ion

   if n_elements( uval ) eq 0 then begin
       WIDGET_CONTROL,GET_UVALUE=uval, event.id
   endif

   if n_elements( uval ) eq 0 then begin
   endif else begin
       s_uval= str_sep( uval, ':' )
       if s_uval(0) eq 'group' then begin
           group= s_uval(1)
           hd_table, table, /get_table
           if group eq 'ALL' then r=lindgen(n_elements(table)) else $
             r= where( s_uval(1) eq table(*).group ) 
           s= sort( table(r).id )
           table= table(r(s))
           idents= table(*).id
           widget_control, widgetdata.ident_list_id, set_value=idents
           widgetData.ident_list= idents
           widgetData.table= table
           r= where( idents eq widgetData.filename )
           index= r(0)
           if index ne -1 then $
             widget_control, widgetdata.ident_list_id, set_list_select=index
       endif else if uval eq 'ident_list' then begin
           if n_elements( event ) ne 0 then begin
               index= event.index
           endif else begin 
               index=(where( widgetData.filename eq widgetData.ident_list ))(0)
               if index eq -1 then index=0
                                ; pseudo event does nothing
           endelse
           ident= widgetData.ident_list(index)           
           widgetData.filename= ident
           if index ne -1 then begin
               if widgetdata.table(index).size(0) eq 2 then begin
                   widget_control, widgetdata.component_base, sensitive=1
               endif else begin
                   widget_control, widgetdata.component_base, sensitive=0
               endelse
           endif
;   print to info base
           if index ne -1 then begin
               info_text=[ 'id: '+widgetdata.table(index).id ]
               if widgetdata.table(index).frame ne '' then begin
                   info_text=[ info_text, 'frame: ' + $
                               widgetdata.table(index).frame ] 
               endif
               info_text= [ info_text, $
                            'units: '+widgetdata.table(index).units, $
                            'description: ', $
                            widgetdata.table(index).title ]               
               widget_control, widgetdata.info_id, set_value=info_text
               label= widgetData.table(index).label
               if strmid(label,0,1) eq '>' then $
                 label=strtrim(strmid(label,1,256),2)               

               wset, widgetData.label_draw_widx
               erase, get_color_index('grey')
               
               xyouts, 60/2, 40/2-!d.y_ch_size/2, /device, align=0.5, $
                 label, $
                 charsize=1.5, color=get_color_index('black'), width=w
               if w gt 1.0 then begin
                   erase, get_color_index('grey')
                   xyouts, 60/2, 40/2-!d.y_ch_size/4, /device, align=0.5, $
                     label, $
                     charsize=.75, color=get_color_index('black'), width=w
               endif

               wset, widgetData.units_draw_widx
               erase, get_color_index('grey')
               xyouts, 60/2, 40/2-!d.y_ch_size/2, /device, align=0.5, $
                 widgetData.table(index).units, $
                 charsize=1.5, color=get_color_index('black'), width=w
               if w gt 1.0 then begin
                   erase, get_color_index('grey')
                   xyouts, 60/2, 40/2-!d.y_ch_size/4, /device, align=0.5, $
                     widgetData.table(index).units, $
                     charsize=.75, color=get_color_index('black'), width=w
               endif
           endif
;   populate units widget           
           if index ne -1 then begin
               units_option= $
                 hd_convert_units( widgetdata.table(index).units, $
                                   /get_defined_conversions )
               if n_elements( units_option ) gt 10 then units_option=units_option(0:9)
;               widget_control, widgetData.units_list, $
;                 set_value=units_option
               index= $
                 ( where( widgetdata.table(index).units eq units_option ) )(0)
;               widget_control, widgetData.units_list, set_droplist_select=index
;               widgetData.units_option= units_option
           endif
;       endif else if uval eq 'units' then begin
;           units= widgetData.units_option( event.index )
;           if hydra_new_papco( vers=vers ) and vers ge 9.0 then begin
;               widgetData.soptions(0)= units
;           endif
       endif else if uval eq 'info_edit' then begin
           widget_control, widgetdata.info_id, get_value=info_text
           edit_base= widget_base(title='Request Edits', /column)
           instruct= ['Please fill in missing units, frames, ',$
                      'and descriptions or correct mistakes. ',$
                      'Editted text will be emailed to ',$
                      'hyd_access curator.']
           for i=0,n_elements(instruct)-1 do $
             x= widget_label( edit_base, value=instruct(i), /align_left )
           edit_text= widget_text(edit_base,value=info_text, /edit, xsize=60, ysize=9 )
           edit_buttons= widget_base( edit_base, /row )
           edit_update= widget_button(edit_buttons,value='Send Edits to Curator')
           edit_cancel= widget_button(edit_buttons,value='Cancel')
           if !version.release ge 5.0 then begin
               widget_control, edit_base, /realize, /modal
           endif else begin
               widget_control, edit_base, /realize
           endelse
           widget_center, edit_base
           w= widget_event()
           if w.id eq edit_update then begin
               widget_control, edit_text, get_value=info_text
               openw, unit, '/tmp/papco_scratch_pad_access_edits.txt~', /get_lun
               printf, unit, '----- hyd_access papco module information change requested -----'
               for i=0,n_elements(info_text)-1 do $
                 printf, unit, info_text(i)
               printf, unit, '----------------------------------------------------------------'
               close, unit
               free_lun, unit
               curator='jbf@space-theory.physics.uiowa.edu'
               mail_cmd= 'cat /tmp/papco_scratch_pad_access_edits.txt~ | ' + $
                 'mailx -s "hyd_access information change request" ' + $
                 curator
               spawn, mail_cmd
               spawn, 'rm /tmp/papco_scratch_pad_access_edits.txt~'
               report= ['','Email message sent to ',curator ]
               widget_control, edit_text, set_value=report
               wait, 2
           endif           
           widget_control, edit_base, /destroy
       endif else if uval eq 'component' then begin
           widgetData.typevector(0)= event.value
       endif else if uval eq 'coordinate_frame' then begin
           widgetData.typevector(3)= event.value
       endif else if uval eq 'phi_center' then begin
           widgetData.typevector(2)= event.value
       endif else if uval eq 'pb_reload' then begin
           hyd_access, /reset
       endif else if s_uval(0) eq 'hp_kw' then begin
           widgetData.ioptions(15)= $
             event.value.poly_above_ref * 2 + event.value.poly_below_ref
       endif else begin
           widgetData=PAPCO_panel_Event(event, widgetData)
       ENDELSE
   endelse
END


;***************************************************************************
;***************************************************************************
;* 
;* FILE:
;*    $PAPCO_PATH/hyd_access_panel.pro
;* 
;*    This file belongs to the PAPCO-project. See $PAPCO_PATH/papco.pro for
;*    further information.
;*
;* DESCRIPTION: 
;*    This file contains a demonstration on how to implement a PAPCO-
;*    panel-editor. It makes use of all the features provided by 
;*    $PAPCO_PATH/papco_panel.pro
;*    It constructs an editor for a very simple PAPCO-plot, that has only
;*    default-functionality.
;*
;* FILES YOU MAY WANT TO READ
;*       $PAPCO_PATH/papco_conventions.text     which conventions were used
;*						when developing ?
;*	 $PAPCO_PATH/papco_variables.text	what structures and global
;*						variables are used by 
;*						which file ?
;*
;* USED MODULES:
;*    For a list of files, that are needed for PAPCO to run, read the 
;*    file addpapco_init.PRO in $PAPCO_MODULES
;*
;* COMMON-BLOCKS:
;*    hyd_access_panel_DATA	contains the window-information
;*
;* STRUCTURES:
;*    This module creates one concrete structure, that inherits from the 
;*    PAPCO_PANEL_EDITOR-structure (see $PAPCO_PATH/papco_panel.pro for a
;*    description). 
;*       {hyd_access_panel_DATA, 
;*	     ; imagine the PAPCO_PANEL_EDITOR-structure was inserted...
;*	      
;*    For a more complete description see $PAPCO_PATH/papco_variables.text
;*
;* OVERVIEW:
;*    This function creates the editor-window:
;*       FUNCTION  hyd_access_panel, aPlotInfo, GROUP=group, ACTION=ACTION
;*    You might try this:
;*	 print, hyd_access_panel(PAPCO_getPlotInfoStruct())
;*       which calls up the window.
;*
;* MODIFICATION HISTORY:       
;*     august 1995, written by A.Keese
;*     December 1995, modified by R.Friedel at Goddard
;*     
;***************************************************************************



;***************************************************************************

;***************************************************************************
;* 
;* FUNCTION:     
;*      FUNCTION  hyd_access_panel, aPlotInfo, GROUP=group, ACTION=ACTION
;* 
;* DESCRIPTION:  
;*	Open an editor for a panelplot.
;*	Its window is constructed using the methods defined in the file
;*	$PAPCO_PATH/papco_panel.pro
;*	When the user presses the 'Done'- or the 'Cancel'-Button, the values 
;*	changed by the event-methods of papco_panel.pro are returned.
;*	The returned value is a structure containing those values and a flag,	
;*	'canceled', which the caller may read out to check, whether the 
;*	window was closed using the 'Cancel' or the 'Done'-Button.
;*
;* INPUTS:       
;*	aPlotInfo	a structure of the PAPCO_PLOTINFO-type
;*			this structure is edited in the window.
;*     
;* KEYWORDS:
;* 	GROUP		a WIDGET_BASE
;*			when specified, this is used as GROUP_LEADER
;*	ACTION		a string
;*			when specified, the 'Done'-Button is labeled with it
;*		        if not specified, the 'Done'-Button is labeled 'Done'
;*
;* OUTPUT:	 
;*      a default-structure of type PAPCO_PANEL_EDITOR_RETURN. Though this
;*	type is nowhere defined, I like to think of it as virtually existing
;*	data-type. 
;*	All the functions in $PAPCO_PATH/papco.pro that edit plots or add new
;*	ones, expect the opened editor-windows to return a structure containing
;*	at last some fields. Those fields might make up a structure, but as no
;*	program defines the structure-type PAPCO_PANEL_EDITOR_RETURN, this 
;*	poor structure is not alive but only virtual.
;*	The return-values of plot-editors have to expand this structure - I 
;*	like to think, that they inherit from that structure - and contain at
;*	least those fields:
;*   		{$
;*			canceled:1, $
;*	    		panelHeight:1, $
;*	    		channel:0, $
;*	    		typeVector:[0,0,0,0], $ 
;*	    		manualYScaling:0 $
;*	    		yScaleMin:LONG(1), $
;*	    		yScaleMax:LONG(1), $
;*	    		panelKind:'some string'}
;*
;*      Additionally, some Panel-editors may return these fields in
;*      structure:
;*               {$
;*		        color:1, $
;*			plotStyle:1}
;*			
;*      For an enhanced description read $PAPCO_PATH/papco_variables.text
;*
;* CALLING SEQUENCE:
;*	aPlotInfoStruct=PAPCO_getPlotInfoStruct()
;*
;* MODIFICATION HISTORY:       
;*     written august 1995, Andreas Keese
;*
;***************************************************************************

FUNCTION  hyd_access_panel, aPlotInfo, GROUP=group, ACTION=ACTION
   COMMON hyd_access_panel_DATA, widgetData

; if GROUP is not specified, the group-leader will be the desktop
   IF NOT KEYWORD_SET(GROUP) THEN GROUP=0

; set the label for the action-button
   IF NOT KEYWORD_SET(ACTION) THEN ACTION='Done'

; the routines used by papco_panel.pro define tags for a structure. Those
; tags will be stored in the structure 'additionalWData'. When you realize the
; window, you have to add your own window-specific data to that structure 
; and afterwards assign it to widgetData.
   additionalWData={canceled:1}

;--- create the base-window ----------------------------------------------------
   panel_base=WIDGET_BASE(title=aPlotInfo.panelKind,$
	 column=1, $
	 GROUP_LEADER=group)

;--- the first part of the window will consist in the widgets ------------------
;    that control the height of that plot
   widgets=PAPCO_panel_AddHeightWidgets(panel_base, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

;   group selector
   hd_table, table, /get_table
   groups1= table(*).group
   s= sort( groups1 )
   u= uniq( groups1(s) )
   groups= [ 'ALL', groups1( s(u) ) ]
   group_base= widget_base( panel_base, column=5, /exclusive, /frame )
   for i= 0,n_elements(groups)-1 do begin
       x= widget_button( group_base, value=groups(i), $
                         uvalue='group:'+groups(i), /no_release )
       if groups(i) eq 'ALL' then widget_control, x, set_button=1
   endfor

;   idents, units, and text bases
   id_units_base= widget_base( panel_base, /row )

;   identifier selection
   idents=strarr(n_elements(table))
   w= widget_list( id_units_base, value=idents, uval='ident_list', $
                   xsize=30, ysize=15 )
   additionalWData= create_struct( { ident_list:idents, $
                                     table:table, $
                                     filename:aPlotInfo.filename, $
                                     ident_list_id:w }, $
                                   additionalWData )
   
   comp_info_base= widget_base( id_units_base, /column )

;   component selection
   comp_units_base= widget_base( comp_info_base, /column )
   component_base= widget_base( comp_units_base, /frame, /column )
   additionalWData= create_struct( { component_base:component_base }, $
                                   additionalWData )
   x= cw_bgroup( component_base, [ 'x', 'y', 'z', $
                                   'magnitude', 'theta', 'phi' ], $
                 /exclusive, row=2, ids=ids, uvalue='component' )
   if aPlotInfo.typevector(0) gt 5 then aPlotInfo.typevector(0)=0
   widget_control, ids(aPlotInfo.typevector(0)), set_button=1
   x= cw_field( component_base, title='phi_center, deg: ', $
                value=aPlotInfo.typeVector(2), /integer, xsize=4, $
                uvalue='phi_center', /return_events )
   x= widget_base( component_base, /exclusive )
   x= cw_bgroup( component_base, [ 'no rotation', 'payload to GSM' ], $
                 /exclusive, /row, ids=ids, uvalue='coordinate_frame' )   
   if aPlotInfo.typeVector(3) gt 2 then aPlotInfo.typeVector(3)=0
   widget_control, ids(aPlotInfo.typevector(3)), set_button=1

;   units base   
;   units_base= widget_base( comp_units_base, /frame, /row )
;   x= widget_label( units_base, value='Units: ' )
;   units_list= widget_droplist( units_base, value=[' '], uval='units' )   
;   widget_control, units_list, sensitive=0
;   additionalWData= create_struct( additionalWData, { units_list:units_list, $
;                                                      units_option:strarr(10) } )

;   info base
   info_base_parent= widget_base( comp_info_base, /row, /frame )
   draw_base= widget_base( info_base_parent, /column )
   x= widget_label( draw_base, value='Label:' )
   label_draw_id= widget_draw( draw_base, xsize=60, ysize=40 )   
   x= widget_label( draw_base, value='Units:' )
   units_draw_id= widget_draw( draw_base, xsize=60, ysize=40 )   
   info_base= widget_base( info_base_parent, /column )
   info_id= widget_text( info_base, xsize=30, ysize=9, /scroll )
   edit_id= widget_button( info_base, value='Request Edits', uvalue='info_edit' ) 

   if !version.os_family ne 'unix' then widget_control, edit_id, sensitive=0
   additionalWData= create_struct( {info_id:info_id}, additionalWData )

;   color highlighting widget (hydra plot keywords)
   w= hydra_plot_widget( panel_base, /frame, uvalue='hp_kw' )
   value={ reference:aPlotInfo.options(15), $
           poly_above_ref:aPlotInfo.ioptions(15) and 1, $
           ploy_below_ref:aPlotInfo.ioptions(15) and 2 / 2 }   
   widget_control, w, set_value=value
   
;--- add the widgets for choosing the plot-style -------------------------------
   widgets=PAPCO_panel_add_PlotStyleButtons(panel_base, aPlotInfo, 0)
   additionalWData=create_struct(widgets, additionalWData)
   
;    yrange widget
   widgets=PAPCO_PANEL_AddYScale_Widgets(panel_base, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

;--- finally, the Actionbuttons (help, cancel, done) are added to the ---------
;    editor window.
   widgets=PAPCO_panel_AddActionButtons(panel_base, Action, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

;--- now, create the structure that keeps the panel-window data. You
;    always need to specify the help-file, and your structure must
;    always contain the 'additionalWData'.
   if hydra_new_papco(vers=vers) and vers ge 9.0 then begin
       thisWidgetsData={ helpfile:'hyd_access_panel.help', $
                         typevector:aPlotInfo.typeVector, $
                         swwitch:aPlotInfo.swwitch }
   endif else begin
       thisWidgetsData={ helpfile:'hyd_access_panel.help', $
                         typevector:aPlotInfo.typeVector }
   endelse
   
   widgetData=PAPCO_PANEL_CreateWidgetData(thisWidgetsData, additionalWData)

;--- realize the window
   PAPCO_Panel_Realize, panel_base, widgetData, $
     xoffset=300, yoffset=0

   widget_control, label_draw_id, get_value=x
   widgetData= create_struct( { label_draw_widx:x }, widgetData )
   widget_control, units_draw_id, get_value=x
   widgetData= create_struct( { units_draw_widx:x }, widgetData )
   
   wset, widgetData.label_draw_widx
   tv, randomu(seed,60,40)*!d.n_colors

   wset, widgetData.units_draw_widx
   tv, randomu(seed,60,40)*!d.n_colors

   hyd_access_panel_event, uval='group:ALL'
   hyd_access_panel_event, uval='ident_list'

; As this is a function that will return all changes made by the
; user, the xmanager has to be called with the keyword MODAL. If we
; wouldn't specify /MODAL, no changes would be reportet but the 
; data contained in aPlotInfo would be returned.
   xmanager, 'hyd_access_panel', panel_base, /MODAL

; the returned data consists of the standard-data inherited from
; PAPCO_PANEL.PRO and your new data - e.g. the typeVector-tag.
   returnData={ typeVector:widgetData.typeVector, $
                swwitch:widgetData.swwitch }
   
   additionalRData=PAPCO_panel_ReturnData(widgetData)

   return, create_struct(ReturnData, additionalRData)
END





