pro hydra_product_info, base, _extra=e

;   process keywords and collect information resources
    if n_elements( base ) eq 0 then base=0
    unix= !version.os_family eq 'unix'

;   form info array
    info=['']

    keywords= tag_names( e )
    for i= 0, n_elements( keywords ) -1 do begin
        kw= keywords(i)
        r= execute( 'kw_value= e.'+kw )
        case 1 of
            strmid(kw,0,1) eq 'M': begin
                info=[info,kw_value] 
            end
            strmid(kw,0,1) eq 'F': begin
                file= kw_value
                f= findfile( file )
                if f(0) eq '' then begin
                    file_date_str= "Can't find file."
                endif else begin
                    if unix then begin
                        spawn, 'ls -l '+file, result
                        file_date_str= strmid(result,41,12)
                    endif else begin
                        file_date_str= 'Not Available'
                    endelse
                endelse
                info= [ info,file+': '+file_date_str ]
            end
            else: begin
                message, 'keyword not recognised: '+kw, /cont
            end
        endcase
    endfor

;   display info array
    r= widget_message( /info, info, dialog_parent=base )
end



