;***************************************************************************
;* 
;* PROCEDURE:     
;*      PRO scratch_mvc_panel_event, event
;* 
;* DESCRIPTION:  
;*	This processes events from the XMANAGER.
;*	As this example does not extend the basic functionality of plot-
;*	editors, it directly calls the default-handler, PAPCO_PANEL_Event
;*
;* INPUTS:       
;*	event		an XManager event
;*			
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:       
;*     november 1995, written by R. Friedel at Goddard
;*
;***************************************************************************
PRO scratch_mvc_panel_event, event
   COMMON scratch_mvc_panel_DATA, widgetData
   WIDGET_CONTROL,GET_UVALUE=uval, event.id

   s= str_sep( uval,':' )
   ev_action= s(0)
   if n_elements(s) gt 1 then ev_arg= long(s(1))

   if ev_action eq 'hp_kw' then begin
       widgetData.typeVector(1)= event.value.codei4
       print, widgetData.typeVector 
   endif else IF ev_action EQ 'type' THEN BEGIN
       widgetData.typeVector(0)= ev_arg
   endif else if ev_action eq 'reload' then begin
       loaded=0L                ; causes all to be reloaded.
       widget_control, event.id, sensitive=0
   ENDIF else if ev_action eq 'color_enhancements' then begin
       widgetData.typeVector(1)= $
         ( widgetData.typeVector(1) and (not long(1) )) or ev_arg
       widget_control, event.id, set_button= ev_arg, $
         set_uvalue= 'color_enhancements:'+strtrim(1-ev_arg)
   endif else begin
       widgetData=PAPCO_panel_Event(event, widgetData)
   ENDELSE
   
END

;***************************************************************************
;***************************************************************************
;* 
;* FILE:
;*    $PAPCO_modules/scratch_mvc_panel.pro
;* 
;*    This file belongs to the PAPCO-project. See $PAPCO_PATH/papco.pro for
;*    further information.
;*
;* DESCRIPTION: 
;*    This file contains a demonstration on how to implement a PAPCO-
;*    panel-editor. It makes use of all the features provided by 
;*    $PAPCO_PATH/papco_panel.pro
;*    It constructs an editor for a very simple PAPCO-plot, that has only
;*    default-functionality.
;*
;* FILES YOU MAY WANT TO READ
;*       $PAPCO_PATH/papco_conventions.text     which conventions were used
;*						when developing ?
;*	 $PAPCO_PATH/papco_variables.text	what structures and global
;*						variables are used by 
;*						which file ?
;*
;* USED MODULES:
;*    For a list of files, that are needed for PAPCO to run, read the 
;*    file WIDINIT.PRO
;*
;* COMMON-BLOCKS:
;*    scratch_mvc_panel_DATA	contains the window-information
;*
;* STRUCTURES:
;*    This module creates one concrete structure, that inherits from the 
;*    PAPCO_PANEL_EDITOR-structure (see $PAPCO_PATH/papco_panel.pro for a
;*    description). 
;*       {scratch_mvc_panel_DATA, 
;*	     ; imagine the PAPCO_PANEL_EDITOR-structure was inserted...
;*	      
;*    For a more complete description see $PAPCO_PATH/papco_variables.text
;*
;* OVERVIEW:
;*    This function creates the editor-window:
;*       FUNCTION  scratch_mvc_panel, aPlotInfo, GROUP=group, ACTION=ACTION
;*    You might try this:
;*	 print, scratch_mvc_panel(PAPCO_getPlotInfoStruct())
;*
;* MODIFICATION HISTORY:       
;*     november 1995, written by R. Friedel at Goddard
;***************************************************************************
;***************************************************************************


;***************************************************************************
;* 
;* FUNCTION:     
;*      FUNCTION  scratch_mvc_panel, aPlotInfo, GROUP=group, ACTION=ACTION
;* 
;* DESCRIPTION:  
;*	Open an editor for a panelplot.
;*	Its window is constructed using the methods defined in the file
;*	$PAPCO_PATH/papco_panel.pro
;*	When the user presses the 'Done'- or the 'Cancel'-Button, the values 
;*	changed by the event-methods of papco_panel.pro are returned.
;*	The returned value is a structure containing those values and a flag,	
;*	'canceled', which the caller may read out to check, whether the 
;*	window was closed using the 'Cancel' or the 'Done'-Button.
;*
;* INPUTS:       
;*	aPlotInfo	a structure of the PAPCO_PLOTINFO-type
;*			this structure is edited in the window.
;*     
;* KEYWORDS:
;* 	GROUP		a WIDGET_BASE
;*			when specified, this is used as GROUP_LEADER
;*	ACTION		a string
;*			when specified, the 'Done'-Button is labeled with it
;*		        if not specified, the 'Done'-Button is labeled 'Done'
;*
;* OUTPUT:	 
;*      a default-structure of type PAPCO_PANEL_EDITOR_RETURN. Though this
;*	type is nowhere defined, I like to think of it as virtually existing
;*	data-type. 
;*	All the functions in $PAPCO_PATH/papco.pro that edit plots or add new
;*	ones, expect the opened editor-windows to return a structure containing
;*	at last some fields. Those fields might make up a structure, but as no
;*	program defines the structure-type PAPCO_PANEL_EDITOR_RETURN, this 
;*	poor structure is not alive but only virtual.
;*	The return-values of plot-editors have to expand this structure - I 
;*	like to think, that they inherit from that structure - and contain at
;*	least those fields:
;*   		{$
;*			canceled:1, $
;*	    		panelHeight:1, $
;*	    		channel:0, $
;*	    		typeVector:[0,0,0,0], $ 
;*	    		manualYScaling:0 $
;*	    		yScaleMin:LONG(1), $
;*	    		yScaleMax:LONG(1), $
;*	    		panelKind:'some string'}
;*
;*      Additionally, some Panel-editors may return these fields in
;*      structure:
;*               {$
;*		        color:1, $
;*			plotStyle:1}
;*			
;*      For an enhanced description read $PAPCO_PATH/papco_variables.text
;*
;* CALLING SEQUENCE:
;*	aPlotInfoStruct=PAPCO_getPlotInfoStruct()
;*
;* MODIFICATION HISTORY:       
;*     november 1995, written by R. Friedel at Goddard
;*
;***************************************************************************
FUNCTION  scratch_mvc_panel, aPlotInfo, GROUP=group, ACTION=ACTION
   COMMON scratch_mvc_panel_DATA, widgetData

; if GROUP is not specified, the group-leader will be the desktop
   IF NOT KEYWORD_SET(GROUP) THEN GROUP=0

; set the label for the action-button
   IF NOT KEYWORD_SET(ACTION) THEN ACTION='Done'

; the routines used by papco_panel.pro define tags for a structure. Those
; tags will be stored in the structure 'additionalWData'. When you realize the
; window, you have to add your own window-specific data to that structure 
; and afterwards assign it to widgetData.
   additionalWData={canceled:1}

;--- create the base-window ----------------------------------------------------
   panel_base=WIDGET_BASE(title=aPlotInfo.panelKind,$
	 column=1, $
	 GROUP_LEADER=group)

;--- the first part of the window will consist in the widgets-------------
;    that control the height of that plot
   widgets=PAPCO_panel_AddHeightWidgets(panel_base, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

; ### typeVector allocation ###
;   tv(0)        is the plot type
;   tv(1) and 1  is color enhancement 

; --- Choose plot species---------------------------------------------------
   type_base = WIDGET_BASE(panel_base, /FRAME, COLUMN=5,/EXCLUSIVE)

   common scratch_mvc_control, types
      scratch_pad_define_types

   for i=0,n_elements(types(0,*))-1 do begin
       w= widget_button( type_base, value=types(0,i), $
                         uvalue='type:'+strtrim(i,2) )
       if aPlotInfo.typeVector(0) eq i then $
         widget_control, w, set_button=1
   endfor

; --- hydra_plot keywords --------------------------------------------------
   w= hydra_plot_widget( panel_base, /frame, uvalue='hp_kw' )
   widget_control, w, set_value=aPlotInfo.typeVector(1)

; --- hydra_plot keywords --------------------------------------------------
;   base= widget_base( panel_base, /frame, /row, /nonexclusive )

;   w= widget_button( base, value='Color Enhancements', uvalue='color_enhancements:1' )
;   if ( aPlotInfo.typeVector(1) and 1 ) eq 1 then begin
;       widget_control, w, /set_button, set_uvalue='color_enhancements:0'
;   endif

;--- add the widgets for choosing the plot-style -------------------------------
   widgets=PAPCO_panel_add_PlotStyleButtons(panel_base, aPlotInfo, 0)

   additionalWData=create_struct(widgets, additionalWData)

;--- now, add the widgets for choosing the y-axis-ranges -----------------------
   widgets=PAPCO_PANEL_AddYScale_Widgets(panel_base, aPlotInfo)
   additionalWData=create_struct(widgets, additionalWData)

; --- Reload button -----------------
   type_base=WIDGET_BASE(panel_base, /FRAME, /row, /nonexclusive )
   
   spb= widget_button( type_base, $
                       value='Reload Data', $
                       uvalue='reload:0' )

   
;--- finally, the Actionbuttons (help, cancel, done) are added to the ---------
;    editor window.
   widgets=PAPCO_panel_AddActionButtons(panel_base, Action, aPlotInfo, /config)
   additionalWData=create_struct(widgets, additionalWData)

;--- now, create the structure that keeps the panel-window data. You
;    always need to specify the help-file, and your structure must
;    always contain the 'additionalWData'.
   if hydra_new_papco(vers=vers) and vers ge 9.0 then begin   
       thisWidgetsData={helpfile:'scratch_mvc_panel.help', $
                        typeVector:aPlotInfo.typeVector, $
                        swwitch:aPlotInfo.swwitch, $
                        spb_type:0 }
   endif else begin
       thisWidgetsData={helpfile:'scratch_mvc_panel.help', $
                        typeVector:aPlotInfo.typeVector, $
                        spb_type:0 }
   endelse
   widgetData=PAPCO_PANEL_CreateWidgetData(thisWidgetsData, additionalWData)

;--- realize the window
   PAPCO_Panel_Realize, panel_base, widgetData
   widget_control, panel_base, yoffset=0

; As this is a function that will return all changes made by the
; user, the xmanager has to be called with the keyword MODAL. If we
; wouldn't specify /MODAL, no changes would be reportet but the 
; data contained in aPlotInfo would be returned.
   xmanager, 'scratch_mvc_panel', panel_base, /MODAL


; the returned data consists of the standard-data inherited from
; PAPCO_PANEL.PRO and your new data - e.g. the typeVector-tag.
   if hydra_new_papco( vers=vers ) and vers ge 9.0 then begin
       returnData={ typeVector:widgetdata.typeVector $
                  }
   endif else begin
       returnData={ typeVector:widgetdata.typeVector, $
                    swwitch:widgetData.swwitch }
   endelse
   additionalRData=PAPCO_panel_ReturnData(widgetData)

   return, create_struct(ReturnData, additionalRData)
END





   




















