pro p_event_marks, marks, type, color, delta, _extra=e

  ycrange=!y.crange
  if !y.type then ycrange10=10^!y.crange else ycrange10=ycrange
  xcrange=!x.crange
  if !x.type then xcrange10=10^!x.crange else xcrange10=xcrange

  for i=0,n_elements(marks)-1 do begin
      colori= color( i < (n_elements(i)-1) )
      case type of
          'x_arrows': begin
              dx= (xcrange(1)-xcrange(0))/30
              dy= dx * (ycrange(1)-ycrange(0))/(xcrange(1)-xcrange(0))
              x= marks(i)+[0,-.5,.5,0]*dx
              y= ycrange(0)-[0,1,1,0]*dy
              polyfill, x, y, color=colori, _extra=e
              plots, x, y, color=colori, _extra=e
              x= marks(i)+[0,-.5,.5,0]*dx
              y= ycrange(1)+[0,1,1,0]*dy
              polyfill, x, y, color=colori, _extra=e
              plots, x, y, color=colori, _extra=e
          end
          'x_inside_arrows': begin
              dx= (xcrange(1)-xcrange(0))/30
              dy= dx * (ycrange(1)-ycrange(0))/(xcrange(1)-xcrange(0))
              x= marks(i)+[0,-.5,.5,0]*dx
              y= ycrange(0)+[1,0,0,1]*dy
              polyfill, x, y, color=colori
              plots, x, y, color=colori, _extra=e
              x= marks(i)+[0,-.5,.5,0]*dx
              y= ycrange(1)-[1,0,0,1]*dy
              polyfill, x, y, color=colori
              plots, x, y, color=colori, _extra=e
          end
          'x_inside_interval': begin
              dx= (xcrange(1)-xcrange(0))/30
              dy= dx * (ycrange(1)-ycrange(0))/(xcrange(1)-xcrange(0))
              dx= delta(i)
              x= marks(i)+[0,0,1,1]*dx
              y= ycrange(0)+[1,0,0,1]*dy + dy/2
              plots, x, y, color=colori, _extra=e
              y= ycrange(1)-[1,0,0,1]*dy - dy/2
              plots, x, y, color=colori, _extra=e
          end
          'x_outside_interval': begin
              dx= (xcrange(1)-xcrange(0))/30
              dy= dx * (ycrange(1)-ycrange(0))/(xcrange(1)-xcrange(0))
              dx= delta(i)
              x= marks(i)+[0,0,1,1]*dx
              y= ycrange(0)-[1,0,0,1]*dy - dy/2
              plots, x, y, color=colori, _extra=e
              y= ycrange(1)+[1,0,0,1]*dy + dy/2
              plots, x, y, color=colori, _extra=e
          end
          'x_hollow_box': begin
              dx= (xcrange(1)-xcrange(0))/30
              dy= dx * (ycrange(1)-ycrange(0))/(xcrange(1)-xcrange(0))
              dx= delta(i)
              x= marks(i)+[0,0,1,1,0]*dx
              y= ycrange([1,0,0,1,1])+[-1,1,1,-1,-1]*dy/2
              plots, x, y, color=colori, _extra=e
          end
          'x_filled_box': begin
              dx= (xcrange(1)-xcrange(0))/30
              dy= dx * (ycrange(1)-ycrange(0))/(xcrange(1)-xcrange(0))
              dx= delta(i)
              x= marks(i)+[0,0,1,1,0]*dx
              y= ycrange([1,0,0,1,1])+[-1,1,1,-1,-1]*dy/2
              polyfill, x, y, color=colori
          end
          'x_bar': begin
              oplot, [1,1]*marks(i), ycrange10, $
                color=colori, _extra=e
          end          
      endcase
  endfor
end

