pro p_hd_scratch_pad, panel, $
                      vars=vars, idents=idents, idl_program=idl_program, $
                      label=label, $
                      units=units, $
                      component=component, $
                      xrange=xrange, $
                      hydra_plot_kw=hp_kw, $
                      OVERPLOT=OVERPLOT, $
                      PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
                      _EXTRA=extra_par, subtable=subtable
  
; The following common blocks are needed:
  
  if n_elements( xrange ) eq 0 then begin
      common time, xut1, xut2
      xrange=[ xut1, xut2 ]
  endif else begin
      xut1= xrange(0)
      xut2= xrange(1)
  endelse
  
@hd_include                     ; get hd_fill

  hd_scratch_pad, gen_time(xrange,/t90), $
    idents, vars, idl_program, $
    timetags, data, error_handled=error_handled

  if error_handled gt 0 then begin
      hyd_err_panel, 'No data returned from hd_scratch_pad.', panel
      return
  endif
  
  if error_handled lt 0 then begin
      x= hydra_message( [ 'Unidentified error occurred in hd_scratch_pad,', $
                          'seek help from an expert' ] )
      hyd_err_panel, 'No data returned from hd_scratch_pad.', panel
      return
  endif

  if n_elements(data) eq 0 then begin
      hyd_err_panel, 'No data returned from hd_scratch_pad.', panel
      return
  endif
  
  if n_elements(timetags) eq 0 then begin      
      hyd_err_panel, 'No timetags returned from hyd_access.', panel
      return
  endif

  hd_insert_fill, timetags, data

  if n_elements( timetags ) eq 0 then begin
      hyd_err_panel, 'No data found in this time range.', panel
      return
  end
  
  hyd_access, timetags, 'time_bin_start_t90', time
  time= time - xut1
  hyd_access, timetags, 'time_bin_width_seconds', dt
  message, 'Done reading data.', /cont
  
  if strmid( label,0,1 ) eq '>' then begin
      title= strtrim( strmid( label,1,120 ) )
  endif else begin
      title= label
  endelse

  time_alias= max(dt)

;  component selection is not supported right now, but it
;   could be.  So we'll leave this code in.
  if n_elements( data(0,*) ) ne 1 then begin
      have_error=0
      framestr=''
      case component of
          3: begin 
              data= hd_magnitude( data ) 
              if have_error then data_error= hd_magnitude( data_error )
              compstr= 'Magnitude' 
              pipe= '!9!!!x'
              if strpos(title,'!r') eq -1 then begin
                  title= pipe + title + pipe
              endif else begin                  
                  title= title+'!n!d magnitude'
              endelse
          end
          4: begin
              mag= hd_magnitude( data )
              theta= acos( data(*,2)/mag )              
              data= temporary( theta ) / !dtor
              if have_error then begin
                  message, 'errors not supported for Theta', /cont
                  have_error=0
              endif
              compstr= 'Theta'
              title= title + '!c' + compstr + ' ' + framestr
          end
          5: begin
              data= hd_atan2( data(*,1), data(*,0), center=phi_center ) / !dtor
              if have_error then begin
                  message, 'errors not supported for Phi', /cont
                  have_error=0
              endif
              compstr= 'Phi'
              title= title + '!c' + compstr + ' ' + framestr
          end
          else: begin
              data= data(*,component)
              if have_error then data_error= data_error(*,component)
              compstr= (['X','Y','Z'])(component)
              title= title + '!n!d ' + compstr + ' ' + framestr + '!n'
          endelse
      endcase
  endif

  oldy=!y
  oldx=!x
  
  goodticks, xtickv, xminor
  xticks=n_elements(xtickv)-1
  dxut= xut2-xut1

; set duplex font if big_gif is device ; duplex roman
   if !d.name eq 'Z' then font='!5' else font=getenv('hydra_font')

; the plot calls normally use the arrays t90 for the time axis and yray (ymat
; for color plots) for the y or z axis.
   dxut= xut2-xut1

   r= where( time+dt ge 0 and time-dt le dxut )
   
   if r(0) ne -1 then begin
       y_kw= hydra_ytick_parm( data(r), panel=panel, fill=hd_fill )
   endif else begin
       y_kw= hydra_ytick_parm( data, panel=panel, fill=hd_fill )
   endelse       
   
; set up extra plot keywords, common ones first
   
   extra_plotPar_common={xrange:[0,dxut], $
                         noerase:1, ticklen:-0.03, xticklen:-0.03, $
                         xtickv:xtickv, xminor:xminor, xticks:xticks, $
                         yticklen:0.010, ytitle:units, $
                         ythick:1.3, xthick:1.3, $
                         min_value:-1e30, max_value:1e30 }
   
   extra_plotPar_common= $
     create_struct( extra_plotPar_common, y_kw )
   
; check if the passed in structure extra_par was set. If not, set color to
; default black; which for the color table used by PAPCO is 1.

   if n_elements(extra_par) EQ 0 then $
     extra_par={color:1}

; add keyword structure set here with the one passed in

   extra_plotPar=create_struct( extra_plotPar_common, extra_par ) 

   axis_plotPar= create_struct( extra_plotPar_common, {color:1} ) 

; extend this structure by those keywords specific to the plot being bottom
; panel or not. You might have to add your own ytickformat, or leave it out
; for default plot

   if panel(0) eq 0 then begin
       xtickformat= 'hydra_timeticks'
   endif else begin
       xtickformat= 'noticks'
   endelse
   
; plot the axis in color=1, and only plot if you're not overplotting
   if not keyword_set(overplot) then begin
       plot,[time],[data], /NODATA, $
         xstyle=5, ystyle=5, $
         xtickformat=xtickformat, $
         _extra= axis_plotPar
       if panel(0) eq 0 then $
         x_side_label,panel,font+'time (UT)!Cdate',XTICKLEN=0.03
   endif
   
; now do the actual data plot
   if n_elements( hp_kw ) then begin
       extra_plotPar1= create_struct( extra_plotPar, hp_kw )
   endif else begin
       extra_plotPar1= extra_plotPar
   endelse

   hydra_plot, [time], [data], dx=dt, $
     _extra=extra_plotPar1, xstyle=5, ystyle=5, $
     overplot= keyword_set( overplot )     

   if not keyword_set(overplot) then begin
       plot,[time],[data], /NODATA, $
         xstyle=1, ystyle=1, $
         xtickformat=xtickformat, $
         _extra= axis_plotPar
   endif

; plot extra x-axis labels (eg. ephemeris) and a x-axis label if required.
; plot in color=1. Example here adds an axis with date information.
; the routine x_side_label puts x-axis label to the right of the axis.
; Use the keyword XTICKLEN if your x-axis ticklengths are not the
; default 0.015

; plot info right of the panel. If you want overplots to have there own label
; you need to add position control for this label using the keyword
; PLOTS_ATTHISPOSITION
  abunchoflfs='!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c'
  lfs= strmid( abunchoflfs, 0, 6*(plots_atthisposition<10) )
  right_side_label,panel,lfs+title, _extra=extra_plotPar


end





