pro p_reconnection_events, panel, type, $
                           xrange=xrange, $
                           OVERPLOT=OVERPLOT, $
                           PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
                           _EXTRA=extra_par, subtable=subtable

  
; catalogue of events May 29, 1996
; three groups RD's, Separatrix, Alfven Waves
; desirable to plot separately or overplot with the colors there

; set duplex font if big_gif is device ; duplex roman
  if !d.name eq 'Z' then font='!5' else font=getenv('hydra_font')
  
; GREEN AND ORANGE REVERSED
  hydra_setcolors, cs
  opcolor= !p.color
  !p.color= 1

   if panel(0) eq 0 then begin
       xtickformat= 'hydra_timeticks'
   endif else begin
       xtickformat= 'noticks'
   endelse

   Sstart=dblarr(1000)
   Sstop=dblarr(1000)
   timestart=dblarr(1000)
   timestop=dblarr(1000)
   boundary_type=intarr(1000)
   boundary_number=intarr(1000)
; type 1 rd, 2 rdlco,3 aw; 4 separatrix
; number separatrix roman numeral or sheet label of RD
   boundary_type=[3,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,2,3,3,2,3,3,3,3,$
                  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,$
                  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,$
                  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,$
                  4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4]
   boundary_number=[0,1,13,1,1,1,1,3,1,3,3,2,3,14,0,1,4,0,0,3,0,0,0,0,$
                    1,1,1,1,1,4,4,1,1,3,1,1,1,1,1,1,1,1,1,3,1,1,1,1,1,4,4,4,1,4,$
                    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,$
                    3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3]
  Stype=strarr(1000)
  Sstart=[040239.,041634.,042035.,043525.,044744.,061726.,061902.,062148.,$
          064135.,064856.,065149.,065856.,070251.,070435.,041035.,041518.,042444.,$
          043729.,044526.,044906.,050526.,050717.,050928.,055031.4,$
          041232.687,041613.475,042444.063,052350.676,061739.876,061835.063,$
          064135.087,064230.275,064529.663,064543.488,064706.288,064720.075,$
          064747.687,064801.476,064938.064,065128.475,065536.876,065713.463,$
          065741.076,065754.864,065822.475,065836.263,065903.876,070258.488,$
          070312.275,040253.087,040306.875,040552.476,040729.063,040810.464,$
          042021.876,043505.064,045015.863,045029.687,052309.275,052323.063,$
          052336.887,052404.464,052418.287,052445.863,052527.264,052554.875,$
          052622.488,055059.064,062338.688,064502.087,064557.276,064611.063,$
          064624.887,064638.675,064829.088,064910.488,064924.276,065033.288,$
          065047.076,065114.687,065209.876,065223.663,065400.287,065523.088,$
          065645.888,070054.287,070407.464,070421.288,070502.688]
  Sstop=[040334.,041810.,042157.,043729.,044839.,061916.,062024.,062243.,$
         064325.,065046.,065325.,070005.,070400.,070557.,041144.,041640.,042539.,$
         043905.,044621.,045151.,050744.,050839.,051037.,055153.,$
         041246.488,041627.276,042457.864,052404.476,061753.676,061848.864,$
         064148.888,064244.076,064543.464,064557.288,064720.088,064733.876,$
         064801.488,064815.276,064951.864,065142.276,065550.676,065727.264,$
         065754.876,065808.664,065836.276,065850.064,065917.676,070312.288,$
         070326.076,040306.888,040320.676,040606.276,040742.864,040824.264,$
         042035.676,043518.864,045029.664,045043.488,052323.076,052336.864,$
         052350.688,052418.264,052432.088,052459.664,052541.064,052608.676,$
         052636.288,055112.864,062352.488,064515.888,064611.076,064624.864,$
         064638.688,064652.476,064842.888,064924.288,064938.076,065047.088,$
         065100.876,065128.488,065223.676,065237.464,065414.088,065536.888,$
         065659.688,070108.088,070421.264,070435.088,070516.488]
  
  Stype=['RD-III','RD-I','RD-I&III','RD-I','RD-I','RD-I','RD-I','RD-III',$
         'RD-I','RD-III','RD-III','RD-II','RD-III',$
         'RD-I&IV','AW-W','RD-I','RD-LCO','AW-W','AW-W','RD-LCO','AW-W','AW-W',$
         'AW-W','AW-W',$
         'S-I','S-I','S-I','S-I','S-I','S-IV','S-IV','S-I','S-I','S-III','S-I',$
         'S-I','S-I','S-I','S-I','S-I','S-I','S-I','S-I','S-III','S-I','S-I',$
         'S-I','S-I','S-I','S-IV','S-IV','S-IV','S-I','S-IV','S-I','S-I','S-I',$
         'S-I','S-I','S-I','S-I','S-I','S-I','S-I','S-I','S-I','S-I','S-I','S-I',$
         'S-I','S-III','S-III','S-III','S-III','S-III','S-III','S-III','S-III',$
         'S-I','S-III','S-III','S-III','S-III','S-III','S-III','S-III','S-III',$
         'S-III','S-III']

  reconnection_events_load_xxc_data, $
    xxc_sstart, xxc_sstop, $
    xxc_heat_sign, $
    xxc_boundary_number
  xxc_stype='S-'+(['','I','II','III','IV'])(xxc_boundary_number)

   file= '/opt/hydra/tmp_data/other_data_sets/19960529_reconnection_events.dat'

   DT=13.787

   NPTS=N_ELEMENTS(SSTART)
   
  FOR JKL=0,NPTS-1 DO BEGIN
      NHRS_START=FIX(SSTART(JKL)/10000.)
      NMIN_START=FIX((SSTART(JKL)-NHRS_start*10000.)/100.)
      sec_start=sstart(jkl)-nhrs_start*10000.-nmin_start*100.
      timestart(jkl)=nhrs_start*3600.+nmin_start*60+sec_start
      
      NHRS_STop=FIX(SSTop(JKL)/10000.)
      NMIN_STop=FIX((SSTop(JKL)-NHRS_stop*10000.)/100.)
      sec_stop=sstop(jkl)-nhrs_stop*10000.-nmin_stop*100.
      timestop(jkl)=nhrs_stop*3600.+nmin_stop*60+sec_stop

      M=FIX((timeSTOP(JKL)-timeSTART(JKL)+.1)/DT)
      timeSTOPNEW = timeSTART(JKL)+M*DT
      timestop(jkl)=timestopnew
  ENDFOR
; at this point events are in timestart, timestop, stype

;  insert new xxc_data
  r= where( boundary_type ne 4 )
  stype= [ stype(r), xxc_stype ]
  timestart= [ timestart(r), xxc_sstart ]
  timestop= [ timestop(r), xxc_sstop ]
  boundary_number= [ boundary_number(r), xxc_boundary_number ]  
  boundary_type= [ boundary_type(r), make_array( value=4, size=size(xxc_stype) ) ]

  replace_new=panel(0)
  if replace_new then begin
      read_reconnection_events, file, rd, sep, null
      timestart= [ rd.starttime*3600, sep.starttime*3600 ]
      timestop= [ rd.endtime*3600, sep.endtime*3600 ]
      boundary_type= [ 1+rd.starttime*0., 4*0*sep.endtime ]
      stype= [ rd.label, sep.label ]
  endif

  
  x= where( boundary_type ne 0, npts )

  tave=dblarr(1000)

  stype=stype(0:(npts-1))
  timestart=timestart(0:(npts-1))
  timestop=timestop(0:(npts-1))
  for jkl=0,npts-1 do begin
      tave(jkl)=(timestart(jkl)+timestop(jkl))/2.
  endfor

  x_4OCLOCK=4*3600.
  sep_XBOX=[0,x_4OCLOCK,x_4OCLOCK,0,0]*3.5/4. + 4*3600 
  sep_YBOX=[-.1,-.1,.1,.1,-.1]*4

  file='/opt/hydra/tmp_data/other_data_sets/19960529_reconnection_events.dat' 
  read_reconnection_events, file, rd, sep, null
  timestart1= [ rd.starttime, sep.starttime, null.starttime ] * 3600
  timestop1= [ rd.endtime, sep.endtime, null.endtime ] * 3600

; convert to papco axis time frame
  timestart= timestart + ( 202176000 - xrange(0) )
  timestop= timestop + ( 202176000 - xrange(0) )
  tave= tave + ( 202176000 - xrange(0) )
  sep_XBOX= sep_XBOX  + $
    ( 202176000 - xrange(0) )

  xrange_shift= xrange - xrange(0)
  
; BEFORE ANY SORT MAKE PLOT
  charsize= ( !p.position(3)-!p.position(1) ) / 0.31375 * 1.6 < 2.0

  ticks=strarr(30)
  ticks(*)=' '
  ytickv=[-10,-9,-5,-4,4,5,9,10] ;numbers locations
  ytickname=['S:IV','RD:IV','S:I','RD:I','RD:II','S:II', 'RD:III', 'S:III'] 
  ytickname(*)=' '
  yticks=7

  if not keyword_set( overplot ) then begin      
      goodticks, xtickv, xminor
      xticks= n_elements(xtickv)-1 
      PLOT,sep_XBOX,sep_YBOX,YRANGE=[-12,12.],YSTYLE=1,$
        xrange=xrange_shift, /nodata, $
        xstyle=1,$
        xtickformat=xtickformat,$
        yticklen=.00001,ytickname=ytickname,ytickv=ytickv,$
        xtickv=xtickv, xminor=xminor, xticks=xticks, $
        yticks=yticks
      if panel(0) eq 0 then $
        x_side_label,panel,font+'time (UT)!CDate',XTICKLEN=0.03
  endif

  oplot,sep_XBOX,sep_YBOX,color=cs.blue

;  plot separator crossings.
  print, panel(0)
  if panel(0) then begin
      xyouts, !p.position[0], !p.position[1], /normal, 'new'
      hd_make_timetags, sep_timetags, $
        null.starttime, dateYYYYMMDD=19960529, $
        ( null.endtime - null.starttime ), /hsm
      sep_crossings= null.code
  endif else begin
      xyouts, !p.position[0], !p.position[1], /normal, 'old'
      hd_data_sets= getenv('hd_data_sets')
      if hd_data_sets eq '' then $
        hd_data_sets='/opt/hydra/tmp_data/hyd_access_data_sets/'
      f= findfile( hd_data_sets + 'separator_crossings_3.idlsav' )
      if f(0) eq '' then begin
          message, 'Can''t find separator crossings file', /cont
          sep_crossings= -1
      endif else begin
          message, 'Reading '+f(0), /cont
          sep_timetags='' & sep_crossings=''
          restore, f(0)
      endelse
  endelse

  if sep_crossings(0) ne -1 then begin
      r= where( sep_crossings ge 9 and sep_crossings le 12 )
      sep_timetags= sep_timetags(r)
      hyd_access, sep_timetags, 'time_bin_start_t90', st 
      st= st - xrange(0)
      hyd_access, sep_timetags, 'time_bin_width_seconds',sw
      for i=0,n_elements( sep_timetags )-1 do begin
          oplot, (st(i)+sw(i)*[0,1,1,0,0])>!x.crange(0)<!x.crange(1), $
            sep_YBOX, color=cs.blue
          polyfill, (st(i)+sw(i)*[0,1,1,0,0])>!x.crange(0)<!x.crange(1), $
            sep_YBOX, color=cs.blue
      endfor
  endif

  oplot,!x.crange,[10,10],linestyle=0,color=cs.orange
  oplot,!x.crange,[5,5],linestyle=0,color=cs.green

  oplot,!x.crange,[9,9],linestyle=0,color=cs.orange
  oplot,!x.crange,[4,4],linestyle=0,color=cs.green

  oplot,!x.crange,[-10,-10],linestyle=0,color=cs.cyan

  oplot,!x.crange,[-5,-5],linestyle=0,color=cs.red
  oplot,!x.crange,[-9,-9],linestyle=0,color=cs.cyan

  oplot,!x.crange,[-4,-4],linestyle=0,color=cs.red


; NOT MAKE PLOTS OF TIME TAGS FROM Y=0 UP OR DOWN BASED ON LOCATION RE SEPARATOR
; TIME IS RE 4OCLOCK
  sepy= 0.4
  FOR JKL=0,NPTS-1 DO BEGIN
      if(boundary_type(jkl) eq 3) and $
        ( ( type and 1 ) eq 1 ) then begin
                                ; waves here
          y=-12+24*findgen(1000)/999.
          x=tave(jkl)+0.01*sin(y*2*!pi)*(xrange_shift(1)-xrange_shift(0))/(3)
          oplot, x,y
      endif
      IF(BOUNDARY_TYPE(JKL) EQ 1 OR BOUNDARY_TYPE(JKL) EQ 2) and $
        ( ( type and 4 ) eq 4 ) THEN BEGIN ;rds
                                ; RDS
          FACTOR=1
          IF(BOUNDARY_NUMBER(JKL) EQ 1) THEN begin
              YPLOT=-4*FACTOR
              polyfill,[timestart(jkl),timestop(jkl),timestop(jkl),$
                        timestart(jkl),timestart(jkl)] > !x.crange(0) < !x.crange(1), $
                [-sepy,-sepy,yplot,yplot,-sepy],color=cs.red
          endif
          IF(BOUNDARY_NUMBER(JKL) EQ 2) THEN begin
              YPLOT= 4*FACTOR
              polyfill,[timestart(jkl),timestop(jkl),timestop(jkl),timestart(jkl),$
                        timestart(jkl)] > !x.crange(0) < !x.crange(1), $
                [sepy,sepy,yplot,yplot,sepy],color=cs.green
          endif
          IF(BOUNDARY_NUMBER(JKL) EQ 3) THEN begin
              YPLOT= 9.*FACTOR
              polyfill,[timestart(jkl),timestop(jkl),timestop(jkl),timestart(jkl),$
                        timestart(jkl)] > !x.crange(0) < !x.crange(1), $
                [sepy,sepy,yplot,yplot,sepy],color=cs.orange
          endif
          IF(BOUNDARY_NUMBER(JKL) EQ 4) THEN begin
              YPLOT=-9.*Factor
              polyfill,[timestart(jkl),timestop(jkl),timestop(jkl),timestart(jkl),$
                        timestart(jkl)] > !x.crange(0) < !x.crange(1), $
                [-sepy,-sepy,yplot,yplot,-sepy],color=cs.cyan ;till cyan
          endif
          if(Boundary_number(jkl) eq 13) then begin
              ydwn=-4
              yup=9
              polyfill,[timestart(jkl),timestop(jkl),timestop(jkl),timestart(jkl),$
                        timestart(jkl)] > !x.crange(0) < !x.crange(1), $
                [ydwn,ydwn,yup,yup,ydwn],color=cs.red
              oplot,[timestart(jkl),timestop(jkl),timestop(jkl),timestart(jkl),$
                     timestart(jkl)], [ydwn,ydwn,yup,yup,ydwn],color=cs.green

          endif
          if(Boundary_number(jkl) eq 14) then begin
              ydwn=-4
              yup=-9
              polyfill,[timestart(jkl),timestop(jkl),timestop(jkl),timestart(jkl),$
                        timestart(jkl)] > !x.crange(0) < !x.crange(1), $
                [ydwn,ydwn,yup,yup,ydwn],color=cs.red
              oplot,[timestart(jkl),timestop(jkl),timestop(jkl),timestart(jkl),$
                     timestart(jkl)], [ydwn,ydwn,yup,yup,ydwn],color=cs.cyan
          endif

      ENDIF
                                ;
      IF(BOUNDARY_TYPE(JKL) EQ 4) $
        and (( type and 2 ) eq 2 ) THEN BEGIN
                                ; SEPARATRIX CROSSING
          factor_new=2
          IF(BOUNDARY_NUMBER(JKL) EQ 1) THEN begin
              YPLOT=-2.5*factor_new
              color_temp=cs.red
          endif
          IF(BOUNDARY_NUMBER(JKL) EQ 2) THEN begin
              YPLOT= 2.5*factor_new
              color_temp=cs.green
          endif
          IF(BOUNDARY_NUMBER(JKL) EQ 3) THEN begin
              YPLOT= 5.*factor_new
              color_temp=cs.orange
          endif
          IF(BOUNDARY_NUMBER(JKL) EQ 4) THEN begin
              YPLOT=-5.*factor_new
              color_temp=cs.cyan
          endif
          OPLOT, (TAVE(JKL))*[1,1],YPLOT*[1,sepy/abs(yplot)],color=color_temp
      ENDIF
  ENDFOR

  ch_y_data= !d.y_ch_size * (charsize*0.8) / float(!d.y_size) / !y.s(1) ; to normal
  ch_x_data= -5 * !d.x_ch_size * (charsize*0.8) / float(!d.x_size) / !x.s(1) 

  xyouts, !x.crange(0),-10-ch_y_data,'S:IV ',color=cs.cyan,charsize=-charsize, /noclip, width=ch_x_data
  xyouts, !x.crange(0)-ch_x_data/!x.s(1), -10-ch_y_data,'S:IV',color=cs.cyan,charsize=charsize, /noclip

  xyouts, !x.crange(0),-5-ch_y_data,'S:I ',color=cs.red,charsize=-charsize, /noclip, width=ch_x_data
  xyouts, !x.crange(0)-ch_x_data/!x.s(1),-5-ch_y_data,'S:I',color=cs.red,charsize=charsize, /noclip

  xyouts, !x.crange(0),5,'S:II ',color=cs.green,charsize=-charsize, /noclip, width=ch_x_data
  xyouts, !x.crange(0)-ch_x_data/!x.s(1),5,'S:II',color=cs.green,charsize=charsize, /noclip

  xyouts, !x.crange(0),10,'S:III ',color=cs.orange,charsize=-charsize, /noclip, width=ch_x_data
  xyouts, !x.crange(0)-ch_x_data/!x.s(1),10,'S:III',color=cs.orange,charsize=charsize, /noclip

  xyouts, !x.crange(0), 4-ch_y_data,'RD:II ',color=cs.green,charsize=-charsize, width=ch_x_data
  xyouts, !x.crange(0)-ch_x_data/!x.s(1), 4-ch_y_data,'RD:II',color=cs.green,charsize=charsize

  xyouts, !x.crange(0), 9-ch_y_data,'RD:III ',color=cs.orange,$
    charsize=-charsize, width=ch_x_data
  xyouts, !x.crange(0)-ch_x_data/!x.s(1), 9-ch_y_data,'RD:III',color=cs.orange, charsize=charsize

  xyouts, !x.crange(0), -9,'RD:IV ',color=cs.cyan,charsize=-charsize, width=ch_x_data
  xyouts, !x.crange(0)-ch_x_data/!x.s(1), -9,'RD:IV',color=cs.cyan,charsize=charsize

  xyouts, !x.crange(0), -4, 'RD:I ',color=cs.red,charsize=-charsize, width=ch_x_data
  xyouts, !x.crange(0)-ch_x_data/!x.s(1), -4, 'RD:I',color=cs.red,charsize=charsize

;xyouts,  6.5,-10,'S:IV',color=cs.cyan,charsize=charsize

;xyouts, 6.5,-5,'S:I',color=cs.red,charsize=charsize

;xyouts, 6.5,5,'S:II',color=cs.orange,charsize=charsize

;xyouts, 6.5,10,'S:III',color=cs.green,charsize=charsize

;xyouts, 7.1, 4,'RD:II',color=cs.orange,charsize=charsize

;youts, 7.1, 9,'RD:III',color=cs.green,charsize=charsize

;youts, 7.1, -9,'RD:IV',color=cs.cyan,charsize=charsize

;xyouts, 7.1, -4, 'RD:I',color=cs.red,charsize=charsize

;
;  form title
  subtitle=['Alfven Waves','Separatrix!cCrossings',"RD's"]
  title=''
  for i=0,2 do begin
      if (type and 2^i) eq 2^i then begin
          if strlen( title ) eq 0 then begin
              title= title+subtitle(i)
          endif else begin
              title= title+'!c!c'+subtitle(i)
          endelse
      endif
  endfor

; supress title printing
  if 0 then begin
      abunchoflfs='!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c'
      lfs= strmid( abunchoflfs, 0, 6*(plots_atthisposition<10) )
      right_side_label, panel, lfs+title, _extra=extra_plotPar
  endif

  !p.color= opcolor

END

