pro p_scratch_efi, panel, type, hydra_plot_kw=hp_kw, _extra=extra_kw, $
                   plots_atthisposition=plots_atthisposition, $
                   subtable=subtable, overplot=overplot
                   

@hd_include

   common sp_efi_data, $
     efi_head, efi_data, $
     efi34_head, efi34_data, $
     efi_xyz56_head, efi_xyz56_data, $
     efi_uzpay_head, efi_uzpay_data

   common hydra_mvc_common, $
     hydra_mvc_head, hydra_mvc_B_data, hydra_mvc_J_perp_data, $
     hydra_mvc_Press_data,$
     hydra_mvc_Qdata, hydra_mvc_U_perp_ele_data,$
     hydra_mvc_U_perp_ion_data, hydra_mvc_edata, hydra_mvc_u_ele_data,$
     hydra_mvc_u_ion_data, hydra_mvc_j_data, $
     hydra_mvc_vel_km_s, hydra_mvc_traj_re
   
   common time, xut1, xut2
   common papco_color_names
   
   dxut= xut2-xut1

   ylog0=1
   
   matched=1                    ; see else clause
   case type of 
       'ExB_x_gsm': begin
           data= efi_data.vx
           title='EFI ExB!iX-GSM'
           units='km/s'
       end
       'ExB_y_gsm': begin
           data= efi_data.vy
           title='EFI ExB!iY-GSM'
           units='km/s'
       end
       'ExB_z_gsm': begin
           data= efi_data.vz
           title='EFI ExB!iZ-GSM'
           units='km/s'
       end
       'ExB_mag': begin
           data= sqrt( efi_data.vx^2 + efi_data.vy^2 + efi_data.vz^2 )
           title='EFI !9!!!xExB!9!!!x'
           units='km/s'
       end
       'Ex gsm': begin
           data= efi_data.ex_gsm
           title='EFI E!dx-GSM'
           units='mV/m'
       end
       'Ey gsm': begin
           data= efi_data.ey_gsm
           title='EFI E!dy-GSM'
           units='mV/m'
       end
       'Ez gsm': begin
           data= efi_data.ez_gsm
           title='EFI E!dz-GSM'
           units='mV/m'
       end
       'E mag': begin
           data= sqrt( efi_data.ex_gsm^2 + $
                       efi_data.ey_gsm^2 + efi_data.ez_gsm^2 )
           title='EFI !9!!!xE!9!!!x'
           units='mV/m'
       end
       'Ex_FAC': begin
           data= efi_data.ex_fac
           title='EFI E!dx-FAC'
           units='mV/m'
       end
       'Ey_FAC': begin
           data= efi_data.ey_fac
           title='EFI E!dy-FAC'
           units='mV/m'
       end
       'Ez_FAC': begin
           data= efi_data.ez_fac
           title='EFI E!d!9#!x'
           units='mV/m'
       end
       else: matched=0
   endcase
   if matched then begin
       time= efi_head.start_time - xut1 + efi_data.time
   endif


   if type eq 'Ez_*_Jz' or type eq 'E dot J' or type eq 'DecayTime' then begin
       Eparl= efi_data.ez_fac
       Egsm= transpose( [ [ efi_data.ex_gsm ], $
                          [ efi_data.ey_gsm ], $
                          [ efi_data.ez_gsm ] ] )
       Etim= efi_data.time + ( efi_head.start_time - xut1 )
       common hydra_current_data, $
         current_header, $
         current_data
       Jparl= current_data.j_parl
       Jgsm= current_data(*).j_gsm
       Jgsm= Jgsm(0:2,*)
       Jtim= current_data(*).time + ( current_header.start_time - xut1 )

       message, 'syncronizing data sets', /cont
       m= 13.8
       b= Jtim(0) - m/2

       iloc= long( ( Etim - b ) / m )
       S= dblarr( max(iloc)+1 )
       N= lonarr( max(iloc)+1 )
       SEgsm= dblarr( 3, max(iloc)+1 ) 
       JS= dblarr( max(iloc)+1 )
       JN= lonarr( max(iloc)+1 )
       JgsmS= dblarr( 3, max(iloc)+1 )
       for i=0,n_elements(iloc)-1 do begin
           if iloc(i) ge 0 then begin
               S(iloc(i))= S(iloc(i)) + Eparl(i)
               SEgsm(*,iloc(i))= SEgsm(*,iloc(i)) + Egsm(*,i)
               N(iloc(i))= N(iloc(i)) + 1
           endif
       endfor

       iloc= long( ( Jtim - b ) / m )
       JS(iloc)= Jparl
       JN(iloc)= 1
       JgsmS(*,iloc)= Jgsm

       r= where( N gt 0 and JN gt 0 )

       Eparl= S(r)/N(r)


       Egsm= SEgsm(*,r)/([1,1,1]#N(r))
       Etim= (r) * m + b 

       Jparl= JS(r)
       Jgsm= JgsmS(*,r)
       
       time= Etim
              
       case type of 
           'Ez_*_Jz': begin
               if getenv( 'hydra_presentation_mode' ) eq '1' then $
                 title= 'E!i!9#!n.!xJ!i!9#!n!x' $
               else title= 'E!i!9#!n.!xJ!i!9#!n!x!cEFI,HYDRA'
               units='W/km!e3!n'
               time_range= gen_time( [xut1,xut2], /t90 ) 
               hyd_access, q_timetags, get_timetags=time_range, $
                 'e_parl_j_parl', data
               hyd_access, q_timetags, 'time_bin_start_t90', time
               time=time-xut1
               r= where( q_timetags.valid_register eq 0 )
               if r(0) ne -1 then data(r)=1e31
           end
           'E dot J': begin
               title= 'E!9.!xJ'
               units= 'W/km!e3!n'
               data= total( Jgsm*Egsm, 1 ) * 3.33 
           end
           'DecayTime': begin
               title= '!7m!x!d(B!e2!d+E!e2!d)/8!7p!x!n' ; 'Decay Frequency'
               units= 'Hz'
               time_range= gen_time( [xut1,xut2], /t90 )
               hd_make_timetags, timetags, time+xut1, 13.8, /t90
               hyd_access, timetags, 'b_gsm', B, get_timetags=time_range
               bmag2= total( B^2, 2 ) 
               Emag2= total ( Egsm^2, 1 )
               pi8= 8 * !pi
               hyd_access, timetags, $
                 'e_parl_j_parl', eparl_jparl
               hyd_access, timetags, 'time_bin_start_t90', time
               time=time-xut1
               data= ( eparl_jparl * 1/3. * 1e-7 ) / $
                 ( bmag2 * ( 1e-10 / pi8 ) + ( 1e-14 / 9 / pi8 ) * Emag2 ) 
               r= where( timetags.valid_register eq 0 )
               if r(0) ne -1 then data(r)=1e31
           end
           else: begin
               message, 'Internal Error, plot not implemented (2)', /cont
               return
           end
       endcase
   endif else if type eq 'V34Raw' or type eq 'SCPot34' then begin       
       case type of 
           'V34Raw': begin
               title= 'V34raw'
               units= ''
               data= efi34_data.v34raw
               time= efi34_data.v34raw_time + ( efi34_head.start_time - $
                                                xut1 )
           end
           'SCPot34': begin
               title= 'scpot34'
               units= ''
               data= -1.0 * efi34_data.scpot34
               time= efi34_data.scpot34_time + ( efi34_head.start_time - $
                                                 xut1 )
           end
       endcase
       r= where( time gt 0 )
       if r(0) ne -1 then begin
           data= data(r)
           time=time(r)
       endif
       
   endif 

   if (where( [ 'efi_Exy', 'efi_Ez', 'efi_E56', $
                'efi_Bxy', 'efi_Bz', 'efi_B56' ] eq type ))(0) ne -1 then begin
       file='xy_z_56!c'
       case type of 
           'efi_Exy': begin
               title= file+type
               units= 'mV/m'
               data= efi_xyz56_data.exy
               time= efi_xyz56_head.start_time - xut1 + efi_xyz56_data.etime
           end
           'efi_Ez': begin
               title= file+type
               units= 'mV/m'
               data= efi_xyz56_data.ez
               time= efi_xyz56_head.start_time - xut1 + efi_xyz56_data.etime
           end
           'efi_E56': begin
               title= file+type
               units= 'mV/m'
               data= efi_xyz56_data.e56
               time= efi_xyz56_head.start_time - xut1 + efi_xyz56_data.etime
           end 
           'efi_Bxy': begin
               title= file+type
               units= 'nT'
               data= efi_xyz56_data.bxy
               time= efi_xyz56_head.start_time - xut1 + efi_xyz56_data.btime
           end 
           'efi_Bz': begin
               title= file+type
               units= 'nT'
               data= efi_xyz56_data.bz
               time= efi_xyz56_head.start_time - xut1 + efi_xyz56_data.btime
           end 
           'efi_B56': begin
               title= file+type
               units= 'nT'
               data= efi_xyz56_data.b56
               time= efi_xyz56_head.start_time - xut1 + efi_xyz56_data.btime
           end
       endcase
   endif 

   if type eq 'efi_UZPAY' then begin
       units='km/s'
       time= ( efi_uzpay_head.start_time - julday( 1,1,1990 ) ) * 86400 - $
         xut1 + efi_uzpay_data.time
       data= efi_uzpay_data.polar_v_56
       title= 'polar_v_56'
       date= gen_time_string( efi_uzpay_head.start_time, /julian )
       mat= efi_to_payload( date )
       if mat(2,2) eq -1 then begin
           message, 'Flipping sign on Z.', /cont
           data= -1 * data 
           title= title+'!c*(-1)'
       endif
   endif
   
   dts= time(1:*)-time(0:*) 
   dt= median(dts)   

; set all the plot keywords
   goodticks, xtickv, xminor
   xticks=n_elements(xtickv)-1

   rvis= where( 0 lt time and time lt dxut )
   if rvis(0) ne -1 then begin
       time= time(rvis)
       data= data(rvis)
   endif

   common yscale, yscl		
   ylog=yscl(panel(0),3)
   if (yscl(panel(0),0) eq 1) then begin
       print, '% p_hydra_kp: getting manual scale specifications: '
       yst= yscl(panel(0),1)
       yen= yscl(panel(0),2)
       ylog= yscl(panel(0),3)
   endif else begin             ; use autoscale results
       rv=where(data lt 1e30 and data gt -1e30)
       if rv(0) ne -1 then begin
           rt=where( time(rv) ge 0 and time(rv) le dxut )
           if rt(0) ne -1 then rv=rv(rt) else rv=-1
       endif else rv=-1
       if rv(0) ne -1 then begin
           yen= max( data(rv), min=yst )
       endif else begin
           yen=0 
           yst=1
       endelse
       yscl(panel(0),1)= yst
       yscl(panel(0),2)= yen
   endelse
   yrange=[yst,yen]
   IF (yst LE 0 AND ylog EQ 1) THEN BEGIN
       print, '% p_scratch_efi: Negative ymin: swwitching from log to linear...'
       yscl(panel(0),3) =  0
       ylog = yscl(panel(0),3)
   ENDIF

   if ylog0 eq 0 then ylog=0   

   common_kw= { xrange:[0,dxut], yrange:yrange, ylog:ylog, $
                noerase:1, ticklen:-0.03, xticklen:-0.03, $
                xtickv:xtickv, xminor:xminor, xticks:xticks, $
                ytitle:units, max_value:1e30, min_value:-1e30 }

   if n_elements( extra_kw ) eq 0 then extra_kw={ color:1 }

   axis_kw= create_struct( common_kw, { color:1 } ) ; contains color
   plot_kw= create_struct( common_kw, extra_kw ) ; contains color

   if panel(0) eq 0 then  $
     xtickformat='hydra_timeticks' $
   else $
     xtickformat='noticks'

;  plot axis if not an overplot   
   if not keyword_set( overplot ) then begin
       plot, time, data, /nodata, _extra=axis_kw, $
         xtickformat=xtickformat, xstyle=1, ystyle=1
   endif
   
   if type eq 'DecayTime' and n_elements( hp_kw ) gt 0 then begin
       if !y.type eq 0 then begin
           dx= !x.crange(1)- !x.crange(0)
           dy= !y.crange(1)- !y.crange(0)
           if !y.crange(1) gt 0 then $
             xyouts, !x.crange(0)+0.05*dx, !y.crange(1)-0.15*dy, 'Dissipation', $
             color=get_color_index('red'), charsize=1.5
           if !y.crange(0) lt 0 then $
             xyouts, !x.crange(0)+0.05*dx, !y.crange(0)+0.05*dy, 'Generation', $
             color=get_color_index('blue'), charsize=1.5
       endif
   endif

;  plot data 
   rvis= where( time+dt gt !x.crange(0) and time lt !x.crange(1) )
   if rvis(0) ne -1 then begin
       if n_elements( hp_kw ) gt 0 then $
         plot_kw= create_struct( plot_kw, hp_kw )
       hydra_plot, time(rvis), data(rvis), _extra= plot_kw, $
         xstyle=5, ystyle=5, dx=dt
   endif

;  label plot right of panel
   abunchoflfs='!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c'
   lfs= strmid( abunchoflfs, 0, 6*(plots_atthisposition<10) )
   right_side_label,panel,lfs+title, _extra=extra_kw

   return

end
