pro p_scratch_nif, panel, type, hydra_plot_kw=hp_kw, _extra=extra_kw, $
                   plots_atthisposition=plots_atthisposition, $
                   subtable=subtable, overplot=overplot

   common hydra_nif_common, $
     hydra_nif_head, hydra_nif_B_data, hydra_nif_J_perp_data, $
     hydra_nif_Press_data,$
     hydra_nif_Qdata, hydra_nif_U_perp_ele_data,$
     hydra_nif_U_perp_ion_data, hydra_nif_edata, hydra_nif_u_ele_data,$
     hydra_nif_u_ion_data, hydra_nif_j_data, $
     hydra_nif_vel_km_s, hydra_nif_traj_re
   
   common time, xut1, xut2
   common papco_color_names
   
   dxut= xut2-xut1
   
   matched=1                    ; see else clause

   if getenv( 'hydra_presentation_mode' ) ne 1 then $
     panel_title= 'Hydra NIF!c' $
   else $
     panel_title= ''

;  get panel type title
   scratch_pad_define_types
   common scratch_nif_control, nif_types
   type_ids= nif_types(1,*)
   type_titles= nif_types(3,*)
   i= (where( type_ids eq type ))(0)
   if i eq -1 then begin
       title= panel_title + '??????'
   endif else begin
       title= panel_title+type_titles(i)+'!x'
   endelse

   y_kw={ylog:0}

   nif2=0
   if strmid( type,0,8) eq 'vel_km_s' then begin
       data_s= hydra_nif_vel_km_s
       nif2=1
       units='km/s'
       subtype=strmid(type,9,4)
   endif

   if strmid( type,0,7) eq 'traj_Re' then begin
       data_s= hydra_nif_traj_Re
       nif2=1
       subtype=strmid(type,8,4)
       units='Re'
   endif

   if nif2 eq 1 then begin
       case subtype of 
           'x':  data= data_s.comp(0)
           'y':  data= data_s.comp(1)
           'z':  data= data_s.comp(2)
           'thet':  data= data_s.angle1
           'phi':  data= data_s.angle2
           'ang3':  data= data_s.angle3
           else: begin
               message, /cont, 'internal error: subtype not recognised: '+type
               return
           end
       endcase
       if ( where( ['thet','phi','ang3'] eq subtype ))(0) ne -1 then begin
           units='deg'         
           if subtype eq 'phi' then begin
               yrange=[-180,180] 
               yticks=4
               yminor=3
           endif else begin
               yrange=[0,180]
               yticks=2
               yminor=3
           endelse
           y_kw={ylog:0,yrange:yrange,yticks:yticks}
       endif
       time= hydra_nif_head.start_time - xut1 + data_s.time
   endif

   if strmid( type, 0, 4 ) eq 'nif_' then begin
       units=''
       nif2=0
  
       case strmid( type, 0, 5 ) of 
           'nif_j': begin
               if strmid(type,0,10) eq 'nif_j_perp' then begin
                   data_s= hydra_nif_j_perp_data
                   units='cgs'
               endif else begin
                   data_s= hydra_nif_j_data
                   units='cgs'
               endelse               
           end
           'nif_b': begin
               data_s= hydra_nif_b_data
               units='nT'
           end
           'nif_p': begin
               data_s= hydra_nif_press_data
;               units='10!e-15!ndynes/cm!e2!n'
               data_s.comp= data_s.comp*10
               units= 'pP/km'
           end
           'nif_q': begin
               data_s= hydra_nif_Qdata
               units='cgs'
           end
           'nif_a': begin
               data_s= hydra_nif_U_perp_ele_data
               units='km/s'
           end
           'nif_f': begin
               data_s= hydra_nif_U_perp_ion_data
               units='km/s'
           end
           'nif_e': begin
               data_s= hydra_nif_edata
               units='mV/m'
           end
           'nif_c': begin
               data_s= hydra_nif_u_ele_data
               units='km/s'
           end
           'nif_d': begin
               data_s= hydra_nif_u_ion_data           
               units='km/s'
           end
       endcase
       
       time= hydra_nif_head.start_time - xut1 + data_s.time
       s= str_sep( type, '_' ) 
       type= s(n_elements(s)-1)
       case type of
           'x': data= data_s(*).comp(0)
           'y': data= data_s(*).comp(1)
           'z': data= data_s(*).comp(2)
           'theta': data= data_s(*).theta
           'phi': data= data_s(*).phi
           'mag': data= sqrt( total( (data_s(*).comp(*))^2,1 ) )
           else: begin
               message, /cont, 'internal error: subtype not recognised: '+type
               return
           end
       endcase
       if type eq 'theta' or type eq 'phi' then begin
           units='deg'
           if type eq 'phi' then yrange=[0,360] else yrange=[0,180]
           y_kw= {ylog:0,yrange:yrange,yticks:4}
       endif
   endif
   
   dts= time(1:*)-time(0:*) 
   dt= median(dts)   

; set all the plot keywords
   goodticks, xtickv, xminor
   xticks=n_elements(xtickv)-1

   rvis= where( 0 lt time and time lt dxut )
   if rvis(0) ne -1 then begin
       time= time(rvis)
       data= data(rvis)
   endif

   forward_function hydra_ytick_parm
   r= where( data lt 1e29 )
   if r(0) eq -1 then r=lindgen( n_elements( data ))
   y_kw= hydra_ytick_parm( data(r), panel=panel, _extra= y_kw )

   common_kw= { xrange:[0,dxut], $
                noerase:1, ticklen:-0.03, xticklen:-0.03, $
                xtickv:xtickv, xminor:xminor, xticks:xticks, $
                ytitle:units, min_value:-1e29, max_value:1e29, yticklen:0.02 }

   common_kw= create_struct( common_kw, y_kw )

   if n_elements( extra_kw ) eq 0 then extra_kw={ color:1 }

   axis_kw= create_struct( common_kw, { color:1 } ) ; contains color
   plot_kw= create_struct( common_kw, extra_kw ) ; contains color

   if panel(0) eq 0 then  $
     xtickformat='hydra_timeticks' $
   else $
     xtickformat='noticks'

;  plot axis if not an overplot   
   if not keyword_set( overplot ) then begin
       plot, time, data, /nodata, _extra=axis_kw, $
         xtickformat=xtickformat, xstyle=1, ystyle=1
   endif

;  plot data 
   rvis= where( time+dt gt !x.crange(0) and time lt !x.crange(1) )
   if rvis(0) ne -1 then begin
       if n_elements( hp_kw ) gt 0 then $
         plot_kw= create_struct( plot_kw, hp_kw )
       hydra_plot, time(rvis), data(rvis), _extra= plot_kw, $
         xstyle=5, ystyle=5, dx=dt
   endif

;  label plot right of panel
   abunchoflfs='!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c'
   lfs= strmid( abunchoflfs, 0, 6*(plots_atthisposition<10) )
   right_side_label,panel,lfs+title, _extra=extra_kw

   return

end
