function polar_payload_to_gsm_rotation, date
   
;  returns rotations for polar payload to gsm coordinates.
;    rotations are returned in a array of structures:
;       { R:fltarr(3,3), t:0. }
;    each containing a rotation and corresponding time.
;
;  written, Jeremy Faden, Aug 20, 1998 using code from
;    Pamela Puhl-Quinn's PAPCO_payload_to_gsm.pro


;  Get the following resources: 
;     right ascension(time)
;     declination(time)
;     time
;  we'll use the HYDRA ddcal file.

 
   f= hydra_findfile( date, /ddcal )
   if (f NE '') then begin
      print, myname+'Opening '+f+'...'
      cdfid = cdf_open(f)
   endif else begin
       message, 'Can''t get HYDRA ddcal file.', /cont
       return, -1
   endelse

 ; First get the gsm spin-vector info
   att_res = 600.               ; Attitude file resolution in seconds
   orb_res = 60.                ; Orbit file resolution in seconds

   rec_start = 0
   rec_count_att = 144
   rec_count_orb = 1440

   cdf_varget, cdfid, 'GSM_EPHEM_TIME', att_time, rec_start=rec_start, $
    rec_count=rec_count
   cdf_varget, cdfid, 'GSM_R_ASCENSION', gsm_ra, rec_start=rec_start, $
    rec_count=rec_count
   cdf_varget, cdfid, 'GSM_DECLINATION', gsm_dec, rec_start=rec_start, $
    rec_count=rec_count

   att_time = reform(att_time)
   gsm_ra = reform(gsm_ra)
   gsm_dec = reform(gsm_dec)

; Create the matrices needed on this crude time-scale (minimize the
; number of trig functions)

   pay2gsm = dblarr(3,3,n_elements(att_time))

   RAC = double(gsm_ra)
   DEC = double(gsm_dec)

   EPX = COS(DEC) * COS(RAC)
   EPY = COS(DEC) * SIN(RAC)
   EPZ = SIN(DEC)
;
;-- COMPUTE SINE VALUES AND COSINE VALUES OF ANGLES A AND D
;
   COSA = SQRT(EPY*EPY + EPZ*EPZ)
   SINA = EPX
   COSD = EPZ/COSA
   SIND = EPY/COSA
;
;-- CONSTRUCT THE TRANSFORMATION MATRIX
;
   pay2gsm(0,0,*) = COSA
   pay2gsm(0,1,*) = 0.
   pay2gsm(0,2,*) = SINA
   pay2gsm(1,0,*) = -SINA * SIND
   pay2gsm(1,1,*) = COSD
   pay2gsm(1,2,*) = COSA * SIND
   pay2gsm(2,0,*) = -SINA * COSD
   pay2gsm(2,1,*) = -SIND
   pay2gsm(2,2,*) =  COSA * COSD
   
   result= replicate( { R:dblarr(3,3), t:double(0) },  )
   return
end


