function polar_payload_to_gse_rotation, date
   
;  returns rotations for polar payload to gsm coordinates.
;    rotations are returned in a array of structures:
;       { R:fltarr(3,3), t:0. }
;    each containing a rotation and corresponding time.
;
;  written, Jeremy Faden, Aug 20, 1998 using code from
;    Pamela Puhl-Quinn's PAPCO_payload_to_gsm.pro


;  Get the following resources:  (this could actually come from any satallite.)
;     right ascension(time)
;     declination(time)
;     time
;  we'll use the HYDRA ddcal file.

 
   f= hydra_findfile( date, /ddcal )
   if (f NE '') then begin
       message, 'Opening '+f+'...', /cont
       cdfid = cdf_open(f)
   endif else begin
       message, 'Can''t get HYDRA ddcal file.', /cont
       return, -1
   endelse

                                ; First get the gse spin-vector info
   att_res = 600.               ; Attitude file resolution in seconds
   orb_res = 60.                ; Orbit file resolution in seconds

   rec_start = 0
   rec_count_att = 144
   rec_count_orb = 1440
	
   cdf_varget, cdfid, 'GSM_EPHEM_TIME_AT', att_time, rec_start=rec_start, $
    rec_count=rec_count_att
   cdf_varget, cdfid, 'GSE_R_ASCENSION_AT', gse_ra, rec_start=rec_start, $
    rec_count=rec_count_att
   cdf_varget, cdfid, 'GSE_DECLINATION_AT', gse_dec, rec_start=rec_start, $
    rec_count=rec_count_att

   att_time = reform(att_time)
   gse_ra = reform(gse_ra)
   gse_dec = reform(gse_dec)

; Create the matrices needed on this crude time-scale (minimize the
; number of trig functions)

   pay2gse = dblarr(3,3,n_elements(att_time))

   RAC = double(gse_ra)
   DEC = double(gse_dec)

   EPX = COS(DEC) * COS(RAC)
   EPY = COS(DEC) * SIN(RAC)
   EPZ = SIN(DEC)
;
;-- COMPUTE SINE VALUES AND COSINE VALUES OF ANGLES A AND D
;
   COSA = SQRT(EPY*EPY + EPZ*EPZ)
   SINA = EPX
   COSD = EPZ/COSA
   SIND = EPY/COSA
;
;-- CONSTRUCT THE TRANSFORMATION MATRIX
;
   pay2gse(0,0,*) = COSA
   pay2gse(0,1,*) = 0.
   pay2gse(0,2,*) = SINA
   pay2gse(1,0,*) = -SINA * SIND
   pay2gse(1,1,*) = COSD
   pay2gse(1,2,*) = COSA * SIND
   pay2gse(2,0,*) = -SINA * COSD
   pay2gse(2,1,*) = -SIND
   pay2gse(2,2,*) =  COSA * COSD
   
   result= replicate( { R:dblarr(3,3), t:double(0) }, n_elements(att_time) )
   result(*).R= pay2gse
   result(*).t= att_time

   return, result
end



