;******************************************************************************
;*  NAME:        r_file_ascii
;*
;*  DESCRIPTION: Routine to read file_ascii files. Adheres to
;*               papco conventions: Error common block
;*                                  Uses MJDT time
;*                                  papco read philosophy
;*
;*  INPUT:       none (uses common block time from papco)
;*
;*  OUTPUT:      none (places data into common blocks)
;*
;*  KEYWORDS:    VERBOSE  -  enables print comments, save/restore comments
;*
;*  DATE:        June 1996
;*
;*  AUTOR:       R. Friedel
;*
;*  CHANGES:     February 1997. Used MJDT time now, and is a fully
;*               running example module on it's own
;*               October 1997. Rewritten to be more general and fully
;*               adhering to papco philosophy. Added remore Get feature, and
;*               the example data file is no longer part of the 
;*               module - it needs to be gotten remotely first!
;******************************************************************************
pro r_file_ascii, VERBOSE=VERBOSE, aPlotInfo, $
                  header_out, timetags, data, $
                  just_header=just_header
  
  common mjdt, mjdt_start, mjdt_end
  common get_error, get_err_no, get_err_msg
   

; common get_error is used by papco to check if the data read was successful.
; it is up to the user to set this correctly and to make sure that the read- 
; routine does not crash on an I/O error - otherwise papco will crash at that
; point, too. papco draws an empty panel when get_err_no in not equal to zero
; and prints get_err_msg in that panel for user information. papco will try
; to invoce the plot routine for this data if get_err_no = 0 , otherwise an
; emplty panel with the error message get_err_msg is plotted.

  get_err_no=1
  get_err_msg='unidentified error encountered.'

  just_header= keyword_set( just_header )
  
  file= aPlotInfo.filename
  
  header= { time_base:0D, $
            label:'', $
            units:'', $
            time_alias:0D, $
            valid_min:-1e30, $
            valid_max:1e30, $
            version:-1., $
            notes:'' $
          }
  r_file_ascii_ascii, file, header, timetags, data, just_header=just_header
  if get_err_no ne 0 then return

  header_out= header

  get_err_no=0
  
  return
end
