pro r_file_ascii_ascii, file, header, timetags, data_out, $
                        just_header=just_header

  common get_error, get_err_no, get_err_msg
 
  if file eq '' then begin
      message, 'Filename not specified.', /cont
      get_err_msg= 'Filename not specified.'
      get_err_no= 1
      return
  endif

  message, 'Reading file '+file+'...', /cont
  openr, unit, /get_lun, file

  time_offset_units= 'seconds'
  
  nline=0 & done=0
  line=''
  while not done do begin
      readf, unit, line
      nline= nline+1
      s= str_sep( line,'=' )
      if n_elements(s) gt 1 then arg= strtrim(s(1),2)
      case strlowcase( s(0) ) of
          'time_base': begin
              time_base_str= arg
              s= str_sep( arg, ' ' )
              r= where(s ne '')
              s= s(r)
              if n_elements(s) eq 1 then s=[s,'0:00']
              time_base= gen_time( date=s(0), time=s(1) )
              date_global= s(0)
          end
          'label': header.label= arg           
          'units': header.units= arg
          'time_offset_units': begin
              case strlowcase(strtrim(arg,2)) of 
                  'hours': time_offset_units='hours'
                  'seconds': time_offset_units='seconds'
                  'hms': time_offset_units='hms'
                  else: message, 'Unrecognized time offset format: '+arg, /cont
              endcase     
          end     
          'valid_max': header.valid_max= double(arg)
          'valid_min': header.valid_min= double(arg)
          'time_interval_length': header.time_alias= double(arg)
          'version': header.version= float(arg)
          'notes': header.notes= arg
          else: begin
              catch, err
              if err eq 0 then begin
                  number= double( s(0) )
                  is_number=1
              endif else begin
                  is_number=0
              endelse
              catch, /cancel
              if is_number eq 0 then begin
                  message, 'Unrecognized keyword: '+s(0), /cont
              endif else begin
                  done=1
              endelse
          end
      endcase
  endwhile
  nskip= nline-1
  
  if keyword_set( just_header ) then begin
      get_err_no=0
      return
  endif
  
;  read the data
;   parse the line the delineated the header.
@hd_include
  time= replicate( hd_timetag_struct, 1000 )
  data= dblarr( 1000 )
  
  idx=0

  s= str_sep( line, ' ' )
  r= where( s ne '', nfield )
; nfield=2  start_time, data
; nfield=3  date, start_time, data
; nfield=4  date, start_time, end_time, data
; nfield=5  date, start_time, date, end_time, data
  
  case nfield of 
      2: reads, line, time1, data1
      3: begin
          date1= 0L
          reads, line, date1, time1, data1
      endif
      4: begin
          date1= 0L
          reads, line, date1, time1, time2, data1
      end
      5: begin
          date1= 0L & date2= 0L
          reads, line, date1, time1, date2, time2, data1
      end
  endcase
  if n_elements( date_global ) eq 0 then date_global='19900101'
  if n_elements( date1 ) eq 0 then date1= date_global
  if n_elements( date2 ) eq 0 then date2= date1
  if n_elements( time_alias ) eq 0 then time_alias=0.
  
  if time_offset_units eq 'hours' then $
    gt_kw={ hours:1 } $
  else if time_offset_units eq 'hms' then $
    gt_kw={ hms:1 } $
  else $
    gt_kw={ seconds:1 }
  
  gen_time1= gen_time( date= date1, time=time1, _extra=gt_kw )
  if n_elements( time2 ) eq 0 then begin
      gen_time2= gen_time1+time_alias/86400
  endif else begin
      gen_time2= gen_time( date= date2, time=time2, _extra=gt_kw )
  endelse
  time(idx).bin_start= gen_time1 
  time(idx).bin_width= gen_time2 - gen_time1
  data(idx)= data1
  idx= idx+1

;   loop through the rest of the code.

  while not eof( unit ) do begin
      readf, unit, line
      nline= nline+1
      catch, err
      if err eq 0 then begin
          case nfield of 
              2: reads, line, time1, data1
              3: reads, line, date1, time1, data1
              4: reads, line, date1, time1, time2, data1
              5: reads, line, date1, time1, date2, time2, data1
          endcase
          if n_elements( date1 ) eq 0 then date1= date_global
          if n_elements( date2 ) eq 0 then date2= date1
          
          gen_time1= gen_time( date= date1, time=time1, _extra=gt_kw )
          if n_elements( time2 ) eq 0 then begin
              gen_time2= gen_time1+time_alias/86400
          endif else begin
              gen_time2= gen_time( date= date2, time=time2, _extra=gt_kw )
          endelse
          time(idx).bin_start= gen_time1 
          time(idx).bin_width= gen_time2 - gen_time1
          data(idx)= data1       
          idx=idx+1
          if idx eq n_elements( time ) then begin
              time= [ time, replicate( hd_timetag_struct, 1000 ) ]
              data= [ data, dblarr( 1000 ) ]
          endif
      endif else begin
          message, 'Error reading line '+strtrim(nline,2)+$
            ', which reads:', /cont
          message, line, /cont
          message, 'omitting line', /cont
      endelse
      catch, /cancel
  endwhile
  close, unit

  data_out= data(0:(idx-1))
  timetags= time(0:(idx-1))

  get_err_no=0
  return
end

