pro reconnection_events_load_xxc_data,$
                                      sstart, sstop, $
                                      heat_sign, $
                                      boundary_number

  dir= getenv('HYD_EFI_SPECIAL_DATA')
  
  close, 10
  openr, 10, dir+'/reconnection_events_QUpara.data'
  
  s=''
  sstart=[0.D]
  sstop=[0.D]
  heat_sign=[+0]
  boundary_number=[0]
  while not eof( 10 ) do begin
      readf, 10, s
      sstart= [ sstart,float( strmid( s, 0,16 ) )]
      sstop= [ sstop, float( strmid( s, 16,16 ))] 
      if strmid(s,34,1) eq '-' then heat_sign= [heat_sign,-1] else $
        heat_sign= [ heat_sign,+1]
      boundary_number= [ boundary_number, long( strmid( s,35,10 )) ]
  endwhile
  sstart= sstart(1:*)
  sstop= sstop(1:*)
  heat_sign= heat_sign(1:*)
  boundary_number= boundary_number(1:*)
end
