function rotate_coord, v3, tv3, R_in, tR_in
;  rotates the three vectors in v3 with rotation in R.  
;     v3  is fltarr(3,n)    time series of vectors vs time 
;     tv3 is fltarr(n)      the time for each three vector
;     R   is fltarr(3,3,m)  time series of rotation matrices
;     tR  is fltarr(m)      the time for each matrix
;      or:
;     R   is an array of structures:
;        { R:fltarr(3,3), t:0. }
;        and tR is not specified. 
;
;  requires the idl code findex or equivalent used typically for
;  interpolation, but in this case is used to find closest times.

;  algorythm is simple: foreach time in tv3, locate closest matrix
;  in time using tr.  Use closest matrix to rotate v3.  This entire
;  process is vectorizable, and should therefore be very fast.

   s= size(R_in)
   if s(n_elements(s)-2) eq 8 then begin ; structure I/O
       R= R_in(*).r
       tR= R_in(*).t
   endif else begin
       R= R_in
       tR= tR_in
   endelse       
   
   ii= round( jbf_findex( tR, tv3 ) ) 
   
   m= n_elements( tR )

   rv= where( ii ge 0 or ii lt m )
   iirv= ii(rv)

   result= make_array( size=size( v3 ), value=1e31 )
   
   result(0,rv)= v3(0,rv)*R(0,0,iirv)+v3(1,rv)*R(0,1,iirv)+v3(2,rv)*R(0,2,iirv)
   result(1,rv)= v3(0,rv)*R(1,0,iirv)+v3(1,rv)*R(1,1,iirv)+v3(2,rv)*R(1,2,iirv)
   result(2,rv)= v3(0,rv)*R(2,0,iirv)+v3(1,rv)*R(2,1,iirv)+v3(2,rv)*R(2,2,iirv)
   
   return, result
end


