pro scratch_pad_define_types

common scratch_pad_control, types
;  types is (3,*)  0 is button label. 1 is internal id.  2 is data needed
;     HME= Hydra ele moments 

types= $
  [ ['Plasma Frequency from Hydra mome density', 'omega_pe(n)', 'HME'], $
    ['Pressure from Hydra HRKP', 'P_HRKP(n,T)', 'HHRKP'], $
    ['Average Pressure from Hydra HRKP', 'avg_P_HRKP(n,t)', 'HHRKP HME' ], $
    ['Variance in Pressure from Hydra HRKP', 'delta_P_HRKP(n,t)','HHRKP HME'],$
    ['sigma P / <P>', 'dP/P HRKP(n,t)', 'HHRKP HME' ], $
    ['F_ce, Plasma Frequency from B-field magnitude', 'f_ce(Bmag)', 'HME'] ]

common scratch_efi_control, types_efi

types_efi= $
  [ [ 'efi ExB x GSM', 'ExB_x_gsm', 'EVGSM' ],  $
    [ 'efi ExB y GSM', 'ExB_y_gsm', 'EVGSM' ],  $
    [ 'efi ExB z GSM', 'ExB_z_gsm', 'EVGSM' ],  $
    [ 'efi ExB mag', 'ExB_mag', 'EVGSM' ],  $
    [ 'efi Ex GSM', 'Ex gsm', 'EVGSM' ], $
    [ 'efi Ey GSM', 'Ey gsm', 'EVGSM' ], $
    [ 'efi Ez GSM', 'Ez gsm', 'EVGSM' ], $
    [ 'efi E mag', 'E mag', 'EVGSM' ], $
    [ 'efi Ex FAC', 'Ex_FAC', 'EVGSM' ], $
    [ 'efi Ey FAC', 'Ey_FAC', 'EVGSM' ], $
    [ 'efi Ez FAC', 'Ez_FAC', 'EVGSM' ], $
    [ 'Eparl * Jparl', 'Ez_*_Jz', 'EVGSM HCUR' ], $
    [ 'E dot J', 'E dot J', 'EVGSM HCUR' ], $
    [ 'V34Raw', 'V34Raw', 'EV34GSM' ], $ 
    [ 'SCPot34', 'SCPot34', 'EV34GSM' ], $
    [ 'Decay Time', 'DecayTime', 'EVGSM HCUR' ], $
    [ 'efi Exy', 'efi_Exy', 'EXYZ56' ], $
    [ 'efi Ez', 'efi_Ez', 'EXYZ56' ], $
    [ 'efi E56', 'efi_E56', 'EXYZ56' ], $
    [ 'efi Bxy', 'efi_Bxy', 'EXYZ56' ], $
    [ 'efi Bz', 'efi_Bz', 'EXYZ56' ], $
    [ 'efi B56', 'efi_B56', 'EXYZ56' ], $
    [ 'efi UZpay', 'efi_UZPAY', 'EUZPAY' ] $
  ]

common scratch_mvc_control, types_mvc

; button, internal name, needed resources, panel title
types_mvc= $
  [ [ 'J perp x','mvc_j_perp_x','HMVC', 'J!s!d!9x!x,x!r!uMVC' ], $
    [ 'J perp y','mvc_j_perp_y','HMVC', 'J!s!d!9x!x,y!r!uMVC' ], $
    [ 'J perp z','mvc_j_perp_z','HMVC', 'J!s!d!9x!x,z!r!uMVC' ], $
    [ 'J perp theta','mvc_j_perp_theta','HMVC', '!7H!x!s!uMVC!r!dJ!i!9x' ], $
    [ 'J perp phi','mvc_j_perp_phi','HMVC', '!7U!x!s!uMVC!r!dJ!i!9x'], $
    [ 'J x','mvc_j_x','HMVC', 'J!s!uMVC!r!dx' ], $
    [ 'J y','mvc_j_y','HMVC', 'J!s!uMVC!r!dy' ], $
    [ 'J z','mvc_j_z','HMVC', 'J!s!uMVC!r!dz' ], $
    [ 'J theta','mvc_j_theta','HMVC', '!7H!x!s!uMVC!r!dJ' ], $
    [ 'J phi','mvc_j_phi','HMVC', '!7U!x!s!uMVC!r!dJ' ], $
    [ 'Bx','mvc_b_x','HMVC', 'Bx MVC' ], $
    [ 'By','mvc_b_y','HMVC', 'B y MVC' ], $
    [ 'Bz','mvc_b_z','HMVC', 'B z MVC' ], $
    [ 'Btheta','mvc_b_theta','HMVC', '!7H!x!s!uMVC!r!dB' ], $
    [ 'Bphi','mvc_b_phi','HMVC', '!7U!x!s!uMVC!r!dB' ], $
    [ '-Div*Pe_x','mvc_p-Div*Pe_x','HMVC','-!9G . !xP!de!n!9 . !x!sx!r!u^!n!u MVC' ], $
    [ '-Div*Pe_y','mvc_p-Div*Pe_y','HMVC','-!9G . !xP!de!n!9 . !x!sy!r!u^!n!u MVC' ], $
    [ '-Div*Pe_z','mvc_p-Div*Pe_z','HMVC','-!9G . !xP!de!n!9 . !x!sz!r!u^!n!u MVC' ], $
    [ '-Div*Pe_theta','mvc_p-Div*Pe_theta','HMVC','!7H!x!s!uMVC!r!d-!9G . !xP!de!n' ], $
    [ '-Div*Pe_phi','mvc_p-Div*Pe_phi','HMVC','!7U!x!s!uMVC!r!d-!9G . !xP!de!n' ], $
    [ '-Div*Pe mag', 'mvc_p-Div*Pe_mag','HMVC','!9!!!x-!9G . !xP!de!n!9!!!x' ], $
    [ 'Qx','mvc_q_x','HMVC','Q x MVC' ], $
    [ 'Qy','mvc_q_y','HMVC','Q y MVC' ], $
    [ 'Qz','mvc_q_z','HMVC','Q z MVC' ], $
    [ 'Qtheta','mvc_q_theta','HMVC','Q !7H!x!s!uMVC!r!dQ' ], $
    [ 'Qphi','mvc_q_phi','HMVC','Q !7U!x!s!uMVC!r!dQ' ], $
    [ 'U_perp_ele x','mvc_a_x','HMVC','U!s!uMVC!r!d!9x!x!Bx,e' ], $
    [ 'U_perp_ele y','mvc_a_y','HMVC','U!s!uMVC!r!d!9x!x!By,e' ], $
    [ 'U_perp_ele z','mvc_a_z','HMVC','U!s!uMVC!r!d!9x!x!Bz,e' ], $
    [ 'U_perp_ele theta','mvc_a_theta','HMVC','!7H!x!s!uMVC!r!dU!i!9x!xe' ], $
    [ 'U_perp_ele phi','mvc_a_phi','HMVC','!7U!x!s!uMVC!r!dU!i!9x!xe' ], $
    [ 'U_perp_ion x','mvc_f_x','HMVC','U!s!uMVC!r!d!9x!x!Bx,i' ], $
    [ 'U_perp_ion y','mvc_f_y','HMVC','U!s!uMVC!r!d!9x!x!By,i' ], $
    [ 'U_perp_ion z','mvc_f_z','HMVC','U!s!uMVC!r!d!9x!x!Bz,i' ], $
    [ 'U_perp_ion theta','mvc_f_theta','HMVC','!7H!x!s!uMVC!r!dU!i!9x!x,i' ], $
    [ 'U_perp_ion phi','mvc_f_phi','HMVC','!7U!x!s!uMVC!r!dU!i!9x!x,i' ], $
    [ 'Ex','mvc_e_x','HMVC','E!s!dx!r!uMVC' ], $
    [ 'Ey','mvc_e_y','HMVC','E!s!dy!r!uMVC' ], $
    [ 'Ez','mvc_e_z','HMVC','E!s!dz!r!uMVC' ], $
    [ 'Etheta','mvc_e_theta','HMVC','!7H!x!s!uMVC!r!dE' ], $
    [ 'Ephi','mvc_e_phi','HMVC','!7U!x!s!uMVC!r!dE' ], $
    [ 'u_ele x','mvc_c_x','HMVC','U!s!uMVC!r!dx,e' ], $
    [ 'u_ele y','mvc_c_y','HMVC','U!s!uMVC!r!dy,e' ], $
    [ 'u_ele z','mvc_c_z','HMVC','U!s!uMVC!r!dz,e' ], $
    [ 'u_ele theta','mvc_c_theta','HMVC','!7H!x!s!uMVC!r!dU!ie' ], $
    [ 'u_ele phi','mvc_c_phi','HMVC','!7U!x!s!uMVC!r!dU!ie' ], $
    [ 'u_ion x','mvc_d_x','HMVC','U!s!uMVC!r!dx,i' ], $
    [ 'u_ion y','mvc_d_y','HMVC','U!s!uMVC!r!dy,i' ], $
    [ 'u_ion z','mvc_d_z','HMVC','U!s!uMVC!r!dz,i' ], $
    [ 'u_ion theta','mvc_d_theta','HMVC','!7H!x!s!uMVC!r!dU!ii' ], $
    [ 'u_ion phi','mvc_d_phi','HMVC','!7U!x!s!uMVC!r!dU!ii' ], $
    [ 'vel_km_s x','vel_km_s_x','HMVC','vel_km_s x MVC' ], $
    [ 'vel_km_s y','vel_km_s_y','HMVC','vel_km_s y MVC' ], $
    [ 'vel_km_s z','vel_km_s_z','HMVC','vel_km_s z MVC' ], $
    [ 'vel_km_s theta','vel_km_s_theta','HMVC','!7H!x!s!uMVC!r!dvel' ], $
    [ 'vel_km_s phi','vel_km_s_phi','HMVC','!7U!x!s!uMVC!r!dvel' ], $
    [ 'vel_km_s angle_to_x','vel_km_s_ang3','HMVC','!7W!x' ], $
    [ 'traj_Re x','traj_Re_x','HMVC','X!s!uMVC!r!dS/C' ], $
    [ 'traj_Re y','traj_Re_y','HMVC','traj_Re y MVC' ], $
    [ 'traj_Re z','traj_Re_z','HMVC','traj_Re z MVC' ], $
    [ 'traj_Re theta','traj_Re_theta','HMVC','traj_Re !7H!x!s!uMVC!r' ], $
    [ 'traj_Re phi','traj_Re_phi','HMVC','traj_Re !7U!x!s!uMVC!r' ] $
  ]

common scratch_nif_control, types_nif

; button, internal name, needed resources, panel title
types_nif= $
  [ [ 'J perp x','nif_j_perp_x','HNIF', 'J!s!d!9x!x,x!r!uNIF' ], $
    [ 'J perp y','nif_j_perp_y','HNIF', 'J!s!d!9x!x,y!r!uNIF' ], $
    [ 'J perp z','nif_j_perp_z','HNIF', 'J!s!d!9x!x,z!r!uNIF' ], $
    [ 'J perp theta','nif_j_perp_theta','HNIF', '!7H!x!s!uNIF!r!dJ!i!9x' ], $
    [ 'J perp phi','nif_j_perp_phi','HNIF', '!7U!x!s!uNIF!r!dJ!i!9x'], $
    [ 'J x','nif_j_x','HNIF', 'J!s!uNIF!r!dx' ], $
    [ 'J y','nif_j_y','HNIF', 'J!s!uNIF!r!dy' ], $
    [ 'J z','nif_j_z','HNIF', 'J!s!uNIF!r!dz' ], $
    [ 'J theta','nif_j_theta','HNIF', '!7H!x!s!uNIF!r!dJ' ], $
    [ 'J phi','nif_j_phi','HNIF', '!7U!x!s!uNIF!r!dJ' ], $
    [ 'Bx','nif_b_x','HNIF', 'Bx NIF' ], $
    [ 'By','nif_b_y','HNIF', 'B y NIF' ], $
    [ 'Bz','nif_b_z','HNIF', 'B z NIF' ], $
    [ 'Btheta','nif_b_theta','HNIF', '!7H!x!s!uNIF!r!dB' ], $
    [ 'Bphi','nif_b_phi','HNIF', '!7U!x!s!uNIF!r!dB' ], $
    [ '-Div*Pe_x','nif_p-Div*Pe_x','HNIF','-!9G . !xP!de!n!9 . !x!sx!r!u^!n!u NIF' ], $
    [ '-Div*Pe_y','nif_p-Div*Pe_y','HNIF','-!9G . !xP!de!n!9 . !x!sy!r!u^!n!u NIF' ], $
    [ '-Div*Pe_z','nif_p-Div*Pe_z','HNIF','-!9G . !xP!de!n!9 . !x!sz!r!u^!n!u NIF' ], $
    [ '-Div*Pe_theta','nif_p-Div*Pe_theta','HNIF','!7H!x!s!uNIF!r!d-!9G . !xP!de!n' ], $
    [ '-Div*Pe_phi','nif_p-Div*Pe_phi','HNIF','!7U!x!s!uNIF!r!d-!9G . !xP!de!n' ], $
    [ '-Div*Pe mag', 'nif_p-Div*Pe_mag','HNIF','!9!!!x-!9G . !xP!de!n!9!!!x' ], $
    [ 'Qx','nif_q_x','HNIF','Q x NIF' ], $
    [ 'Qy','nif_q_y','HNIF','Q y NIF' ], $
    [ 'Qz','nif_q_z','HNIF','Q z NIF' ], $
    [ 'Qtheta','nif_q_theta','HNIF','Q !7H!x!s!uNIF!r!dQ' ], $
    [ 'Qphi','nif_q_phi','HNIF','Q !7U!x!s!uNIF!r!dQ' ], $
    [ 'U_perp_ele x','nif_a_x','HNIF','U!s!uNIF!r!d!9x!x!Bx,e' ], $
    [ 'U_perp_ele y','nif_a_y','HNIF','U!s!uNIF!r!d!9x!x!By,e' ], $
    [ 'U_perp_ele z','nif_a_z','HNIF','U!s!uNIF!r!d!9x!x!Bz,e' ], $
    [ 'U_perp_ele theta','nif_a_theta','HNIF','!7H!x!s!uNIF!r!dU!i!9x!xe' ], $
    [ 'U_perp_ele phi','nif_a_phi','HNIF','!7U!x!s!uNIF!r!dU!i!9x!xe' ], $
    [ 'U_perp_ion x','nif_f_x','HNIF','U!s!uNIF!r!d!9x!x!Bx,i' ], $
    [ 'U_perp_ion y','nif_f_y','HNIF','U!s!uNIF!r!d!9x!x!By,i' ], $
    [ 'U_perp_ion z','nif_f_z','HNIF','U!s!uNIF!r!d!9x!x!Bz,i' ], $
    [ 'U_perp_ion theta','nif_f_theta','HNIF','!7H!x!s!uNIF!r!dU!i!9x!x,i' ], $
    [ 'U_perp_ion phi','nif_f_phi','HNIF','!7U!x!s!uNIF!r!dU!i!9x!x,i' ], $
    [ 'Ex','nif_e_x','HNIF','E!s!dx!r!uNIF' ], $
    [ 'Ey','nif_e_y','HNIF','E!s!dy!r!uNIF' ], $
    [ 'Ez','nif_e_z','HNIF','E!s!dz!r!uNIF' ], $
    [ 'Etheta','nif_e_theta','HNIF','!7H!x!s!uNIF!r!dE' ], $
    [ 'Ephi','nif_e_phi','HNIF','!7U!x!s!uNIF!r!dE' ], $
    [ 'u_ele x','nif_c_x','HNIF','U!s!uNIF!r!dx,e' ], $
    [ 'u_ele y','nif_c_y','HNIF','U!s!uNIF!r!dy,e' ], $
    [ 'u_ele z','nif_c_z','HNIF','U!s!uNIF!r!dz,e' ], $
    [ 'u_ele theta','nif_c_theta','HNIF','!7H!x!s!uNIF!r!dU!ie' ], $
    [ 'u_ele phi','nif_c_phi','HNIF','!7U!x!s!uNIF!r!dU!ie' ], $
    [ 'u_ion x','nif_d_x','HNIF','U!s!uNIF!r!dx,i' ], $
    [ 'u_ion y','nif_d_y','HNIF','U!s!uNIF!r!dy,i' ], $
    [ 'u_ion z','nif_d_z','HNIF','U!s!uNIF!r!dz,i' ], $
    [ 'u_ion theta','nif_d_theta','HNIF','!7H!x!s!uNIF!r!dU!ii' ], $
    [ 'u_ion phi','nif_d_phi','HNIF','!7U!x!s!uNIF!r!dU!ii' ], $
    [ 'vel_km_s x','vel_km_s_x','HNIF','vel_km_s x NIF' ], $
    [ 'vel_km_s y','vel_km_s_y','HNIF','vel_km_s y NIF' ], $
    [ 'vel_km_s z','vel_km_s_z','HNIF','vel_km_s z NIF' ], $
    [ 'vel_km_s theta','vel_km_s_theta','HNIF','!7H!x!s!uNIF!r!dvel' ], $
    [ 'vel_km_s phi','vel_km_s_phi','HNIF','!7U!x!s!uNIF!r!dvel' ], $
    [ 'vel_km_s angle_to_x','vel_km_s_ang3','HNIF','!7W!x' ], $
    [ 'traj_Re x','traj_Re_x','HNIF','X!s!uNIF!r!dS/C' ], $
    [ 'traj_Re y','traj_Re_y','HNIF','traj_Re y NIF' ], $
    [ 'traj_Re z','traj_Re_z','HNIF','traj_Re z NIF' ], $
    [ 'traj_Re theta','traj_Re_theta','HNIF','traj_Re !7H!x!s!uNIF!r' ], $
    [ 'traj_Re phi','traj_Re_phi','HNIF','traj_Re !7U!x!s!uNIF!r' ] $
  ]

return
end
