function sp_synchronize_1, A_time_1, A_time_2, $
                          B_time, B_data, variance=variance
; syncronizes two data sets taken at different times.  
;   measurements from B are returned to corresponding time buckets
;   in A.  Multiple measurements are averaged together, and the
;   variance is also available.

 avg= make_array( value=1e31, size=size( A_time_1 ) )
 var= make_array( value=1e31, size=size( A_time_1 ) )

 for i=0,n_elements(A_time_1)-1 do begin
     r= where( A_time_1(i) le B_time and B_time lt A_time_2(i), count )
     if count gt 0 then begin
         avg(i)= total( B_data(r) ) / count
         if count gt 1 then begin
             var(i)= sqrt( total( ( b_data(r)-avg(i) )^2 ) ) / ( count-1 )
         endif
     endif
 endfor
 
 variance= var
 return, avg
end

