pro delta_p, time_range=time_range, idlsav=idlsav
; time_range specified in seconds since midnight, 5/29/96.

;   r= convert_timetoseconds( '5/29/96 0:00', /t90 )
;   xut1= r.value
   if n_elements( time_range ) ne 2 then time_range= [ 0,86400 ]

   xut1= time_range(0)+202176000 ; 5/29/96 0:00 in papco's t90 format
   xut2= time_range(1)+202176000
   dxut= xut2-xut1

   r_scratch_pad, 'HHRKP', [0,0,0], xut1, xut2
   common hydra_kp_data, $
     kp_species, $
     kp_header, $
     kp_lr_ele_data, $
     kp_lr_ele_attr, $
     kp_lr_ion_data, $
     kp_lr_ion_attr, $
     kp_hr_ele_data, $
     kp_hr_ele_attr

   time= ( kp_header(kp_species).start_time - xut1 ) + $
     kp_hr_ele_data.time        ; seconds since xut1
   kT= kp_hr_ele_data.mean_energy
   n= kp_hr_ele_data.density
   P= n * kT * 1e-12

   del_P= ( P(1:*) - P ) / P
   del_n= ( n(1:*) - n ) / n
   del_kT= ( kT(1:*) - kT ) / kT

;  filter all differences where time jump is gt adjacent measurements.
   r= where( time(1:*) - time ge 2.40 ) ; 2.30 + a little for error
   if r(0) ne -1 then begin
       del_P(r)= 1e31
       del_n(r)= 1e31
       del_kT(r)= 1e31
   endif

   time= time(0:(n_elements(del_kT)-1)) + 1.15
   
   if keyword_set(idlsav) then begin
       delta= { time:time, del_P:del_P, del_n:del_n, del_kT:del_kT }
       save, file=idlsav, delta
       return
   end

   r= where(0 le time  and  time le (dxut) )

   del_P= del_P(r)
   del_n= del_n(r)
   del_kT= del_kT(r)
   time=time(r)

   zrange=[0,dxut]

   !p.multi=[0,1,3]
   !x.omargin=[10,30]
   hydra_colorhist, time, del_P, /fill, min=-1, max=3, binsize=0.01, $
     ytitle='f(!7d!xP)', xtitle='!7d!xP', zrange=zrange, yrange=[0.1,300], $
     /ylog
   hydra_color_bar, zrange=(zrange+time_range(0))/3600., ytitle='UT 5/29/96'
   hydra_colorhist, time, del_n, /fill, min=-1, max=3, binsize=0.01, $
     ytitle='f(!7d!xn)', xtitle='!7d!xn', zrange=zrange, yrange=[0.1,300], $
     /ylog
   hydra_color_bar, zrange=(zrange+time_range(0))/3600., ytitle='UT 5/29/96'
   hydra_colorhist, time, del_kT, /fill, min=-1, max=3, binsize=0.01, $
     ytitle='f(!7d!xkT)', xtitle='!7d!xkT', zrange=zrange, yrange=[0.1,300], $
     /ylog
   hydra_color_bar, zrange=(zrange+time_range(0))/3600., ytitle='UT 5/29/96'
end

