PRO cpa_calibration, satid, electrons


cpa_calibration_fcf=fltarr(12)


case satid of
  '1976-059': begin
      ; "LOE"
      cpa_calibration_fcf(0) =  1.
      cpa_calibration_fcf(1) =  1.
      cpa_calibration_fcf(2) =  1.3
      cpa_calibration_fcf(3) =  0.94
      cpa_calibration_fcf(4) =  0.94
      cpa_calibration_fcf(5) =  0.8

      ; "HiE" 
      cpa_calibration_fcf(6) =  0.8
      cpa_calibration_fcf(7) =  0.77
      cpa_calibration_fcf(8) =  0.74
      cpa_calibration_fcf(9) =  0.70
      cpa_calibration_fcf(10) = 0.65
      cpa_calibration_fcf(11) = 1.
   END
  '1977-007': begin
      ; "LOE"
      cpa_calibration_fcf(0) =  1.
      cpa_calibration_fcf(1) =  1.
      cpa_calibration_fcf(2) =  0.99
      cpa_calibration_fcf(3) =  0.90
      cpa_calibration_fcf(4) =  0.86
      cpa_calibration_fcf(5) =  0.64

      ; "HiE" 
      cpa_calibration_fcf(6) =  0.64
      cpa_calibration_fcf(7) =  0.55
      cpa_calibration_fcf(8) =  0.42
      cpa_calibration_fcf(9) =  0.37
      cpa_calibration_fcf(10) = 0.35
      cpa_calibration_fcf(11) = 1.
   END
  '1979-053': begin
      ; "LOE"
      cpa_calibration_fcf(0) =  1.
      cpa_calibration_fcf(1) =  1.
      cpa_calibration_fcf(2) =  1.
      cpa_calibration_fcf(3) =  1.
      cpa_calibration_fcf(4) =  1.
      cpa_calibration_fcf(5) =  1.

      ; "HiE" 
      cpa_calibration_fcf(6) =  1.
      cpa_calibration_fcf(7) =  0.37
      cpa_calibration_fcf(8) =  0.34
      cpa_calibration_fcf(9) =  0.29
      cpa_calibration_fcf(10) = 0.22
      cpa_calibration_fcf(11) = 1.
  END
  '1981-025': begin
      ; "LOE"
      cpa_calibration_fcf(0) =  1.
      cpa_calibration_fcf(1) =  1.
      cpa_calibration_fcf(2) =  0.99
      cpa_calibration_fcf(3) =  0.72
      cpa_calibration_fcf(4) =  0.73
      cpa_calibration_fcf(5) =  0.62

      ; "HiE" 
      cpa_calibration_fcf(6) =  0.62
      cpa_calibration_fcf(7) =  0.52
      cpa_calibration_fcf(8) =  0.41
      cpa_calibration_fcf(9) =  0.37
      cpa_calibration_fcf(10) = 0.27
      cpa_calibration_fcf(11) = 1.
  END
  '1982-019': begin
      ; "LOE"
      cpa_calibration_fcf(0) =  1.
      cpa_calibration_fcf(1) =  1
      cpa_calibration_fcf(2) =  1.15
      cpa_calibration_fcf(3) =  0.93
      cpa_calibration_fcf(4) =  1.08
      cpa_calibration_fcf(5) =  1.29

      ; "HiE" 
      cpa_calibration_fcf(6) =  1.29
      cpa_calibration_fcf(7) =  1.28
      cpa_calibration_fcf(8) =  1.2
      cpa_calibration_fcf(9) =  1.09
      cpa_calibration_fcf(10) = 1.13
      cpa_calibration_fcf(11) = 1.
  END
  '1984-037': begin
      ; "LOE"
      cpa_calibration_fcf(0) =  1.
      cpa_calibration_fcf(1) =  1.
      cpa_calibration_fcf(2) =  1.73
      cpa_calibration_fcf(3) =  1.31
      cpa_calibration_fcf(4) =  1.3
      cpa_calibration_fcf(5) =  1.15

      ; "HiE" 
      cpa_calibration_fcf(6) =  1.15
      cpa_calibration_fcf(7) =  1.06
      cpa_calibration_fcf(8) =  0.89
      cpa_calibration_fcf(9) =  0.87
      cpa_calibration_fcf(10) = 0.92
      cpa_calibration_fcf(11) = 1.
  END
  '1984-129': begin
      ; "LOE"
      cpa_calibration_fcf(0) =  1.
      cpa_calibration_fcf(1) =  1.
      cpa_calibration_fcf(2) =  1.
      cpa_calibration_fcf(3) =  1.
      cpa_calibration_fcf(4) =  1.
      cpa_calibration_fcf(5) =  1.

      ; "HiE" 
      cpa_calibration_fcf(6) =  1.
      cpa_calibration_fcf(7) =  1.
      cpa_calibration_fcf(8) =  1.
      cpa_calibration_fcf(9) =  1.
      cpa_calibration_fcf(10) = 1.
      cpa_calibration_fcf(11) = 1.
  END
  '1987-097': begin
      ; "LOE"
      cpa_calibration_fcf(0) =  1.
      cpa_calibration_fcf(1) =  1.
      cpa_calibration_fcf(2) =  1.26
      cpa_calibration_fcf(3) =  1.17
      cpa_calibration_fcf(4) =  1.23
      cpa_calibration_fcf(5) =  1.03

      ; "HiE" 
      cpa_calibration_fcf(6) =  1.03
      cpa_calibration_fcf(7) =  0.96
      cpa_calibration_fcf(8) =  0.9
      cpa_calibration_fcf(9) =  0.9
      cpa_calibration_fcf(10) = 0.92
      cpa_calibration_fcf(11) = 1.
   END 
  ELSE: print,'no intercalibration available'     
ENDCASE

; Electrons
for i = 0,11 do begin
	electrons(i,*) = electrons(i,*)*cpa_calibration_fcf(i)
endfor

end
      
      
      
      
      
      
      
      
      
      
      
      
