PRO sopa_calibration, satid, electrons


sopa_calibration_fcf=fltarr(10)


case satid of
  '1989-046': begin
        sopa_calibration_fcf(0) = 0.695
        sopa_calibration_fcf(1) = 0.518
        sopa_calibration_fcf(2) = 0.693
        sopa_calibration_fcf(3) = 0.648
        sopa_calibration_fcf(4) = 0.641
        sopa_calibration_fcf(5) = 0.742
        sopa_calibration_fcf(6) = 0.396
        sopa_calibration_fcf(7) = 0.374
        sopa_calibration_fcf(8) = 0.3
        sopa_calibration_fcf(9) = 1.
	end
  '1990-095': begin
        sopa_calibration_fcf(0) = 0.512
        sopa_calibration_fcf(1) = 0.869
        sopa_calibration_fcf(2) = 0.909
        sopa_calibration_fcf(3) = 0.924
        sopa_calibration_fcf(4) = 1.081
        sopa_calibration_fcf(5) = 0.611
        sopa_calibration_fcf(6) = 0.507
        sopa_calibration_fcf(7) = 0.467
        sopa_calibration_fcf(8) = 0.399
        sopa_calibration_fcf(9) = 1.
	end
  '1991-080': begin
        sopa_calibration_fcf(0) = 0.343
        sopa_calibration_fcf(1) = 0.753
        sopa_calibration_fcf(2) = 0.879
        sopa_calibration_fcf(3) = 0.757
        sopa_calibration_fcf(4) = 0.879
        sopa_calibration_fcf(5) = 0.674
        sopa_calibration_fcf(6) = 0.435
        sopa_calibration_fcf(7) = 0.368
        sopa_calibration_fcf(8) = 0.357
        sopa_calibration_fcf(9) = 1.
	end
  '1994-084': begin
        sopa_calibration_fcf(0) = 0.772
        sopa_calibration_fcf(1) = 1.652
        sopa_calibration_fcf(2) = 1.292
        sopa_calibration_fcf(3) = 0.984
        sopa_calibration_fcf(4) = 0.945
        sopa_calibration_fcf(5) = 0.864
        sopa_calibration_fcf(6) = 0.567
        sopa_calibration_fcf(7) = 0.475
        sopa_calibration_fcf(8) = 0.5
        sopa_calibration_fcf(9) = 1.
	end
  'LANL-97A': begin
        sopa_calibration_fcf(0) = 0.858
        sopa_calibration_fcf(1) = 4.034
        sopa_calibration_fcf(2) = 2.755
        sopa_calibration_fcf(3) = 2.045
        sopa_calibration_fcf(4) = 1.943
        sopa_calibration_fcf(5) = 1.233
        sopa_calibration_fcf(6) = 0.808
        sopa_calibration_fcf(7) = 0.573
        sopa_calibration_fcf(8) = 0.56
        sopa_calibration_fcf(9) = 1.
	end
    ELSE: begin
        message, 'no intercalibration available', /cont
        sopa_calibration_fcf(0) = 1.
        sopa_calibration_fcf(1) = 1.
        sopa_calibration_fcf(2) = 1.
        sopa_calibration_fcf(3) = 1.
        sopa_calibration_fcf(4) = 1.
        sopa_calibration_fcf(5) = 1.
        sopa_calibration_fcf(6) = 1.
        sopa_calibration_fcf(7) = 1.
        sopa_calibration_fcf(8) = 1.
        sopa_calibration_fcf(9) = 1.
        end
       
endcase

; Electrons
for i = 0,9 do begin
	electrons(i,*) = electrons(i,*)*sopa_calibration_fcf(i)
endfor

end
