; This program converts differential SOPA channels from counts to flux.
; The units of flux are particles/cm^2/sec/sr/keV.
; The programs sopa_read.pro should be run before runing this program. 
;
; Input
;	satid     = international satellite designator number
;	electrons = differential electron counts/second
;	protons   = differential proton counts/second
;
; Output
;	electrons = differential electron flux (particles/cm^2/sec/sr/keV)
;	protons   = differential proton flux (particles/cm^2/sec/sr/keV)
;
;=======================================================================
; Geoff Reeves
; 95/08/17
;=============

PRO sopa_diff_counts_to_flux, satid, electrons, protons

;--------------------------------------------------
; For SOPA the "nominal" energy thresholds for each 
; SOPA are the same but the conversion factors 
; for each SOPA are different.
;
; Flux conversion factors used here were provided
; by Rod Christensen August 1995. 
;
; The FCFs were for counts/interval. The counting
; interval is 160 ms. To get counts/second the
; FCFs must be multiplied by 0.160 sec/interval
;--------------------------------------------------


case satid of
  '1989-046': begin
	electrons(0,*) = electrons(0,*) * 0.160 * 1095.0	
	electrons(1,*) = electrons(1,*) * 0.160 * 522.0	
	electrons(2,*) = electrons(2,*) * 0.160 * 237.0	
	electrons(3,*) = electrons(3,*) * 0.160 * 144.0	
	electrons(4,*) = electrons(4,*) * 0.160 * 101.0	
	electrons(5,*) = electrons(5,*) * 0.160 * 51.10	
	electrons(6,*) = electrons(6,*) * 0.160 * 40.00	
	electrons(7,*) = electrons(7,*) * 0.160 * 24.20	
	electrons(8,*) = electrons(8,*) * 0.160 * 21.00	
	electrons(9,*) = electrons(9,*) * 0.160 * 9438.0	
	protons(0,*)   = protons(0,*)   * 0.160 * 479.0	
	protons(1,*)   = protons(1,*)   * 0.160 * 320.0	
	protons(2,*)   = protons(2,*)   * 0.160 * 170.0	
	protons(3,*)   = protons(3,*)   * 0.160 * 108.0	
	protons(4,*)   = protons(4,*)   * 0.160 * 59.30	
	protons(5,*)   = protons(5,*)   * 0.160 * 27.70	
	protons(6,*)   = protons(6,*)   * 0.160 * 13.00	
	protons(7,*)   = protons(7,*)   * 0.160 * 11.40	
	protons(8,*)   = protons(8,*)   * 0.160 * 6.260	
	protons(9,*)   = protons(9,*)   * 0.160 * 3.990	
	protons(10,*)  = protons(10,*)  * 0.160 * 2.81	
	protons(11,*)  = protons(11,*)  * 0.160 * 0.179	
	end
  '1990-095': begin
	electrons(0,*) = electrons(0,*) * 0.160 * 1919.0	
	electrons(1,*) = electrons(1,*) * 0.160 * 470.0	
	electrons(2,*) = electrons(2,*) * 0.160 * 235.0	
	electrons(3,*) = electrons(3,*) * 0.160 * 153.0	
	electrons(4,*) = electrons(4,*) * 0.160 * 78.8	
	electrons(5,*) = electrons(5,*) * 0.160 * 62.5	
	electrons(6,*) = electrons(6,*) * 0.160 * 34.1	
	electrons(7,*) = electrons(7,*) * 0.160 * 24.5	
	electrons(8,*) = electrons(8,*) * 0.160 * 16.5	
	electrons(9,*) = electrons(9,*) * 0.160 * 8661.0	
	protons(0,*)   = protons(0,*)   * 0.160 * 685.0	
	protons(1,*)   = protons(1,*)   * 0.160 * 235.0	
	protons(2,*)   = protons(2,*)   * 0.160 * 135.0	
	protons(3,*)   = protons(3,*)   * 0.160 * 89.9	
	protons(4,*)   = protons(4,*)   * 0.160 * 53.3	
	protons(5,*)   = protons(5,*)   * 0.160 * 26.4	
	protons(6,*)   = protons(6,*)   * 0.160 * 12.9	
	protons(7,*)   = protons(7,*)   * 0.160 * 13.5	
	protons(8,*)   = protons(8,*)   * 0.160 * 7.36	
	protons(9,*)   = protons(9,*)   * 0.160 * 4.31	
	protons(10,*)  = protons(10,*)  * 0.160 * 2.50	
	protons(11,*)  = protons(11,*)  * 0.160 * 0.302	
	end
  '1991-080': begin
	electrons(0,*) = electrons(0,*) * 0.160 * 2631.0
	electrons(1,*) = electrons(1,*) * 0.160 * 508.0	
	electrons(2,*) = electrons(2,*) * 0.160 * 297.0	
	electrons(3,*) = electrons(3,*) * 0.160 * 178.0	
	electrons(4,*) = electrons(4,*) * 0.160 * 104.0	
	electrons(5,*) = electrons(5,*) * 0.160 * 68.40	
	electrons(6,*) = electrons(6,*) * 0.160 * 44.60	
	electrons(7,*) = electrons(7,*) * 0.160 * 30.00	
	electrons(8,*) = electrons(8,*) * 0.160 * 24.30	
	electrons(9,*) = electrons(9,*) * 0.160 * 11340.0
	protons(0,*)   = protons(0,*)   * 0.160 * 439.0	
	protons(1,*)   = protons(1,*)   * 0.160 * 253.0	
	protons(2,*)   = protons(2,*)   * 0.160 * 162.0	
	protons(3,*)   = protons(3,*)   * 0.160 * 108.0	
	protons(4,*)   = protons(4,*)   * 0.160 * 61.80	
	protons(5,*)   = protons(5,*)   * 0.160 * 26.10	
	protons(6,*)   = protons(6,*)   * 0.160 * 12.70	
	protons(7,*)   = protons(7,*)   * 0.160 * 11.20	
	protons(8,*)   = protons(8,*)   * 0.160 * 7.240	
	protons(9,*)   = protons(9,*)   * 0.160 * 3.740	
	protons(10,*)  = protons(10,*)  * 0.160 * 3.980	
	protons(11,*)  = protons(11,*)  * 0.160 * 0.304	
	end
  '1994-084': begin
	electrons(0,*) = electrons(0,*) * 0.160 * 1428.0
	electrons(1,*) = electrons(1,*) * 0.160 * 234.0
	electrons(2,*) = electrons(2,*) * 0.160 * 194.0
	electrons(3,*) = electrons(3,*) * 0.160 * 134.0
	electrons(4,*) = electrons(4,*) * 0.160 * 103.0
	electrons(5,*) = electrons(5,*) * 0.160 * 51.0
	electrons(6,*) = electrons(6,*) * 0.160 * 37.00
	electrons(7,*) = electrons(7,*) * 0.160 * 25.00
	electrons(8,*) = electrons(8,*) * 0.160 * 18.00
	electrons(9,*) = electrons(9,*) * 0.160 * 25.8
	protons(0,*)   = protons(0,*)   * 0.160 * 350.0
	protons(1,*)   = protons(1,*)   * 0.160 * 188.0
	protons(2,*)   = protons(2,*)   * 0.160 * 128.0
	protons(3,*)   = protons(3,*)   * 0.160 * 110.0
	protons(4,*)   = protons(4,*)   * 0.160 * 62.00
	protons(5,*)   = protons(5,*)   * 0.160 * 25.00
	protons(6,*)   = protons(6,*)   * 0.160 * 16.00
	protons(7,*)   = protons(7,*)   * 0.160 * 17.00
	protons(8,*)   = protons(8,*)   * 0.160 * 9.000
	protons(9,*)   = protons(9,*)   * 0.160 * 5.200
	protons(10,*)  = protons(10,*)  * 0.160 * 3.000
	protons(11,*)  = protons(11,*)  * 0.160 * 0.366
	end
  'LANL-97A': begin
	electrons(0,*) = electrons(0,*) * 204.808
	electrons(1,*) = electrons(1,*) * 17.2807
	electrons(2,*) = electrons(2,*) * 15.3281
	electrons(3,*) = electrons(3,*) * 10.2724
	electrons(4,*) = electrons(4,*) * 7.82417
	electrons(5,*) = electrons(5,*) * 6.08006
	electrons(6,*) = electrons(6,*) * 3.53601
	electrons(7,*) = electrons(7,*) * 3.04003
	electrons(8,*) = electrons(8,*) * 2.32005
	electrons(9,*) = electrons(9,*) * 4.128    ;not sure
	protons(0,*)   = protons(0,*)   * 56.
	protons(1,*)   = protons(1,*)   * 37.7612
	protons(2,*)   = protons(2,*)   * 20.7991
	protons(3,*)   = protons(3,*)   * 15.2966
	protons(4,*)   = protons(4,*)   * 7.90385
	protons(5,*)   = protons(5,*)   * 3.29595
	protons(6,*)   = protons(6,*)   * 1.88802
	protons(7,*)   = protons(7,*)   * 1.58555
	protons(8,*)   = protons(8,*)   * 0.913578
	protons(9,*)   = protons(9,*)   * 0.526378
	protons(10,*)  = protons(10,*)  * 0.398408
	protons(11,*)  = protons(11,*)  * 0.0240005
	end
   else: print,'no calibration available'
endcase

end
