;******************************************************************************
;* PROCEDURE:     
;*      PRO lanl_geo_commons
;* 
;* DESCRIPTION:  
;*      simply sets up a couple of often used arrays in common blocks.
;*
;* INPUTS:       
;*      none
;*                  
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      lanl_geo_set_commons
;******************************************************************************
PRO lanl_geo_commons
  
COMMON lanl_geo, sat_names, select_names, select_frmts, lanl_geo_control
  
sat_names=['1976-059','1977-007','1979-053','1981-025','1982-019','1984-037', $
           '1984-129','1987-097','1989-046','1990-095','1991-080','1994-084', $
           'LANL-97A','LANL-01A','LANL-02A']

;enter variables for filtering the data
select_names = ['L', 'L_STAR', 'MLT', 'MLAT']
select_frmts = ['(f4.1)', '(f4.1)', '(f4.1)', '(f5.1)']

lanl_geo_control = { $
  sc_id:0,     sc_id_info:'Index into sat_names, Geo Satellite ID', $
  type:0,      type_info:'0: SOPA/CPA/ESP, 1: MPA/SOPA/CPA/ESP Merged', $
  graph:0,     graph_info:'0: Line, 1: Spec, 2: McIlwain', $
  cal:0,       cal_info:'0: counts, 1: flux, 2: PSD @ const. mu', $
  mu:'',       mu_info:'String of comma seperated mu, (keV/nT)', $
  res:0,       res_info:'0: 10 sec, 1: 60 sec, 2: 5 min, 3: 10 min, '+ $
                        '4: 60 min, 5: 1 day', $
  pa_res:'10',   pa_res_info: 'PA bin size (deg)', $
  pl_type:0,    pl_type_info:'0: spin averaged, 1: All PA @ 1 E, 2: All E @ 1 PA,'+ $
                             '3: All PA for E range, 4: All E for PA range,'+ $
                             '5: Anisotropy spec, 6: PA @ E range, 7: Anisotropy LP', $
  det_choice:2ll, det_choice_info:'Bitwise toggle for telescopes', $
  pa_bin1:0.0,  pa1_info:'PITCH ANGLE BIN start',$
  pa_bin2:0.0, pa2_info:'PITCH ANGLE BIN stop',$
  ek1:1ll,     prod1_info:'Bitwise toggle for energy channel 1', $
  ek2:0ll,     prod2_info:'Bitwise toggle for energy channel 2', $
  filter:0,    filter_info:'Index into select_names filter variable to use'  }
 
;now get the papco_panel tags for the papco_panel_Add_MagMod_Widgets
;tags, add them to lanl_gps_control
lanl_geo_control = CREATE_STRUCT(lanl_geo_control, $
                       papco_panel_Add_MagMod_Widgets(/STRUCT_ONLY))

;now get the papco panel tags for the various select variables.
FOR i = 0, n_elements(select_names)-1 DO $
  lanl_geo_control = CREATE_STRUCT(lanl_geo_control, $
                 papco_panel_AddVar_Sel_Widgets(aBase, select_names(i), $
                                                select, st, en, v1, v2, vr, $
                                                select_frmts(i), /STRUCT_ONLY))

;finally name the control structure. This is required for load/save operations!
lanl_geo_control = CREATE_STRUCT(name = 'lanl_geo_control', lanl_geo_control)

END   
