;******************************************************************************
;* file papcoadd_lanl_geo
;*      papcoadd_lanl_geo
;*
;* end
;*
;* this files contains all the collected routines which have to be added in
;* for lanl_geo. 
;*
;*    Those procedures are contained:
;*
;*    PRO addplottype_lanl_geo,plottypes_base,pb_plottype
;*        ->  adds the button for the new plot type to the main window.
;*
;*    PRO plottable_lanl_geo, plottable
;*        -> Sets a variable to indicate plottable without orbit.
;*
;*    PRO descriptor_lanl_geo, plotInfo, descriptStr
;*        -> Constructs the string used to label plots in the panels window
;*
;*    PRO addpanel_lanl_geo
;*        -> Calls the panel editor for this plottype and adds the plot to the
;*            panel window.
;*
;*    PRO editor_lanl_geo, plotNumber, newPlotData
;*        -> This procedure calls the panel editor when called from 
;*	     PAPCO_EditPlot (papco_paneledit.pro).
;*
;*    PRO  draw_lanl_geo, panelVector, currPlotInfo, get_data_call, IsRead
;*        -> This procedure doe the actual data read call and the plot call
;*           for this plottype
;******************************************************************************

;******************************************************************************
;* PROCEDURE:     
;*      PRO addplottype_lanl_geo,plottypes_base,buttonGeometry,pb_plottype
;* 
;* DESCRIPTION:  
;*	This procedure adds a button for this plottype to the plottypes_base.
;*      The UVALUE declared here is critical, since it is used to construct
;*      the procedure names of all procedures contained in this add-in
;*	papckage, so that they can be automatically called when needed.
;*
;* INPUTS:       
;*	plottypes_base	the widget ID of the parent widget to contain the
;*			plottype buttons.
;*
;* OUTPUTS: 
;*   	pb_plottype	the widget ID of the button created here.
;*      buttonGeometry  size of the button. Only used in simple
;*                      WIDGET_BUTTON to make them the same size as the
;*                      compound CW_PDMENU, pulldown for subtypes.
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	addplottype_lanl_geo,plottypes_base,buttonGeometry,pb_plottype
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;*          modified July 2003, Arne Aasnes at LANL 
;*            included panel for plotting pitch angles
;***************************************************************************
pro addplottype_lanl_geo, plottypes_base, buttonGeometry, pdm_lanl_geo

; VALUE assigns a label for the button
; The lanl_geo portion of UVALUE is used to construct the calls to all
; other procedures in this add-in needed by PAPCO.

  MenuDesc = [ $
        { CW_PDMENU_S,   3, strcenter('LANL GEO EP',12) }, $ 
        { CW_PDMENU_S, 0, ' Configure Module' }, $
        { CW_PDMENU_S, 0, ' LANL-GEO     ' }]

  pdm_lanl_geo = CW_PDMENU(plottypes_base, MenuDesc, $
                  UVALUE='pdm_lanl_geo')
 
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO plottable_lanl_geo, plottable
;*
;* DESCRIPTION:  
;*	Sets a variable to indicate plottable without orbit.
;*
;* INPUTS:       
;*	none
;*
;* OUTPUTS: 
;*   	plottable	a boolean 0 if plottable only by orbit
;*                                1 if plottable by time also.
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	plottable_lanl_geo, plottable
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro plottable_lanl_geo, plottable

   plottable=1

END



;******************************************************************************
;* PROCEDURE:     
;*      PRO canget_lanl_geo, canget
;*
;* DESCRIPTION:  
;*      Sets a variable to indicate that lanl_geo support the OUTPUT
;*      functionality. 
;*      
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "canget_" plus
;*      the panel_kind you have set for your submenu entry in 
;*      addpanel_lanl_geo.
;*
;* INPUTS:       
;*      none
;*
;* OUTPUTS: 
;*      canget         a boolean 0 if this feature is not available
;*                               1 if this feature is available
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      canget_lanl_geo, canget
;******************************************************************************
pro canget_lanl_geo, canget

  canget=  1      ; 1 -> plot routine can return just data to file
                  ; 0 -> feature disabled
END


;******************************************************************************
;* PROCEDURE:     
;*      PRO descriptor_lanl_geo, plotInfo, descriptStr
;*
;* DESCRIPTION:  
;*	Constructs the string used to label plots in the panel window
;*
;* INPUTS:       
;*	plotInfo        structure containing all data for this plot.
;*                      (structure type: PAPCO_PLOTINFO, 
;*                                             see papco_variables.text) 
;*
;* OUTPUTS: 
;*   	descriptStr	a string containing the label
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	descriptor_lanl_geo, plotInfo, descriptStr
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;*     modified september 1997, Torsten Heise
;******************************************************************************
PRO descriptor_lanl_geo, plotInfo, descriptStr

COMMON lanl_geo                 ;see lanl_geo_commons.pro for contents

control = *plotinfo.USR_PTR1
source_names = papco_make_choice_names(control.type_info)
descriptStr = descriptStr + 'Sat-ID: ' + sat_names(control.sc_id)+', '+$
              source_names(control.type)

END


;******************************************************************************
;* PROCEDURE:     
;*      PRO addpanel_lanl_geo
;*
;* DESCRIPTION:  
;*	Calls the panel editor for this plottype and adds the plot to the
;*      panel window.
;*      using an instance of the PAPCO_PLOTINFO structure called "defaults"
;*      the default settings of the panel editor can be controlled.
;*      panelEditor must be set to the name of the panel editor routine
;*
;* INPUTS:       
;*	event		event value of papco main window. This is
;*                      only used if there are plot sub_types, 
;*                      for example see papcoadd_crres_plots
;*
;* OUTPUTS: 
;*   	none
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	addpanel_lanl_geo
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro addpanel_lanl_geo,event

COMMON PLOT_COMPOSER, widgetData
COMMON get_error, get_err_no, get_err_msg

; The case statement here needs an entry for every submenu type you
; added in  the first procedure in this file (addplottype_gps_eph).
; For each submenu entry, you will need to specify the panelEditor to use.  
  
; The FIRST time you use this module you will have to configure it,
; i.e. set the data paths etc. Once you have done this PAPCO will
; write a gps_eph.config file into your papco_user_XX/papco_modules_defaults
; directory. 
; So here we check if this gps_eph.config file exists, and if not,
; we disallow the execution of any other option apart from "configure
; gps_eph". In this way the user is forced to configure the module
; before using it the first time!

panelKind='lanl_geo'

r_module_config, panelKind, config_data, msg
IF (get_err_no NE 0) AND (event.value NE 1) THEN BEGIN 
    message, 'You need to configure the module first', /cont
    papco_module_configure,panelKind
    return
ENDIF   

CASE event.value of
    1: BEGIN
        papco_module_configure, panelKind
    END 
    2: BEGIN  
        panelEditor = panelKind+'_panel'
        defaults = papco_getPlotInfoStruct()
        PAPCO_Add_Plot, panelEditor, panelKind, initialPlotInfo=defaults
    END 

    ELSE: BEGIN 
        message,'Nothing defined for this submenu entry', /cont
        return
    END 
ENDCASE 

END


;******************************************************************************
;* PROCEDURE:     
;*      PRO draw_lanl_geo, panelVector, currPlotInfo, orbitNo $
;*                          get_data_call, slice_type, IsRead
;* DESCRIPTION:  
;*	This procedure performs the actual plot call
;*      for this plottype.
;*      See plot_LA_plot, too.
;*
;* INPUTS:       
;*	panelVector	position of the plot (see papco_conventions.text, 6)
;*	currPlotInfo	structure containing all data for this plot.
;*                      (structure type: PAPCO_PLOTINFO, 
;*                                             see papco_variables.text) 
;*
;* OUTPUTS: 
;*   	get_data_call	a string containing the data call. Used by other
;*                      routines that need to know how to get the data
;*                      in a panel, e.g. to draw spectra, distrib. functions
;*      IsRead		a boolean which is set when the the data is read the
;*                      first time. Useful if a given data read puts data
;*                      into commons which can be plotted in many ways.
;*                      When set, data does not have to be read again.
;*     slice_type:   Selects which slices are supported and for which slice
;*                   routines have been written.
;*                   This is an integer logical with 16 swittches. Currently
;*                   there are 5 papco slices. You may extend this by
;*                   further USER slices up to a total of 16 slices.
;*                       0 = disable all slices
;*                       1 = papco Zoom                 (2^0)
;*                       2 = papco View Slice           (2^1)
;*                       4 = papco Access level Zero    (2^2)
;*                       8 = papco Write Paneldata      (2^3)
;*                      16 = papco Hair Cursor          (2^4)
;*                      32 = USER slice A or not used   (2^5)
;*                      64 = USER slice B or not used   (2^6)
;*                      "     "     "   "  "  "    "      "    
;*                   32768 = USER slice Z or not used  (2^15)
;*                          
;*     You can support more than one type of slice by arithmetically adding the
;*     options, eg slice_type=1+4  support Zoom and Level Zero;*
;*                          
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	draw_lanl_geo, panelVector, currPlotInfo, orbitNo, $
;*                                 get_data_call, slice_type, IsRead
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;*     select one or all satellites, september 1997 Torsten Heise
;*     modified september 1997, Torsten Heise
;******************************************************************************
PRO draw_lanl_geo, panel, PlotInfo, orbitNo, $
                   get_data_call, slice, IsRead, OUTPUT=OUTPUT

COMMON extra, extra_plotinfo
COMMON get_error, get_err_no, get_err_msg
COMMON yscale, yscl   ;man/auto yscaling 
                      ;(must be buffered when retrieving the mpa data
  
IF keyword_set(OUTPUT) THEN output = OUTPUT ELSE output = 0

control = *plotinfo.USR_PTR1

get_data_call=''
getcall = 'r_lanl_geo'

; select the plot call either for line or for spectrum
IF control.graph EQ 0 THEN $
    plotcall = 'p_lanl_geo_line' ELSE plotcall = 'p_lanl_geo_spec' 

; set up which mouse functions to allow
slice = 1+2+8+16

IF control.pl_type GT 0 THEN BEGIN ;pitch angle plot
   plotcall = 'p_lanl_geo_pitch'
   getcall = 'r_lanl_geo_pitch'

   ; set up which mouse functions to allow
   user_slice_1 = PAPCO_SLICE_value('USER PA Slice')
   slice = 1+8+16+user_slice_1
ENDIF 

IF NOT IsRead THEN BEGIN

    buf_yscl = yscl
    buf_extra_plotinfo = extra_plotinfo

    call_procedure, getcall, PlotInfo

    yscl = buf_yscl
    extra_plotinfo = buf_extra_plotinfo

    ; check the read for success.
    IF (output EQ 2) AND (get_err_no NE 0) THEN return

    IF papco_Draw_CheckResult(PlotInfo.panelKind, panel, orbitNr, $
                          PlotInfo.typeVector, PlotInfo.channel) $
                                               THEN IsRead=1 ELSE IsRead=0
ENDIF

IF IsRead THEN call_procedure, plotcall, panel, PlotInfo, $
                               OUTPUT=OUTPUT, _EXTRA=extra_PlotInfo
IsRead=0
  
END
