;******************************************************************************
;*  NAME:        a_lanl_geo
;*
;*  DESCRIPTION: example routine for access to lanl_geo module's data
;*               For use inside the PAPCO environment 
;*               (papco is compiled, required modules are loaded)
;*               
;*                                  Uses MJDT time
;*                                  papco read philosophy 
;*
;*  INPUT:       
;*
;*  OUTPUT:      none (places data into common blocks)
;*
;*  KEYWORDS:    VERBOSE  -  enables print comments, save/restore comments
;*               T1       -  start date/time in any PAPCO format, string
;*               T2       -  end date/time in any PAPCO format, string
;*               SAT_ID   -  name of satellite
;*               PLOTINFO - papco structure containing information on
;                           what output data you want (see lanl_geo_commons.pro)                           
;*         
;*  Enter a time in one of these formats: date time, date
;*  where time is in one of those formats: h:m:s, h:m
;*  and date is in one of those formats: m/d/y, doy/y, d.m.y, m/d/y, yyyymmdd
;*  where d is day and doy is day of year, h:m:s is the time
;*  (year > 1990 if you use T90 format)
;*  e.g: 1/90 14:11, 1/1990 1:1:1, 350/1991 01:00:03
;*       15.1.90 14:11, 1/15/1990 15:3:1                  
;*
;*  DATE:        March 2003
;*
;*  AUTHOR:       R. Friedel
;*
;*  CHANGES:      A. Aasnes, updated to version 10, structure with pointers   
;******************************************************************************
PRO a_lanl_geo, SAT_ID = sat_id, T1 = t1, T2 = t2, TYPE = type, GRAPH = graph,CAL = cal, MU = mu,  RES = res,  PA_RES = pa_res,  PL_TYPE = pl_type, PA_BIN1 = pa_bin1,  PA_BIN2 = pa_bin2,  EK1 = ek1,  EK2 = ek2,  FILTER = filter, PLOTINFO = plotinfo, MJDT = MJDT 
  papco, /set_only              ;only initializes papco then exists.

  IF NOT keyword_set(T1) THEN BEGIN
     message, 'No start time (T1) defined', /cont & return
  ENDIF 
  
  IF NOT keyword_set(T2) THEN BEGIN
     message, 'No end time (T2) defined', /cont & return
  ENDIF 
  COMMON mjdt, mjdt_start, mjdt_end

  IF keyword_set(MJDT) THEN BEGIN 
     mjdt_start = T1
     mjdt_end = T2
  ENDIF ELSE BEGIN 
     result = convert_timeToSeconds(T1, /T90, /MJDT)
     IF result.err EQ 0 THEN mjdt_start =result.value ELSE BEGIN
        message, 'Error in start time (T1)', /cont
        print,  result.errtext
        return
     ENDELSE
     
     result = convert_timeToSeconds(T2, /T90, /MJDT)
     IF result.err EQ 0 THEN mjdt_end =result.value ELSE BEGIN
        message, 'Error in end time (T2)', /cont
        print,  result.errtext
        return
     ENDELSE 
  ENDELSE 
  tai1=utc2tai({mjd:mjdt_start.mjd, time:mjdt_start.t*1000})
  tai2=utc2tai({mjd:mjdt_end.mjd, time:mjdt_end.t*1000})    
  
  common lanl_geo_pitch_data, geo_header, geo_data
  common slice_lanl_geo2, time, ymat, utitle, uytitle, ych

  COMMON lanl_geo
  
  IF keyword_set(PLOTINFO) THEN new_plotinfo = plotinfo ELSE BEGIN 
     new_plotinfo = papco_getplotinfostruct()
     new_control = lanl_geo_control
     new_control.sc_id = where(strupcase(sat_id) EQ sat_names)    
     IF keyword_set(TYPE) THEN new_control.type = type ELSE new_control.type = 0
     IF keyword_set(GRAPH) THEN new_control.graph = graph ELSE new_control.graph =  0 ; line plot or spectral plot
     IF keyword_set(CAL) THEN new_control.cal = cal ELSE new_control.cal = 1 ; counts or flux
     IF keyword_set(PA_RES) THEN new_control.pa_res = pa_res ELSE new_control.pa_res = 10     
     IF keyword_set(PL_TYPE) THEN new_control.pl_type = pl_type ELSE new_control.pl_type = 0 ;pa for one energy channel 
     new_plotinfo.USR_PTR1 = ptr_new(new_control) 
  ENDELSE
;  IF new_control.pl_type EQ THEN r_lanl_geo, new_plotinfo ELSE r_lanl_geo_pitch, new_plotinfo
;Finally you're set to read / make the data!
  yscl = make_array(1, 4, value = 0) 
  panel = [0, 1, 1]
  orbitNo = 0
;plotinfo we set above
  IsRead = 0
  output = 2
  

  draw_lanl_geo, panel, new_PlotInfo, orbitNo, get_data_call, slice_type, IsRead, OUTPUT = output

END
