;*****************************************************************************
; Batch file to run the salammbo code for an arbitrary time set up by PAPCO
;                            
; keywords:        sat_id - string, id of geo sat to be used for boundary 
;*****************************************************************************
PRO m_salammbo, SAT_ID = SAT_ID, HAVE_MAP = HAVE_MAP,  NORUN = NORUN

COMMON PLOT_COMPOSER, widgetData
COMMON mjdt, mjdt_start, mjdt_end     ;common time limit in mjdt
COMMON yscale, yscl		      ;man/auto yscaling
COMMON zscale, zscl		      ;man/auto yscaling
COMMON lanl_geo
COMMON extra, extra_plotinfo

papco, /set_only

yscl = fltarr(10, 4)
zscl = fltarr(10, 4)
extra_plotinfo = {color:0, thick:1, psym:0, linestyle:0}

IF keyword_set(SAT_ID) THEN sat_id = SAT_ID ELSE sat_id = '1994-084'
index = where(sat_names EQ sat_id, c)
IF c NE 0 THEN sat_idx = index(0) ELSE BEGIN
    message, 'Sat '+sat_id+' does not exist', /cont
    return
END

;get some timestrings from papco time common block
convert_t90_to_Date, mjdt_start,year,doy, hr, min, sec, mon, cmon, dom, /MJDT
tai_1=UTC2TAI({YEAR:year, MONTH:mon, DAY:dom, HOUR:hr, MINUTE:min, $
               SECOND:sec, MILLISECOND:0})
st_sec = UTC2TAI({year:year, MONTH:1, DAY:1, $
                  HOUR:0, MINUTE:0, SECOND:0, MILLISECOND:0})
en_sec = UTC2TAI({year:year+1, MONTH:1, DAY:1, $
                  HOUR:0, MINUTE:0, SECOND:0, MILLISECOND:0})
year_sec = en_sec-st_sec

t1_str = string(year, mon, dom, format = "(i4.4,i2.2,i2.2)")

convert_t90_to_Date, mjdt_end,year,doy, hr, min, sec, mon, cmon, dom, /MJDT
tai_2=UTC2TAI({YEAR:year, MONTH:mon, DAY:dom, HOUR:hr, MINUTE:min, $
               SECOND:sec, MILLISECOND:0})
t2_str = string(year, mon, dom, format = "(i4.4,i2.2,i2.2)")
out_file = '/u/friedel/salammbo/geo_boundary/'+$
           SAT_ID+'_'+t1_str+'-'+t2_str

IF keyword_set(HAVE_MAP) THEN GOTO, write_namelist

;call the papco draw routine, trick it to produce ouput data only!
widgetData.PrintName = out_file

plotInfo = papco_getplotinfostruct()
plotInfo.ioptions(0) = 2         ;time res 5 min
;plotInfo.ioptions(0) = 0         ;time res 10 sec
plotInfo.ioptions(1) = 0         ;data source local
plotInfo.ioptions(2) = 1         ;calib = flux
plotInfo.ioptions(10) = sat_idx  ;satellite id
plotinfo.typevector(*) = 0       ;select channels to use - the first 9
for i=0, 8 DO plotinfo.typevector(0) = plotinfo.typevector(0)+2ll^i
output = 3 & panel = [0, 1, 1] & IsRead = 0

draw_lanl_geo, panel, plotInfo, orbitNo, $
                      get_data_call, slice_type, IsRead, $
                      OUTPUT=OUTPUT

;now write the salammbo namelist file needed!
write_namelist:
message, 'Writing Salammbo namelist file', /cont
year = string(year, format = "(i4.4)")
start_decimal_year = year+(tai_1 - st_sec) / year_sec 
duration = tai_2-tai_1
output_file = '/u/friedel/salammbo/salammbo_output/'+$
              SAT_ID+'_'+t1_str+'-'+t2_str

fln = '/u/friedel/salammbo/salammbo3D_dyn/solve/salammbo_lanl.nml'
openw, u, fln, /get_lun
printf, u, " $CONTROL"
printf, u, "  omni_path    = '/n/radbelt/dlnk/omni/omni_"+year+".dat'"
printf, u, "  initial_state = 'E25_Init_24sep91'"
printf, u, "  geo_boundary = '"+out_file+".map'"
printf, u, "  salammbo_output = '"+output_file+"'"
printf, u, "  year = "+string(start_decimal_year, format = "(f13.8)")
printf, u, "  Tmax = "+string(duration, format = "(f13.2)") 
printf, u, "  PasT = 34.56" 
printf, u, "  nqs  = 156" 
printf, u, " $END" 
close, u & free_lun,u

IF keyword_set(NORUN) THEN GOTO, graph

;now run the simulation code!
CD, '/u/friedel/salammbo/salammbo3D_dyn/solve', current = keep_path
message, 'Running Salammbo_dyn_lanl...', /cont
spawn, 'Salammbo_dyn_lanl', run_arr
CD, keep_path

;write a log of the run's output
message, 'Writing log of run', /cont
fln = '/u/friedel/salammbo/logs/'+'lanl_geo_'+SAT_ID+'_'+t1_str+'-'+t2_str
openw, u, fln, /get_lun
FOR i = 0, n_elements(run_arr)-1 DO printf, u, run_arr(i)
close, u & free_lun,u
 
graph:

;now make the rerquired output files for plotting - equatorial fluxes
;at several energies.
;use program MapFomniLt, controlled through namelist "graph_lanl.nml"
;
;The energy of the L-plot map is set through variable "ks".
;Following ks can be set for corresponding energies in MeV
;   1  1.0000000000000000E-003
;   2  1.5848931924611138E-003
;   3  2.5118864315095801E-003
;   4  3.9810717055349730E-003
;   5  6.3095734448019325E-003
;   6  1.0000000000000000E-002
;   7  1.5848931924611143E-002
;   8  2.5118864315095806E-002
;   9  3.9810717055349730E-002
;  10  6.3095734448019325E-002
;  11  0.1000000000000000     
;  12  0.1584893192461114     
;  13  0.2511886431509582     
;  14  0.3981071705534973     
;  15  0.6309573444801937     
;  16   1.000000000000000     
;  17   1.584893192461114     
;  18   2.511886431509582     
;  19   3.981071705534974     
;  20   6.309573444801937     
;  21   10.00000000000000     

ek_list = [11, 13, 15, 16, 17, 18, 19, 20]

FOR i = 0, n_elements(ek_list)-1 DO BEGIN

    ks_str = varprt(ek_list(i))
    ;write the graph namelist file needed!
    message, 'Writing Graph namelist file', /cont
    fln = '/u/friedel/salammbo/salammbo3D_dyn/graph/graph_lanl.nml'
    openw, u, fln, /get_lun
    printf, u, " $CONTROL_MAPFOMNILT"
    printf, u, "  fichier = '"+output_file+"'"
    printf, u, "  year = "+string(start_decimal_year, format = "(f13.8)")
    printf, u, "  ks = " + ks_str
    printf, u, "  out_file= '"+output_file+"_"+ks_str+"_fluxomniE.map"+"'"
    printf, u, " $END" 
    close, u & free_lun,u

    ;now run MapFomniLt
    CD, '/u/friedel/salammbo/salammbo3D_dyn/graph', current = keep_path
    message, 'Running MapFomniLt...', /cont
    spawn, 'MapFomniLt';, run_arr
    CD, keep_path
    
ENDFOR 


END
