;***************************************************************************
;* 
;* PROCEDURE:     
;*      pro panelset_la
;* 
;* DESCRIPTION:
;*      routine to et up viewport using the information in the vector
;*      panel.
;*      changes to the over all look of the panel plot can be made
;*      here
;*
;* INPUTS:       
;*      panel(0) - is the number of the panel (numbered from 0 from the bottom of the
;*                 page up
;*      panel(1) - is the total number of panels
;*      panel(2) - is the height of a panel in multiples of panel height with is given
;*                 by viewport divided by number of panels.
;*
;* KEYWORDS:
;*      none
;*      
;* OUTPUT: 
;*      sets the global IDL system variable !p.position
;*
;* CALLING SEQUENCE:
;*      panelset_la, panel
;*
;* MODIFICATION HISTORY:       
;*	written October 1995, R. Friedel
;*      modified september 1997, Torsten Heise
;***************************************************************************
pro panelset_la, panel

  pheight=0.85/panel(1)    
  pypos1=0.12+pheight*panel(0)
  pypos2=0.095+pheight*(panel(0)+panel(2))
  !p.position=[0.125, pypos1, 0.80, pypos2]

end
