;+
; NAME:
;     READASCII
;
; 
;
; PURPOSE:
;     Read in the contents of a SOPA ascii file, and return it to
;     data handling
;
; AUTHOR:
;     Arne Aasnes
;
; CALLING SEQUENCE:
;     data = READASCII( infile [,/VERBOSE] )
;
; INPUTS:
;     infile	- name of binary file to read
;     start_time - decimal day of year
;     end_time - decimal day of year
;
; KEYWORDS:
;     /verbose	- Read emitting progress reports.
;
; OUTPUTS:
;     A data structure containing all the elements in the binary
;
;
;
;;
; Ascii file format:
;     decimal of day, az1det1,az1det2,az1det3,
;     az2det1,az2det2,az2det3,.....az32det1,az32det2,az32det3.      
; 


FUNCTION  readascii, infile, VERBOSE = verbose;,  TimeSeries = timeseries

COMMON get_error,  get_err_no,  get_err_msg

IF strpos(infile, '_esp_') NE -1 THEN BEGIN ;reading esp data


   fieldnam = make_array(33, value = 'counts')
   fieldnam(0) = 'decimal_doy' 
   fieldloc = [ 5l, 15l, 23l, 31l, 39l, 47l, 55l, 63l, 71l, 79l, 87l, 95l, 103l, 111l, 119l, 127l, 135l, $
        143l, 151l, 159l, 167l, 175l, 183l, 191l,  199l, 207l, 215l, 223l, 231l, 239l, 247l, 255l, 263l]
   fieldgr = make_array(33, value = 1) & fieldgr(0) = 0
   fieldty = make_array(33, value = 5)
   

   esp_templ = {version:1.0e, datastart:0l,delimiter:byte(32), missingvalue:!values.F_nan, commentsymbol:'', $
            fieldcount:33l, fieldtypes:fieldty, fieldnames:fieldnam, $
            fieldlocations:fieldloc, fieldgroups:fieldgr}

   data = read_ascii(infile, template = esp_templ)
ENDIF ELSE BEGIN 
;   det_1_ind = indgen(32)*3+1
;   det_2_ind = indgen(32)*3+2
;   det_3_ind = indgen(32)*3+3
;   fieldnam = strarr(97)
;   fieldnam(0) = 'decimal_doy'
;   fieldnam(det_1_ind) = 'counts_det_1'
;   fieldnam(det_2_ind) = 'counts_det_2'
;   fieldnam(det_3_ind) = 'counts_det_3'
;   fieldloc = lindgen(97)*8l+9l
;   fieldloc(0) = 5l
;   fieldgr = intarr(97) & fieldgr(0) = 0 &  fieldgr(det_1_ind) = 1
;   fieldgr(det_2_ind) = 2 & fieldgr(det_3_ind) = 3
;   fieldty = make_array(97, value = 5)

;   reg_templ = {version:1.0e, datastart:0l,delimiter:byte(32), missingvalue:!values.F_nan, commentsymbol:'', $
;            fieldcount:97l, fieldtypes:fieldty, fieldnames:fieldnam, $
;            fieldlocations:fieldloc, fieldgroups:fieldgr}

;   data = read_ascii(infile, template = reg_templ)

   read_dummy = dblarr(97)

   struct_dummy = {sopa_pitch_raw, decimal_doy:0d, counts:dblarr(3, 32)}

   max_rec_no = 90000
   data = replicate(struct_dummy, max_rec_no)
   
;   IF keyword_set(verbose) THEN print, 'Opening '+infile+' for reading...'
   ON_IOERROR, no_file
   
   openr, unit, infile, /get_lun

   count = 0d
   WHILE NOT EOF(unit) DO BEGIN 
      readf, unit, read_dummy
      struct_dummy.decimal_doy = read_dummy(0)
      counts_arr = read_dummy(1:96)
      struct_dummy.counts = reform(counts_arr, 3, 32)
      
      data(count) = struct_dummy

   
      count = count+1
   ENDWHILE 

   close, unit
   free_lun, unit
   data = data(0:count)
   WHILE data(count).decimal_doy EQ 0 DO BEGIN 
      data = data(0:count-1)
      count = count-1
   ENDWHILE 
ENDELSE    
return, data

no_file:

IF keyword_set(verbose) THEN print, 'Error reading '+infile+'!!!'
get_err_no = 1 & get_err_msg = 'Readascii: file not found!'

return, 0
end
